/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.world.gen.feature.coral;

import com.google.common.collect.Lists;
import git.jbredwards.subaquatic.mod.common.world.gen.feature.coral.ICoralBlockSupplier;
import git.jbredwards.subaquatic.mod.common.world.gen.feature.coral.ICoralStructure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public enum CoralStructureClaw implements ICoralStructure
{
    INSTANCE;


    @Override
    public void generate(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull ICoralBlockSupplier coralBlock) {
        if (this.placeCoralBlock(world, rand, pos, coralBlock)) {
            EnumFacing primarySide = EnumFacing.field_176754_o[rand.nextInt(EnumFacing.field_176754_o.length)];
            ArrayList sidesToGen = Lists.newArrayList((Object[])new EnumFacing[]{primarySide, primarySide.func_176746_e(), primarySide.func_176735_f()});
            Collections.shuffle(sidesToGen);
            sidesToGen.subList(0, rand.nextInt(2) + 2).forEach(side -> {
                int i;
                int amountToGen;
                BlockPos.MutableBlockPos posToGen = new BlockPos.MutableBlockPos(pos);
                posToGen.func_189536_c(side);
                if (side == primarySide) {
                    amountToGen = rand.nextInt(3) + 2;
                } else {
                    posToGen.func_189536_c(EnumFacing.UP);
                    if (rand.nextBoolean()) {
                        side = EnumFacing.UP;
                    }
                    amountToGen = rand.nextInt(3) + 3;
                }
                int max = rand.nextInt(2) + 1;
                for (i = 0; i < max && this.placeCoralBlock(world, rand, posToGen.func_185334_h(), coralBlock); ++i) {
                    posToGen.func_189536_c(side);
                }
                posToGen.func_189536_c(side.func_176734_d());
                posToGen.func_189536_c(EnumFacing.UP);
                for (i = 0; i < amountToGen; ++i) {
                    posToGen.func_189536_c(primarySide);
                    if (!this.placeCoralBlock(world, rand, posToGen.func_185334_h(), coralBlock)) break;
                    if (!((double)rand.nextFloat() < 0.25)) continue;
                    posToGen.func_189536_c(EnumFacing.UP);
                }
            });
        }
    }
}

