/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.world.gen.feature.coral;

import git.jbredwards.subaquatic.mod.common.world.gen.feature.coral.ICoralBlockSupplier;
import git.jbredwards.subaquatic.mod.common.world.gen.feature.coral.ICoralStructure;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public enum CoralStructureTree implements ICoralStructure
{
    INSTANCE;


    @Override
    public void generate(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull ICoralBlockSupplier coralBlock) {
        BlockPos.MutableBlockPos posToGen = new BlockPos.MutableBlockPos(pos);
        int max = rand.nextInt(4);
        for (int i = 0; i < max; ++i) {
            if (!this.placeCoralBlock(world, rand, posToGen.func_185334_h(), coralBlock)) {
                return;
            }
            posToGen.func_189536_c(EnumFacing.UP);
        }
        List<EnumFacing> facesToGen = Arrays.asList(EnumFacing.field_176754_o);
        Collections.shuffle(facesToGen);
        facesToGen.subList(0, rand.nextInt(3) + 2).forEach(side -> {
            posToGen.func_189533_g((Vec3i)pos);
            posToGen.func_189536_c(side);
            int branchHeight = 0;
            int maxHeight = rand.nextInt(5) + 2;
            for (int i = 0; i < maxHeight && this.placeCoralBlock(world, rand, posToGen.func_185334_h(), coralBlock); ++i) {
                posToGen.func_189536_c(EnumFacing.UP);
                if (i != 0 && (++branchHeight < 2 || !((double)rand.nextFloat() < 0.25))) continue;
                posToGen.func_189536_c(side);
                branchHeight = 0;
            }
        });
    }
}

