/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.world.gen.feature.coral;

import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.subaquatic.mod.common.world.gen.feature.GeneratorCoral;
import git.jbredwards.subaquatic.mod.common.world.gen.feature.coral.ICoralBlockSupplier;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public interface ICoralStructure {
    public void generate(@Nonnull World var1, @Nonnull Random var2, @Nonnull BlockPos var3, @Nonnull ICoralBlockSupplier var4);

    default public boolean placeCoralBlock(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull ICoralBlockSupplier coralBlock) {
        IBlockState up;
        if (this.canPlaceCoralAt(world.func_180495_p(pos), coralBlock) && this.canPlaceCoralAt(up = world.func_180495_p(pos.func_177984_a()), coralBlock)) {
            if ((double)rand.nextFloat() < 0.2) {
                ICoralBlockSupplier coralFin;
                ICoralBlockSupplier iCoralBlockSupplier = coralFin = (double)rand.nextFloat() < 0.2 ? GeneratorCoral.CORAL_FANS.get(rand.nextInt(GeneratorCoral.CORAL_FANS.size())) : GeneratorCoral.CORAL_FINS.get(rand.nextInt(GeneratorCoral.CORAL_FINS.size()));
                if (this.canPlaceCoralAt(up, coralFin)) {
                    world.func_180501_a(pos.func_177984_a(), coralFin.withDirection(EnumFacing.UP), 2);
                }
            }
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                if (!((double)rand.nextFloat() < 0.2)) continue;
                ICoralBlockSupplier coralFan = GeneratorCoral.CORAL_FANS.get(rand.nextInt(GeneratorCoral.CORAL_FANS.size()));
                BlockPos offset = pos.func_177972_a(facing);
                if (!this.canPlaceCoralAt(world.func_180495_p(offset), coralFan)) continue;
                world.func_180501_a(offset, coralFan.withDirection(facing), 2);
            }
            world.func_180501_a(pos, coralBlock.getBlock().func_176223_P(), 2);
            return true;
        }
        return false;
    }

    default public boolean canPlaceCoralAt(@Nonnull IBlockState here, @Nonnull ICoralBlockSupplier coral) {
        return FluidloggedUtils.isCompatibleFluid((Fluid)coral.getNeededFluid(), (Fluid)FluidloggedUtils.getFluidFromState((IBlockState)here));
    }
}

