/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.common.world.gen.layer;

import git.jbredwards.subaquatic.api.biome.IOceanBiome;
import git.jbredwards.subaquatic.api.event.GetOceanForGenEvent;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticConfigHandler;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticBiomes;
import git.jbredwards.subaquatic.mod.common.world.gen.NoiseGeneratorOceans;
import git.jbredwards.subaquatic.mod.common.world.gen.layer.GenLayerOceanBiomeMask;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class GenLayerOceanBiomes
extends GenLayer {
    static final int OCEAN = Biome.func_185362_a((Biome)Biomes.field_76771_b);
    static final int DEEP_OCEAN = Biome.func_185362_a((Biome)Biomes.field_150575_M);
    static final int DEEP_FROZEN_OCEAN = Biome.func_185362_a((Biome)SubaquaticBiomes.DEEP_FROZEN_OCEAN);
    @Nonnull
    private final GenLayer wrapped;
    private NoiseGeneratorOceans temperatureGenerator;

    public GenLayerOceanBiomes(long seed, @Nonnull GenLayer wrappedIn) {
        super(seed);
        this.wrapped = wrappedIn;
    }

    @Nonnull
    public int[] func_75904_a(int areaX, int areaZ, int areaWidth, int areaHeight) {
        int[] biomeInts = (int[])this.wrapped.func_75904_a(areaX - 1, areaZ - 1, areaWidth + 2, areaHeight + 2).clone();
        IntCache.func_76446_a();
        int[] out = GenLayerZoom.func_75915_a((long)2001L, (GenLayer)new GenLayerOceanBiomeMask(this.field_75906_d, this.temperatureGenerator), (int)SubaquaticConfigHandler.Server.World.General.oceanBiomeSize).func_75904_a(areaX, areaZ, areaWidth, areaHeight);
        for (int x = 0; x < areaWidth; ++x) {
            for (int z = 0; z < areaHeight; ++z) {
                int biomeId = biomeInts[x + 1 + (z + 1) * (areaWidth + 2)];
                if (biomeId == DEEP_OCEAN) {
                    out[x + z * areaWidth] = GenLayerOceanBiomes.handleDeepOceanGen(Biome.func_185357_a((int)out[x + z * areaWidth]));
                    continue;
                }
                if (biomeId == OCEAN) continue;
                out[x + z * areaWidth] = biomeId;
            }
        }
        return out;
    }

    public void func_75905_a(long seed) {
        super.func_75905_a(seed);
        this.temperatureGenerator = new NoiseGeneratorOceans(new Random(seed));
    }

    static int handleDeepOceanGen(@Nullable Biome shallowOcean) {
        int deepOcean;
        if (shallowOcean instanceof IOceanBiome && (deepOcean = ((IOceanBiome)shallowOcean).getDeepOceanBiomeId()) != -1) {
            return deepOcean;
        }
        return shallowOcean == Biomes.field_76776_l ? DEEP_FROZEN_OCEAN : DEEP_OCEAN;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    static void handleGenLayerWrappers(@Nonnull WorldTypeEvent.InitBiomeGens event) {
        GenLayer[] wrappedLayers = new GenLayer[event.getNewBiomeGens().length];
        for (int i = 0; i < wrappedLayers.length; ++i) {
            GenLayer layer = event.getNewBiomeGens()[i];
            if (layer instanceof GenLayerVoronoiZoom) {
                layer.field_75909_a = new GenLayerOceanBiomes(2L, layer.field_75909_a);
                layer.field_75909_a.func_75905_a(event.getSeed());
                wrappedLayers[i] = layer;
                continue;
            }
            wrappedLayers[i] = new GenLayerOceanBiomes(2L, layer);
            wrappedLayers[i].func_75905_a(event.getSeed());
        }
        event.setNewBiomeGens(wrappedLayers);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    static void handleShallowOceanGen(@Nonnull GetOceanForGenEvent event) {
        if (event.temperatureNoise > 0.4) {
            event.setOcean((Biome)SubaquaticBiomes.WARM_OCEAN);
        } else if (event.temperatureNoise > 0.2) {
            event.setOcean((Biome)SubaquaticBiomes.LUKEWARM_OCEAN);
        } else if (event.temperatureNoise < -0.4) {
            event.setOcean(Biomes.field_76776_l);
        } else if (event.temperatureNoise < -0.2) {
            event.setOcean((Biome)SubaquaticBiomes.COLD_OCEAN);
        }
    }
}

