/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.block.entity;

import cofh.redstoneflux.api.IEnergyReceiver;
import com.google.common.base.Strings;
import fossilsarcheology.Revival;
import fossilsarcheology.server.block.CultivateBlock;
import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.block.entity.DirectionalInvWrapper;
import fossilsarcheology.server.block.entity.FAEnergyStorage;
import fossilsarcheology.server.compat.jei.culture.CultivateRecipes;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import fossilsarcheology.server.item.DNAItem;
import fossilsarcheology.server.item.FAItemRegistry;
import fossilsarcheology.server.recipe.FAMachineRecipeRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.IWorldNameable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyReceiver", modid="redstoneflux", striprefs=true)
public class TileEntityCultivate
extends TileEntity
implements ITickable,
IWorldNameable,
IEnergyReceiver {
    public final IItemHandlerModifiable inputInventory = new ItemStackHandler(1);
    private final IItemHandlerModifiable fuelInventory = new ItemStackHandler(1);
    private final IItemHandlerModifiable outputInventory = new ItemStackHandler(1);
    public final IItemHandlerModifiable globalInventory = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.fuelInventory, this.outputInventory});
    private final IItemHandlerModifiable wrappedOutputInventory = new DirectionalInvWrapper(this.outputInventory, DirectionalInvWrapper.Mode.OUTPUT);
    public int fuelTime = 0;
    public int totalFuelTime = 0;
    public int cultivationTime = 0;
    public boolean isActive;
    public boolean isPlant;
    public FAEnergyStorage energyStorage;
    private String customName;

    public TileEntityCultivate() {
        this.energyStorage = new FAEnergyStorage(Revival.CONFIG_OPTIONS.machineMaxEnergy, Revival.CONFIG_OPTIONS.machineTransferRate, Revival.CONFIG_OPTIONS.machineTransferRate, 0);
    }

    public static int getItemFuelTime(ItemStack stack) {
        if (!stack.func_190926_b()) {
            ItemStack output = new ItemStack(stack.func_77973_b(), 1);
            return CultivateRecipes.getFuelValue(output);
        }
        return 0;
    }

    public static ItemStack getCultivationOutput(ItemStack input) {
        if (input.func_77973_b() == FAItemRegistry.FOSSIL_SEED_FERN) {
            return new ItemStack((Item)FAItemRegistry.FERN_SEED, 1);
        }
        if (input.func_77973_b() == FAItemRegistry.PALAE_SAPLING_FOSSIL) {
            return new ItemStack((Block)FABlockRegistry.PALM_SAPLING, 1);
        }
        if (input.func_77973_b() == FAItemRegistry.CALAMITES_SAPLING_FOSSIL) {
            return new ItemStack((Block)FABlockRegistry.CALAMITES_SAPLING, 1);
        }
        if (input.func_77973_b() == FAItemRegistry.FOSSIL_SEED) {
            return new ItemStack((Item)FAItemRegistry.SEED, 1, input.func_77952_i());
        }
        if (PrehistoricEntityType.getEgg(input.func_77973_b()) != null) {
            return new ItemStack(PrehistoricEntityType.getEgg(input.func_77973_b()), 1);
        }
        if (PrehistoricEntityType.getEmbryo(input.func_77973_b()) != null) {
            return new ItemStack(PrehistoricEntityType.getEmbryo(input.func_77973_b()), 1);
        }
        if (PrehistoricEntityType.getBestBirdEgg(input.func_77973_b()) != null) {
            return new ItemStack(PrehistoricEntityType.getBestBirdEgg(input.func_77973_b()), 1);
        }
        return ItemStack.field_190927_a;
    }

    public static boolean canPutStackInInput(ItemStack stack) {
        if (stack != null && !stack.func_190926_b()) {
            ItemStack cultivatedStack = FAMachineRecipeRegistry.getCultivateResult(stack).func_77946_l();
            return !cultivatedStack.func_190926_b();
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.globalInventory, null, nbt.func_74781_a("inventory"));
        this.fuelTime = nbt.func_74765_d("fuel_time");
        this.cultivationTime = nbt.func_74765_d("cultivation_time");
        this.isPlant = nbt.func_74767_n("is_plant");
        this.totalFuelTime = TileEntityCultivate.getItemFuelTime(this.fuelInventory.getStackInSlot(0));
        this.energyStorage.deserializeNBT(nbt);
        if (nbt.func_74764_b("CustomName")) {
            this.customName = nbt.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("inventory", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.globalInventory, null));
        nbt.func_74777_a("fuel_time", (short)this.fuelTime);
        nbt.func_74757_a("is_plant", this.isPlant);
        nbt.func_74777_a("cultivation_time", (short)this.cultivationTime);
        if (this.customName != null) {
            nbt.func_74778_a("CustomName", this.customName);
        }
        NBTTagCompound secondTag = this.energyStorage.serializeNBT();
        nbt.func_74768_a("EnergyStored", secondTag.func_74762_e("EnergyStored"));
        return nbt;
    }

    private boolean isSeed(ItemStack stack) {
        return stack.func_77973_b() == FAItemRegistry.FOSSIL_SEED_FERN || stack.func_77973_b() == FAItemRegistry.CALAMITES_SAPLING_FOSSIL || stack.func_77973_b() == FAItemRegistry.PALAE_SAPLING_FOSSIL || stack.func_77973_b() == FAItemRegistry.FOSSIL_SEED;
    }

    public void func_73660_a() {
        if (Revival.CONFIG_OPTIONS.machinesRequireEnergy) {
            for (EnumFacing facing : EnumFacing.values()) {
                IEnergyStorage storage;
                if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing)) == null || !this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing)).hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()) || (storage = (IEnergyStorage)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing)).getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) == null) continue;
                int energy = storage.extractEnergy(Revival.CONFIG_OPTIONS.machineTransferRate, false);
                this.energyStorage.receiveEnergy(energy, false);
            }
        }
        boolean wasActive = this.cultivationTime > 0;
        boolean dirty = false;
        boolean bl = this.isActive = this.cultivationTime > 0;
        if (this.inputInventory.getStackInSlot(0).func_190926_b()) {
            this.isPlant = this.isSeed(this.inputInventory.getStackInSlot(0));
        }
        if (!(this.fuelTime <= 0 || Revival.CONFIG_OPTIONS.machinesRequireEnergy && this.energyStorage.energy <= 0)) {
            --this.fuelTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.fuelTime == 0 && this.canCultivate()) {
                ItemStack fuelStack = this.fuelInventory.getStackInSlot(0);
                this.totalFuelTime = this.fuelTime = TileEntityCultivate.getItemFuelTime(fuelStack);
                if (this.fuelTime > 0) {
                    dirty = true;
                    if (!fuelStack.func_190926_b()) {
                        ItemStack containerItem = fuelStack.func_77973_b().getContainerItem(fuelStack);
                        if (!containerItem.func_190926_b()) {
                            this.fuelInventory.setStackInSlot(0, containerItem);
                        } else {
                            fuelStack.func_190918_g(1);
                        }
                    }
                }
            }
            if (this.fuelTime > 0 && this.canCultivate()) {
                ++this.cultivationTime;
                this.energyStorage.extractEnergy(Revival.CONFIG_OPTIONS.machineEnergyUsage, false);
                if (this.cultivationTime >= 6000) {
                    this.cultivationTime = 0;
                    this.cultivate();
                    dirty = true;
                }
            } else if (this.cultivationTime != 0 && !this.canCultivate()) {
                this.cultivationTime = 0;
            }
            if (wasActive != this.cultivationTime > 0) {
                dirty = true;
                this.isPlant = this.isSeed(this.inputInventory.getStackInSlot(0));
                CultivateBlock.setState(this.cultivationTime > 0, this.field_145850_b, this.field_174879_c);
            }
        }
        if (dirty) {
            this.func_70296_d();
        }
        if (this.cultivationTime == 3001 && new Random().nextInt(100) < 20) {
            FABlockRegistry.CULTIVATE_IDLE.onBlockRemovalLost(this.field_145850_b, this.field_174879_c, true);
        }
    }

    private boolean canCultivate() {
        ItemStack inputStack;
        boolean hasPower = true;
        if (Revival.CONFIG_OPTIONS.machinesRequireEnergy) {
            boolean bl = hasPower = this.energyStorage.energy > 0;
        }
        if (!(inputStack = this.inputInventory.getStackInSlot(0)).func_190926_b()) {
            ItemStack cultivatedStack = FAMachineRecipeRegistry.getCultivateResult(inputStack).func_77946_l();
            if (cultivatedStack.func_190926_b()) {
                return false;
            }
            return hasPower && this.outputInventory.insertItem(0, cultivatedStack, true).func_190926_b();
        }
        return false;
    }

    public void cultivate() {
        if (this.canCultivate()) {
            ItemStack inputStack = this.inputInventory.extractItem(0, 1, false);
            ItemStack cultivatedStack = FAMachineRecipeRegistry.getCultivateResult(inputStack).func_77946_l();
            this.outputInventory.insertItem(0, cultivatedStack, false);
            ItemStack containerStack = inputStack.func_77973_b().getContainerItem(inputStack);
            if (!containerStack.func_190926_b()) {
                this.inputInventory.setStackInSlot(0, containerStack);
            }
        }
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int getDNAType() {
        ItemStack inputStack = this.inputInventory.getStackInSlot(0);
        if (!inputStack.func_190926_b()) {
            if (inputStack.func_77973_b() == PrehistoricEntityType.COELACANTH.dnaItem || inputStack.func_77973_b() == PrehistoricEntityType.STURGEON.dnaItem || inputStack.func_77973_b() == PrehistoricEntityType.ALLIGATOR_GAR.dnaItem) {
                return 1;
            }
            if (inputStack.func_77973_b() == FAItemRegistry.FOSSIL_SEED_FERN || inputStack.func_77973_b() == FAItemRegistry.CALAMITES_SAPLING_FOSSIL || inputStack.func_77973_b() == FAItemRegistry.PALAE_SAPLING_FOSSIL || inputStack.func_77973_b() == FAItemRegistry.SIGILLARIA_SAPLING_FOSSIL || inputStack.func_77973_b() == FAItemRegistry.CORDAITES_SAPLING_FOSSIL || inputStack.func_77973_b() == FAItemRegistry.FOSSIL_SEED) {
                return 2;
            }
            if (inputStack.func_77973_b() instanceof DNAItem && ((DNAItem)inputStack.func_77973_b()).isBugDNA()) {
                return 3;
            }
        }
        return 0;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && Revival.CONFIG_OPTIONS.machinesRequireEnergy) {
            return (T)this.energyStorage;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.globalInventory);
            }
            if (facing == EnumFacing.UP) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inputInventory);
            }
            if (facing == EnumFacing.DOWN) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.wrappedOutputInventory);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.fuelInventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, tag);
    }

    public void onDataPacket(NetworkManager netManager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "tile.cultivate.name";
    }

    public boolean func_145818_k_() {
        return !Strings.isNullOrEmpty((String)this.customName);
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int getEnergyStored(EnumFacing from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return Revival.CONFIG_OPTIONS.machinesRequireEnergy;
    }
}

