/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity;

import fossilsarcheology.Revival;
import fossilsarcheology.server.entity.ai.FishAIFindWaterTarget;
import fossilsarcheology.server.entity.prehistoric.EntityNautilus;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import fossilsarcheology.server.item.FAItemRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.client.model.tools.ChainBuffer;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityFishBase
extends EntityTameable {
    public final PrehistoricEntityType selfType;
    public BlockPos currentTarget;
    @SideOnly(value=Side.CLIENT)
    public ChainBuffer chainBuffer;
    private boolean turnedToItem = false;
    private int absoluteEggCooldown = 0;

    public EntityFishBase(World world, PrehistoricEntityType selfType) {
        super(world);
        this.field_175506_bl = Blocks.field_150355_j;
        this.field_70765_h = new SwimmingMoveHelper();
        this.field_70699_by = new PathNavigateSwimmer((EntityLiving)this, world);
        this.selfType = selfType;
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.chainBuffer = new ChainBuffer();
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new FishAIFindWaterTarget(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public boolean func_175446_cd() {
        return false;
    }

    public abstract String getTexture();

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    private void setPedia() {
        Revival.PEDIA_OBJECT = this;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return PrehistoricEntityType.FISH_LOOT;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void swimTowardsTarget() {
        if (this.currentTarget != null && this.isTargetInWater() && this.field_70171_ac) {
            double targetX = (double)this.currentTarget.func_177958_n() + 0.5 - this.field_70165_t;
            double targetY = (double)this.currentTarget.func_177956_o() + 1.0 - this.field_70163_u;
            double targetZ = (double)this.currentTarget.func_177952_p() + 0.5 - this.field_70161_v;
            this.field_70159_w += (Math.signum(targetX) * 0.5 - this.field_70159_w) * 0.100000000372529 * this.getSwimSpeed();
            this.field_70181_x += (Math.signum(targetY) * 0.5 - this.field_70181_x) * 0.100000000372529 * this.getSwimSpeed();
            this.field_70179_y += (Math.signum(targetZ) * 0.5 - this.field_70179_y) * 0.100000000372529 * this.getSwimSpeed();
            float angle = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
            float rotation = MathHelper.func_76142_g((float)(angle - this.field_70177_z));
            this.field_191988_bg = 0.5f;
            this.field_70177_z += rotation;
        }
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76368_d || super.func_180431_b(source);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("AbsEggTick", this.absoluteEggCooldown);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.absoluteEggCooldown = compound.func_74762_e("AbsEggTick");
    }

    protected abstract double getSwimSpeed();

    public void func_70071_h_() {
        super.func_70071_h_();
        Revival.PROXY.calculateChainBuffer(this);
        if (this.absoluteEggCooldown > 0) {
            --this.absoluteEggCooldown;
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityFishBase closestMate = this.getClosestMate();
            if (this.func_70090_H() && closestMate != null && this.func_70874_b() == 0 && closestMate.func_70874_b() == 0 && this.absoluteEggCooldown <= 0) {
                this.func_70873_a(48000 + this.field_70146_Z.nextInt(48000));
                closestMate.func_70873_a(48000 + this.field_70146_Z.nextInt(48000));
                this.absoluteEggCooldown = 48000 + this.field_70146_Z.nextInt(12000);
                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(this.selfType.eggItem)));
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.func_70873_a(12000);
        return super.func_180482_a(difficulty, livingdata);
    }

    public EntityFishBase getClosestMate() {
        EntityAINearestAttackableTarget.Sorter theNearestAttackableTargetSorter = new EntityAINearestAttackableTarget.Sorter((Entity)this);
        double d0 = 2.0;
        List list = this.field_70170_p.func_175647_a(((Object)((Object)this)).getClass(), this.func_174813_aQ().func_72321_a(d0, d0, d0), null);
        list.sort(theNearestAttackableTargetSorter);
        if (list.isEmpty()) {
            return null;
        }
        for (Entity entity : list) {
            if (!(entity instanceof EntityFishBase) || entity.func_70028_i((Entity)this)) continue;
            return ((EntityFishBase)entity).selfType == this.selfType ? (EntityFishBase)entity : null;
        }
        return null;
    }

    public boolean isInsideNautilusShell() {
        return this instanceof EntityNautilus && ((EntityNautilus)this).isInShell();
    }

    public boolean func_70090_H() {
        return super.func_70090_H() || this.func_70055_a(Material.field_151586_h) || this.func_70055_a(Material.field_151589_v);
    }

    protected boolean isTargetInWater() {
        return this.currentTarget != null && this.field_70170_p.func_180495_p(new BlockPos(this.currentTarget.func_177958_n(), this.currentTarget.func_177956_o(), this.currentTarget.func_177952_p())).func_185904_a() == Material.field_151586_h && this.field_70170_p.func_180495_p(new BlockPos(this.currentTarget.func_177958_n(), this.currentTarget.func_177956_o() + 1, this.currentTarget.func_177952_p())).func_185904_a() == Material.field_151586_h;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack != ItemStack.field_190927_a && FMLCommonHandler.instance().getSide().isClient() && stack.func_77973_b() == FAItemRegistry.DINOPEDIA) {
            this.setPedia();
            player.openGui((Object)Revival.INSTANCE, 6, this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
            return true;
        }
        if (this.isInsideNautilusShell()) {
            if (stack != ItemStack.field_190927_a && stack.func_77973_b() == Items.field_151145_ak) {
                ((EntityNautilus)this).setInShell(false);
                ((EntityNautilus)this).ticksToShell = 60;
            } else if (stack.func_77973_b() != FAItemRegistry.DINOPEDIA) {
                this.func_184185_a(SoundEvents.field_187635_cQ, 1.0f, this.func_70681_au().nextFloat() + 0.8f);
                return false;
            }
        } else if (!this.field_70170_p.field_72995_K && stack.func_190926_b() && this.func_70874_b() > 0) {
            if (!this.turnedToItem) {
                this.turnedToItem = true;
                this.func_70099_a(new ItemStack(this.selfType.fishItem, 1), 0.1f);
                this.func_184185_a(SoundEvents.field_187638_cR, 1.0f, this.func_70681_au().nextFloat() + 0.8f);
            }
            this.func_70106_y();
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70601_bi() {
        return this.field_70163_u < (double)this.field_70170_p.func_181545_F() && this.func_70090_H();
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public int func_70627_aG() {
        return 120;
    }

    protected int func_70693_a(EntityPlayer player) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(3);
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        if (!this.isInsideNautilusShell()) {
            if (this.func_70089_S() && !this.func_70090_H()) {
                this.func_70050_g(--i);
                if (this.func_70086_ai() == -20) {
                    this.func_70050_g(0);
                    this.func_70097_a(DamageSource.field_76369_e, 2.0f);
                }
            } else {
                this.func_70050_g(300);
            }
        }
    }

    public boolean func_70617_f_() {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.field_70761_aq = this.field_70177_z;
    }

    public EntityAgeable func_90011_a(EntityAgeable entity) {
        return null;
    }

    public boolean isDirectPathBetweenPoints(Vec3d vec1, Vec3d vec2) {
        RayTraceResult movingobjectposition = this.field_70170_p.func_147447_a(vec1, new Vec3d(vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c), false, true, false);
        return movingobjectposition == null || movingobjectposition.field_72313_a != RayTraceResult.Type.BLOCK;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        EntityLivingBase controller;
        if (this.func_70906_o() || this.isInsideNautilusShell()) {
            super.func_191986_a(0.0f, 0.0f, 0.0f);
            return;
        }
        if (this.func_184207_aI() && this.func_82171_bF() && (controller = (EntityLivingBase)this.func_184179_bs()) != null) {
            strafe = controller.field_70702_br * 0.5f;
            forward = controller.field_191988_bg;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            this.field_70143_R = 0.0f;
            if (this.func_70090_H()) {
                this.func_191958_b(strafe, vertical, forward, 1.0f);
                float f4 = 0.8f;
                float d0 = 3.0f;
                if (!this.field_70122_E) {
                    d0 *= 0.5f;
                }
                if (d0 > 0.0f) {
                    f4 += (0.54600006f - f4) * d0 / 3.0f;
                }
                this.field_70159_w *= (double)f4;
                this.field_70159_w *= 0.900000011920929;
                this.field_70181_x *= 0.900000011920929;
                this.field_70181_x *= (double)f4;
                this.field_70179_y *= 0.900000011920929;
                this.field_70179_y *= (double)f4;
                this.field_70181_x += 0.01185;
            } else {
                forward = controller.field_191988_bg * 0.25f;
                strafe = controller.field_70702_br * 0.125f;
                this.func_70659_e(2.0f);
                super.func_191986_a(strafe, vertical, forward);
                return;
            }
            this.func_70659_e(2.0f);
            vertical = 0.0f;
            super.func_191986_a(strafe, 0.0f, forward);
            this.field_184618_aE = this.field_70721_aZ;
            double deltaX = this.field_70165_t - this.field_70169_q;
            double deltaZ = this.field_70161_v - this.field_70166_s;
            double deltaY = this.field_70163_u - this.field_70167_r;
            float delta = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ)) * 4.0f;
            if (delta > 1.0f) {
                delta = 1.0f;
            }
            this.field_70721_aZ += (delta - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
            return;
        }
        if (this.func_70613_aW()) {
            if (this.func_70090_H()) {
                this.func_191958_b(strafe, vertical, forward, 0.1f);
                float f4 = 0.8f;
                float speedModifier = EnchantmentHelper.func_185294_d((EntityLivingBase)this);
                if (speedModifier > 3.0f) {
                    speedModifier = 3.0f;
                }
                if (!this.field_70122_E) {
                    speedModifier *= 0.5f;
                }
                if (speedModifier > 0.0f) {
                    f4 += (0.54600006f - f4) * speedModifier / 3.0f;
                }
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f4;
                this.field_70159_w *= 0.9;
                this.field_70181_x *= 0.9;
                this.field_70181_x *= (double)f4;
                this.field_70179_y *= 0.9;
                this.field_70179_y *= (double)f4;
            } else {
                super.func_191986_a(strafe, vertical, forward);
            }
        }
        this.field_184618_aE = this.field_70721_aZ;
        double deltaX = this.field_70165_t - this.field_70169_q;
        double deltaY = this.field_70163_u - this.field_70167_r;
        double deltaZ = this.field_70161_v - this.field_70166_s;
        float delta = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ)) * 4.0f;
        if (delta > 1.0f) {
            delta = 1.0f;
        }
        this.field_70721_aZ += (delta - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    class SwimmingMoveHelper
    extends EntityMoveHelper {
        private final EntityFishBase dinosaur;

        public SwimmingMoveHelper() {
            super((EntityLiving)EntityFishBase.this);
            this.dinosaur = EntityFishBase.this;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.dinosaur.func_70661_as().func_75500_f() && !this.dinosaur.func_184207_aI()) {
                if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.dinosaur.func_70661_as().func_75500_f()) {
                    double distanceX = this.field_75646_b - this.dinosaur.field_70165_t;
                    double distanceY = this.field_75647_c - this.dinosaur.field_70163_u;
                    double distanceZ = this.field_75644_d - this.dinosaur.field_70161_v;
                    double distance = Math.abs(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
                    distance = MathHelper.func_76133_a((double)distance);
                    float angle = (float)(Math.atan2(distanceZ, distanceX) * 180.0 / Math.PI) - 90.0f;
                    this.dinosaur.field_70177_z = this.func_75639_a(this.dinosaur.field_70177_z, angle, 30.0f);
                    this.dinosaur.func_70659_e(0.65f);
                    this.dinosaur.field_70181_x += (double)this.dinosaur.func_70689_ay() * (distanceY /= distance) * 0.1;
                } else {
                    this.dinosaur.func_70659_e(0.0f);
                }
            }
        }
    }
}

