/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity;

import com.google.common.collect.Lists;
import fossilsarcheology.server.item.FAItemRegistry;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StoneTabletEntity
extends EntityHanging
implements IEntityAdditionalSpawnData {
    public Variant variant;

    public StoneTabletEntity(World world) {
        super(world);
    }

    public StoneTabletEntity(World world, BlockPos pos, EnumFacing facing) {
        super(world, pos);
        ArrayList validVariants = Lists.newArrayList();
        Variant[] variantArray = Variant.values();
        int n = variantArray.length;
        for (int i = 0; i < n; ++i) {
            Variant variant;
            this.variant = variant = variantArray[i];
            this.func_174859_a(facing);
            if (!this.func_70518_d()) continue;
            validVariants.add(variant);
        }
        if (!validVariants.isEmpty()) {
            this.variant = (Variant)((Object)validVariants.get(this.field_70146_Z.nextInt(validVariants.size())));
        }
        this.func_174859_a(facing);
    }

    @SideOnly(value=Side.CLIENT)
    public StoneTabletEntity(World world, BlockPos pos, EnumFacing facing, String title) {
        this(world, pos, facing);
        for (Variant variant : Variant.values()) {
            if (!variant.title.equals(title)) continue;
            this.variant = variant;
            break;
        }
        this.func_174859_a(facing);
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74778_a("Variant", this.variant.title);
        super.func_70014_b(compound);
    }

    public void func_70037_a(NBTTagCompound compound) {
        String variantName = compound.func_74779_i("Variant");
        for (Variant variant : Variant.values()) {
            if (!variant.title.equals(variantName)) continue;
            this.variant = variant;
        }
        if (this.variant == null) {
            this.variant = Variant.FLAT_CREEP;
        }
        super.func_70037_a(compound);
    }

    public int func_82329_d() {
        return this.variant.sizeX;
    }

    public int func_82330_g() {
        return this.variant.sizeY;
    }

    public void func_110128_b(Entity brokenEntity) {
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.func_184185_a(SoundEvents.field_187845_fY, 1.0f, 1.0f);
            if (brokenEntity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)brokenEntity;
                if (player.field_71075_bZ.field_75098_d) {
                    return;
                }
            }
            this.func_70099_a(new ItemStack((Item)FAItemRegistry.STONE_TABLET), 0.0f);
        }
    }

    public void func_184523_o() {
        this.func_184185_a(SoundEvents.field_187845_fY, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
        BlockPos positionOffset = new BlockPos(x - this.field_70165_t, y - this.field_70163_u, z - this.field_70161_v);
        BlockPos newPosition = this.field_174861_a.func_177971_a((Vec3i)positionOffset);
        this.func_70107_b(newPosition.func_177958_n(), newPosition.func_177956_o(), newPosition.func_177952_p());
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeByte(this.variant.ordinal());
        buffer.writeLong(this.field_174861_a.func_177986_g());
        buffer.writeByte(this.field_174860_b.func_176736_b());
    }

    public void readSpawnData(ByteBuf buffer) {
        this.variant = Variant.values()[buffer.readByte()];
        this.field_174861_a = BlockPos.func_177969_a((long)buffer.readLong());
        this.func_174859_a(EnumFacing.func_176731_b((int)buffer.readByte()));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((Item)FAItemRegistry.STONE_TABLET, 1);
    }

    public static enum Variant {
        LIGHTNING("Lightning", 32, 16, 0, 0),
        SOCIAL("Social", 16, 16, 32, 0),
        GREAT_WAR("Greatwar", 32, 32, 0, 16),
        CLOCK("clock", 32, 16, 0, 48),
        PORTAL("Portal", 32, 32, 0, 64),
        HEROBRINE("Herobrine", 32, 32, 32, 32),
        FLAT_CREEP("FlatCreep", 16, 16, 48, 0),
        ANGRY("annoyangry", 16, 16, 48, 16),
        REX_1("Rex1", 32, 32, 64, 0),
        REX_2("Rex2", 32, 16, 64, 32),
        REX_3("Rex3", 32, 16, 64, 48),
        REX_4("Rex4", 32, 32, 64, 64),
        PUZZLE("Puzzle", 32, 32, 32, 64),
        GUN_FIGHT("GunFight", 64, 32, 32, 96),
        PRINCESS("Princess", 32, 32, 0, 96),
        MOSAURUS("Mosa", 32, 16, 64, 128),
        HOLY_MOSAURUS("HolyMosasaurus", 64, 32, 0, 128),
        ANCI_TM("AnciTM", 32, 32, 96, 0),
        MOD_TM("ModTM", 16, 32, 128, 0),
        VIG_TM("VigTM", 32, 32, 144, 0),
        SABER_HUNT("SaberHunt", 32, 16, 96, 32),
        ANU_PORTAL("AnuPortal", 32, 32, 96, 48),
        ANUBITE_1("Anubite1", 16, 16, 128, 32),
        ANUBITE_2("Anubite2", 16, 16, 144, 32),
        ANUBITE_3("Anubite3", 16, 16, 160, 32),
        ANUBITE_4("Anubite4", 16, 16, 176, 32),
        SARCOPHAGUS_OPEN("sarcophagus_open", 32, 32, 128, 48),
        SARCOPHAGUS_KILL("sarcophagus_kill", 32, 32, 96, 80),
        DEAD_ANU("deadAnu", 32, 32, 128, 80);

        public final String title;
        public final int sizeX;
        public final int sizeY;
        public final int offsetX;
        public final int offsetY;

        private Variant(String title, int xSize, int ySize, int textureX, int textureY) {
            this.title = title;
            this.sizeX = xSize;
            this.sizeY = ySize;
            this.offsetX = textureX;
            this.offsetY = textureY;
        }
    }
}

