/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.prehistoric;

import fossilsarcheology.Revival;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoric;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityFlying;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public abstract class EntityPrehistoricFlying
extends EntityPrehistoric
implements EntityFlying {
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityPrehistoricFlying.class, (DataSerializer)DataSerializers.field_187198_h);
    public BlockPos airTarget;
    public float flyProgress;
    private boolean isFlying;
    private int ticksFlying;
    public Animation TAKEOFF_ANIMATION;

    public EntityPrehistoricFlying(World world, PrehistoricEntityType type, double baseDamage, double maxDamage, double baseHealth, double maxHealth, double baseSpeed, double maxSpeed, double baseArmor, double maxArmor) {
        super(world, type, baseDamage, maxDamage, baseHealth, maxHealth, baseSpeed, maxSpeed, baseArmor, maxArmor);
    }

    public boolean isDirectPathBetweenPoints(Vec3d vec1, Vec3d vec2) {
        RayTraceResult movingobjectposition = this.field_70170_p.func_147447_a(vec1, new Vec3d(vec2.field_72450_a, vec2.field_72448_b + (double)this.field_70131_O * 0.5, vec2.field_72449_c), false, true, false);
        return movingobjectposition == null || movingobjectposition.field_72313_a != RayTraceResult.Type.BLOCK;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Flying", this.isFlying());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setFlying(compound.func_74767_n("Flying"));
    }

    public boolean isFlying() {
        if (this.field_70170_p.field_72995_K) {
            boolean isFlying;
            this.isFlying = isFlying = ((Boolean)this.field_70180_af.func_187225_a(FLYING)).booleanValue();
            return isFlying;
        }
        return this.isFlying;
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
        if (!this.field_70170_p.field_72995_K) {
            this.isFlying = flying;
        }
    }

    public void func_70664_aZ() {
        super.func_70664_aZ();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        boolean flying = this.field_70170_p.func_175623_d(this.func_180425_c().func_177977_b());
        if (this.isFlying() && this.isSleeping()) {
            this.setSleeping(false);
        }
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        if (!this.isFlying() && !this.field_70122_E) {
            this.field_70721_aZ += 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        }
        if (flying && this.flyProgress < 20.0f) {
            this.flyProgress += 2.0f;
            if (this.sitProgress != 0.0f) {
                this.sleepProgress = 0.0f;
                this.sitProgress = 0.0f;
            }
        } else if (!flying && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
            if (this.sitProgress != 0.0f) {
                this.sleepProgress = 0.0f;
                this.sitProgress = 0.0f;
            }
        }
        int flightChance = 250;
        if (!this.isFlying() && !this.isMovementBlockedSoft() && this.field_70146_Z.nextInt(flightChance) == 0 && !this.field_70170_p.field_72995_K && this.isAdult() && this.func_184179_bs() == null && this.field_70122_E && this.field_70173_aa > 50) {
            this.startFlying();
        }
        if (!this.field_70170_p.field_72995_K && this.isFlying()) {
            ++this.ticksFlying;
        }
        if (!this.field_70170_p.field_72995_K && !this.isFlying()) {
            this.ticksFlying = 0;
        }
        if (!this.field_70170_p.field_72995_K && this.ticksFlying > 80 && this.field_70122_E) {
            this.setFlying(false);
        }
        if (this.isFlying() && this.canSleep() && !this.field_70170_p.func_175623_d(this.func_180425_c().func_177979_c(2)) && !this.func_191953_am()) {
            this.setFlying(false);
        }
        if (this.isFlying() && this.func_70638_az() == null) {
            this.flyAround();
        } else if (this.func_70638_az() != null) {
            this.flyTowardsTarget();
        }
        if (this.hasTakeoffAnimation() && !this.isFlying() && this.getAnimation() == this.TAKEOFF_ANIMATION && this.getAnimationTick() >= this.getTakeoffTick()) {
            this.setFlying(true);
        }
    }

    public void startFlying() {
        if (this.hasTakeoffAnimation()) {
            this.setAnimation(this.TAKEOFF_ANIMATION);
        } else {
            this.setFlying(true);
        }
    }

    public void flyAround() {
        if (this.airTarget != null && this.isFlying()) {
            if (!this.isTargetInAir() || !this.isFlying()) {
                this.airTarget = null;
            }
            this.flyTowardsTarget();
        }
    }

    public void flyTowardsTarget() {
        double bbLength = this.func_174813_aQ().func_72320_b() * 2.5;
        double maxDist = Math.max(3.0, bbLength * bbLength);
        if (this.airTarget != null && this.isTargetInAir() && this.isFlying()) {
            Vec3d vec3d = new Vec3d((double)this.airTarget.func_177958_n() + 0.5, (double)this.airTarget.func_177956_o() + 0.5, (double)this.airTarget.func_177952_p() + 0.5);
            if ((double)this.getDistanceSquared(vec3d) > maxDist) {
                double targetX = (double)this.airTarget.func_177958_n() + 0.5 - this.field_70165_t;
                double targetY = (double)Math.min(this.airTarget.func_177956_o(), 256) + 1.0 - this.field_70163_u;
                double targetZ = (double)this.airTarget.func_177952_p() + 0.5 - this.field_70161_v;
                this.field_70159_w += (Math.signum(targetX) * 0.5 - this.field_70159_w) * 0.100000000372529 * 2.0;
                this.field_70181_x += (Math.signum(targetY) * 0.5 - this.field_70181_x) * 0.100000000372529 * 2.0;
                this.field_70179_y += (Math.signum(targetZ) * 0.5 - this.field_70179_y) * 0.100000000372529 * 2.0;
                float angle = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
                float rotation = MathHelper.func_76142_g((float)(angle - this.field_70177_z));
                this.field_191988_bg = 0.5f;
                this.field_70126_B = this.field_70177_z;
                if (Math.abs(this.field_70159_w) > 0.12 || Math.abs(this.field_70179_y) > 0.12) {
                    this.field_70177_z += rotation;
                }
            } else {
                this.onReachAirTarget(this.airTarget);
                this.airTarget = null;
            }
        } else {
            this.airTarget = null;
        }
        if (this.field_70123_F) {
            this.airTarget = null;
        }
    }

    protected void onReachAirTarget(BlockPos airTarget) {
    }

    protected boolean isTargetInAir() {
        return this.airTarget != null && (this.field_70170_p.func_180495_p(this.airTarget).func_185904_a() == Material.field_151579_a || this.field_70170_p.func_180495_p(this.airTarget).func_185904_a() == Material.field_151579_a);
    }

    public float getDistanceSquared(Vec3d vec) {
        float f = (float)(this.field_70165_t - vec.field_72450_a);
        float f1 = (float)(this.field_70163_u - vec.field_72448_b);
        float f2 = (float)(this.field_70161_v - vec.field_72449_c);
        return f * f + f1 * f1 + f2 * f2;
    }

    protected abstract double getFlySpeed();

    public static BlockPos getBlockInView(EntityPrehistoricFlying dinosaur) {
        BlockPos ground;
        int distFromGround;
        double extraZ;
        float radius = -6.2999997f - (float)dinosaur.func_70681_au().nextInt(20);
        float neg = dinosaur.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float angle = (float)Math.PI / 180 * dinosaur.field_70761_aq + 3.15f + dinosaur.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        BlockPos radialPos = new BlockPos(dinosaur.field_70165_t + extraX, 0.0, dinosaur.field_70161_v + (extraZ = (double)(radius * MathHelper.func_76134_b((float)angle))));
        BlockPos newPos = radialPos.func_177981_b((distFromGround = (int)dinosaur.field_70163_u - (ground = dinosaur.field_70170_p.func_175645_m(radialPos)).func_177956_o()) > 16 ? (int)Math.min((double)Revival.CONFIG_OPTIONS.flyingTargetMaxHeight, dinosaur.field_70163_u + (double)dinosaur.func_70681_au().nextInt(16) - 8.0) : (int)dinosaur.field_70163_u + dinosaur.func_70681_au().nextInt(16) + 1);
        if (!EntityPrehistoricFlying.isTargetBlocked((Entity)dinosaur, new Vec3d((Vec3i)newPos)) && dinosaur.func_174831_c(newPos) > 6.0) {
            return newPos;
        }
        return null;
    }

    public static boolean isTargetBlocked(Entity entity, Vec3d target) {
        RayTraceResult rayTrace;
        if (target != null && (rayTrace = entity.field_70170_p.func_72901_a(new Vec3d((Vec3i)entity.func_180425_c()), target, false)) != null && rayTrace.field_72307_f != null) {
            BlockPos sidePos = rayTrace.func_178782_a();
            BlockPos pos = new BlockPos(rayTrace.field_72307_f);
            return !entity.field_70170_p.func_175623_d(pos) || !entity.field_70170_p.func_175623_d(sidePos);
        }
        return false;
    }

    @Nullable
    public BlockPos generateAirTarget() {
        BlockPos pos = null;
        for (int i = 0; i < 10; ++i) {
            pos = EntityPrehistoricFlying.getBlockInView(this);
            if (pos == null || this.field_70170_p.func_180495_p(pos).func_185904_a() != Material.field_151579_a || EntityPrehistoricFlying.isTargetBlocked((Entity)this, new Vec3d((Vec3i)pos))) continue;
            return pos;
        }
        return pos;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{this.SPEAK_ANIMATION, this.ATTACK_ANIMATION, this.TAKEOFF_ANIMATION};
    }

    public boolean hasTakeoffAnimation() {
        return false;
    }

    public int getTakeoffTick() {
        return this.TAKEOFF_ANIMATION.getDuration() - 1;
    }
}

