/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.util;

import com.google.common.collect.Maps;
import fossilsarcheology.server.entity.prehistoric.Diet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public enum FoodMappings {
    INSTANCE;

    private Map<ItemStack, Integer> carnivoreItemDiet;
    private Map<ItemStack, Integer> herbivoreItemDiet;
    private Map<ItemStack, Integer> omnivoreItemDiet;
    private Map<ItemStack, Integer> piscivoreItemDiet;
    private Map<ItemStack, Integer> carnivoreEggItemDiet;
    private Map<ItemStack, Integer> insectivoreItemDiet;
    private Map<ItemStack, Integer> pisccarnivoreItemDiet;
    private Map<Block, Integer> carnivoreBlockDiet;
    private Map<Block, Integer> herbivoreBlockDiet;
    private Map<Block, Integer> omnivoreBlockDiet;
    private Map<Block, Integer> piscivoreBlockDiet;
    private Map<Block, Integer> carnivoreEggBlockDiet;
    private Map<Block, Integer> insectivoreBlockDiet;
    private Map<Block, Integer> pisccarnivoreBlockDiet;
    private Map<Class<? extends Entity>, Integer> carnivoreEntityDiet;
    private Map<Class<? extends Entity>, Integer> herbivoreEntityDiet;
    private Map<Class<? extends Entity>, Integer> omnivoreEntityDiet;
    private Map<Class<? extends Entity>, Integer> piscivoreEntityDiet;
    private Map<Class<? extends Entity>, Integer> carnivore_eggEntityDiet;
    private Map<Class<? extends Entity>, Integer> insectivoreEntityDiet;
    private Map<Class<? extends Entity>, Integer> pisccarnivoreEntityDiet;

    private static Class<? extends Entity> getClassFromName(String name) {
        EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(name));
        return entry == null ? null : entry.getEntityClass();
    }

    public void addToItemMappings(ItemStack item, int food, Diet diet) {
        if (!item.func_190926_b()) {
            switch (diet) {
                case CARNIVORE: {
                    if (this.carnivoreItemDiet == null) {
                        this.carnivoreItemDiet = Maps.newHashMap();
                    }
                    if (this.carnivoreItemDiet.containsKey(item)) break;
                    this.carnivoreItemDiet.put(item, food);
                    break;
                }
                case HERBIVORE: {
                    if (this.herbivoreItemDiet == null) {
                        this.herbivoreItemDiet = Maps.newHashMap();
                    }
                    if (this.herbivoreItemDiet.containsKey(item)) break;
                    this.herbivoreItemDiet.put(item, food);
                    break;
                }
                case OMNIVORE: {
                    if (this.omnivoreItemDiet == null) {
                        this.omnivoreItemDiet = Maps.newHashMap();
                    }
                    if (this.omnivoreItemDiet.containsKey(item)) break;
                    this.omnivoreItemDiet.put(item, food);
                    break;
                }
                case PISCIVORE: {
                    if (this.piscivoreItemDiet == null) {
                        this.piscivoreItemDiet = Maps.newHashMap();
                    }
                    if (this.piscivoreItemDiet.containsKey(item)) break;
                    this.piscivoreItemDiet.put(item, food);
                    break;
                }
                case CARNIVORE_EGG: {
                    if (this.carnivoreEggItemDiet == null) {
                        this.carnivoreEggItemDiet = Maps.newHashMap();
                    }
                    if (this.carnivoreEggItemDiet.containsKey(item)) break;
                    this.carnivoreEggItemDiet.put(item, food);
                    break;
                }
                case INSECTIVORE: {
                    if (this.insectivoreItemDiet == null) {
                        this.insectivoreItemDiet = Maps.newHashMap();
                    }
                    if (this.insectivoreItemDiet.containsKey(item)) break;
                    this.insectivoreItemDiet.put(item, food);
                    break;
                }
                case PISCCARNIVORE: {
                    if (this.pisccarnivoreItemDiet == null) {
                        this.pisccarnivoreItemDiet = Maps.newHashMap();
                    }
                    if (this.pisccarnivoreItemDiet.containsKey(item)) break;
                    this.pisccarnivoreItemDiet.put(item, food);
                    break;
                }
            }
        }
    }

    public int getItemFoodAmount(ItemStack item, Diet diet) {
        block40: {
            block39: {
                if (!(item.func_77973_b() instanceof ItemBlock)) break block39;
                Block block = ((ItemBlock)item.func_77973_b()).func_179223_d();
                switch (diet) {
                    case CARNIVORE: {
                        if (this.carnivoreBlockDiet != null) {
                            for (Map.Entry<Block, Integer> entry : this.carnivoreBlockDiet.entrySet()) {
                                Block compareStack = entry.getKey();
                                if (block != compareStack) continue;
                                return this.carnivoreBlockDiet.get(compareStack);
                            }
                        }
                        break block40;
                    }
                    case HERBIVORE: {
                        if (this.herbivoreBlockDiet != null) {
                            for (Map.Entry<Block, Integer> entry : this.herbivoreBlockDiet.entrySet()) {
                                Block compareStack = entry.getKey();
                                if (block != compareStack) continue;
                                return this.herbivoreBlockDiet.get(compareStack);
                            }
                        }
                        break block40;
                    }
                    case OMNIVORE: {
                        if (this.omnivoreBlockDiet != null) {
                            for (Map.Entry<Block, Integer> entry : this.omnivoreBlockDiet.entrySet()) {
                                Block compareStack = entry.getKey();
                                if (block != compareStack) continue;
                                return this.omnivoreBlockDiet.get(compareStack);
                            }
                        }
                        break block40;
                    }
                    case PISCIVORE: {
                        if (this.pisccarnivoreBlockDiet != null) {
                            for (Map.Entry<Block, Integer> entry : this.pisccarnivoreBlockDiet.entrySet()) {
                                Block compareStack = entry.getKey();
                                if (block != compareStack) continue;
                                return this.pisccarnivoreBlockDiet.get(compareStack);
                            }
                        }
                        break block40;
                    }
                    case CARNIVORE_EGG: {
                        if (this.carnivoreEggBlockDiet != null) {
                            for (Map.Entry<Block, Integer> entry : this.carnivoreEggBlockDiet.entrySet()) {
                                Block compareStack = entry.getKey();
                                if (block != compareStack) continue;
                                return this.carnivoreEggBlockDiet.get(compareStack);
                            }
                        }
                        break block40;
                    }
                    case INSECTIVORE: {
                        if (this.insectivoreBlockDiet != null) {
                            for (Map.Entry<Block, Integer> entry : this.insectivoreBlockDiet.entrySet()) {
                                Block compareStack = entry.getKey();
                                if (block != compareStack) continue;
                                return this.insectivoreBlockDiet.get(compareStack);
                            }
                        }
                        break block40;
                    }
                    case PISCCARNIVORE: {
                        if (this.pisccarnivoreBlockDiet != null) {
                            for (Map.Entry<Block, Integer> entry : this.pisccarnivoreBlockDiet.entrySet()) {
                                Block compareStack = entry.getKey();
                                if (block != compareStack) continue;
                                return this.pisccarnivoreBlockDiet.get(compareStack);
                            }
                        }
                        break block40;
                    }
                    default: {
                        return 0;
                    }
                }
            }
            switch (diet) {
                case CARNIVORE: {
                    if (this.carnivoreItemDiet == null) break;
                    for (Map.Entry<ItemStack, Integer> entry : this.carnivoreItemDiet.entrySet()) {
                        ItemStack compareStack = entry.getKey();
                        if (!item.func_77969_a(compareStack)) continue;
                        return this.carnivoreItemDiet.get(compareStack);
                    }
                    break;
                }
                case HERBIVORE: {
                    if (this.herbivoreItemDiet == null) break;
                    for (Map.Entry<ItemStack, Integer> entry : this.herbivoreItemDiet.entrySet()) {
                        ItemStack compareStack = entry.getKey();
                        if (!item.func_77969_a(compareStack)) continue;
                        return this.herbivoreItemDiet.get(compareStack);
                    }
                    break;
                }
                case OMNIVORE: {
                    if (this.omnivoreItemDiet == null) break;
                    for (Map.Entry<ItemStack, Integer> entry : this.omnivoreItemDiet.entrySet()) {
                        ItemStack compareStack = entry.getKey();
                        if (!item.func_77969_a(compareStack)) continue;
                        return this.omnivoreItemDiet.get(compareStack);
                    }
                    break;
                }
                case PISCIVORE: {
                    if (this.piscivoreItemDiet == null) break;
                    for (Map.Entry<ItemStack, Integer> entry : this.piscivoreItemDiet.entrySet()) {
                        ItemStack compareStack = entry.getKey();
                        if (!item.func_77969_a(compareStack)) continue;
                        return this.piscivoreItemDiet.get(compareStack);
                    }
                    break;
                }
                case CARNIVORE_EGG: {
                    if (this.carnivoreEggItemDiet == null) break;
                    for (Map.Entry<ItemStack, Integer> entry : this.carnivoreEggItemDiet.entrySet()) {
                        ItemStack compareStack = entry.getKey();
                        if (!item.func_77969_a(compareStack)) continue;
                        return this.carnivoreEggItemDiet.get(compareStack);
                    }
                    break;
                }
                case INSECTIVORE: {
                    if (this.insectivoreItemDiet == null) break;
                    for (Map.Entry<ItemStack, Integer> entry : this.insectivoreItemDiet.entrySet()) {
                        ItemStack compareStack = entry.getKey();
                        if (!item.func_77969_a(compareStack)) continue;
                        return this.insectivoreItemDiet.get(compareStack);
                    }
                    break;
                }
                case PISCCARNIVORE: {
                    if (this.pisccarnivoreItemDiet == null) break;
                    for (Map.Entry<ItemStack, Integer> entry : this.pisccarnivoreItemDiet.entrySet()) {
                        ItemStack compareStack = entry.getKey();
                        if (!item.func_77969_a(compareStack)) continue;
                        return this.pisccarnivoreItemDiet.get(compareStack);
                    }
                    break;
                }
                default: {
                    return 0;
                }
            }
        }
        return 0;
    }

    public void addToBlockMappings(Block block, int food, Diet diet, boolean registerItem) {
        switch (diet) {
            case CARNIVORE: {
                if (this.carnivoreBlockDiet == null) {
                    this.carnivoreBlockDiet = Maps.newHashMap();
                }
                if (this.carnivoreBlockDiet.containsKey(block)) break;
                this.carnivoreBlockDiet.put(block, food);
                break;
            }
            case HERBIVORE: {
                if (this.herbivoreBlockDiet == null) {
                    this.herbivoreBlockDiet = Maps.newHashMap();
                }
                if (this.herbivoreBlockDiet.containsKey(block)) break;
                this.herbivoreBlockDiet.put(block, food);
                break;
            }
            case OMNIVORE: {
                if (this.omnivoreBlockDiet == null) {
                    this.omnivoreBlockDiet = Maps.newHashMap();
                }
                if (this.omnivoreBlockDiet.containsKey(block)) break;
                this.omnivoreBlockDiet.put(block, food);
                break;
            }
            case PISCIVORE: {
                if (this.piscivoreBlockDiet == null) {
                    this.piscivoreBlockDiet = Maps.newHashMap();
                }
                if (this.piscivoreBlockDiet.containsKey(block)) break;
                this.piscivoreBlockDiet.put(block, food);
                break;
            }
            case CARNIVORE_EGG: {
                if (this.carnivoreEggBlockDiet == null) {
                    this.carnivoreEggBlockDiet = Maps.newHashMap();
                }
                if (this.carnivoreEggBlockDiet.containsKey(block)) break;
                this.carnivoreEggBlockDiet.put(block, food);
                break;
            }
            case INSECTIVORE: {
                if (this.insectivoreBlockDiet == null) {
                    this.insectivoreBlockDiet = Maps.newHashMap();
                }
                if (this.insectivoreBlockDiet.containsKey(block)) break;
                this.insectivoreBlockDiet.put(block, food);
                break;
            }
            case PISCCARNIVORE: {
                if (this.pisccarnivoreBlockDiet == null) {
                    this.pisccarnivoreBlockDiet = Maps.newHashMap();
                }
                if (this.pisccarnivoreBlockDiet.containsKey(block)) break;
                this.pisccarnivoreBlockDiet.put(block, food);
                break;
            }
        }
        if (registerItem) {
            this.addToItemMappings(new ItemStack(Item.func_150898_a((Block)block)), food, diet);
        }
    }

    public int getBlockFoodAmount(Block block, Diet diet) {
        switch (diet) {
            case CARNIVORE: {
                if (this.carnivoreBlockDiet == null || !this.carnivoreBlockDiet.containsKey(block)) break;
                return this.carnivoreBlockDiet.get(block);
            }
            case HERBIVORE: {
                if (this.herbivoreBlockDiet == null || !this.herbivoreBlockDiet.containsKey(block)) break;
                return this.herbivoreBlockDiet.get(block);
            }
            case OMNIVORE: {
                if (this.omnivoreBlockDiet == null || !this.omnivoreBlockDiet.containsKey(block)) break;
                return this.omnivoreBlockDiet.get(block);
            }
            case PISCIVORE: {
                if (this.piscivoreBlockDiet == null || !this.piscivoreBlockDiet.containsKey(block)) break;
                return this.piscivoreBlockDiet.get(block);
            }
            case CARNIVORE_EGG: {
                if (this.carnivoreEggBlockDiet == null || !this.carnivoreEggBlockDiet.containsKey(block)) break;
                return this.carnivoreEggBlockDiet.get(block);
            }
            case INSECTIVORE: {
                if (this.insectivoreBlockDiet == null || !this.insectivoreBlockDiet.containsKey(block)) break;
                return this.insectivoreBlockDiet.get(block);
            }
            case PISCCARNIVORE: {
                if (this.pisccarnivoreBlockDiet == null || !this.pisccarnivoreBlockDiet.containsKey(block)) break;
                return this.pisccarnivoreBlockDiet.get(block);
            }
            default: {
                return 0;
            }
        }
        return 0;
    }

    public void addToEntityMappings(String entityName, int food, Diet diet) {
        Class<? extends Entity> entity = FoodMappings.getClassFromName(entityName);
        if (entity != null) {
            this.addToEntityMappings(entity, food, diet);
        }
    }

    public void addToEntityMappings(Class<? extends Entity> entity, int food, Diet diet) {
        switch (diet) {
            case CARNIVORE: {
                if (this.carnivoreEntityDiet == null) {
                    this.carnivoreEntityDiet = Maps.newHashMap();
                }
                if (this.carnivoreEntityDiet.containsKey(entity)) break;
                this.carnivoreEntityDiet.put(entity, food);
                break;
            }
            case HERBIVORE: {
                if (this.herbivoreEntityDiet == null) {
                    this.herbivoreEntityDiet = Maps.newHashMap();
                }
                if (this.herbivoreEntityDiet.containsKey(entity)) break;
                this.herbivoreEntityDiet.put(entity, food);
                break;
            }
            case OMNIVORE: {
                if (this.omnivoreEntityDiet == null) {
                    this.omnivoreEntityDiet = Maps.newHashMap();
                }
                if (this.omnivoreEntityDiet.containsKey(entity)) break;
                this.omnivoreEntityDiet.put(entity, food);
                break;
            }
            case PISCIVORE: {
                if (this.piscivoreEntityDiet == null) {
                    this.piscivoreEntityDiet = Maps.newHashMap();
                }
                if (this.piscivoreEntityDiet.containsKey(entity)) break;
                this.piscivoreEntityDiet.put(entity, food);
                break;
            }
            case CARNIVORE_EGG: {
                if (this.carnivore_eggEntityDiet == null) {
                    this.carnivore_eggEntityDiet = Maps.newHashMap();
                }
                if (this.carnivore_eggEntityDiet.containsKey(entity)) break;
                this.carnivore_eggEntityDiet.put(entity, food);
                break;
            }
            case INSECTIVORE: {
                if (this.insectivoreEntityDiet == null) {
                    this.insectivoreEntityDiet = Maps.newHashMap();
                }
                if (this.insectivoreEntityDiet.containsKey(entity)) break;
                this.insectivoreEntityDiet.put(entity, food);
                break;
            }
            case PISCCARNIVORE: {
                if (this.pisccarnivoreEntityDiet == null) {
                    this.pisccarnivoreEntityDiet = Maps.newHashMap();
                }
                if (this.pisccarnivoreEntityDiet.containsKey(entity)) break;
                this.pisccarnivoreEntityDiet.put(entity, food);
                break;
            }
        }
    }

    public int getEntityFoodAmount(Class<? extends Entity> entity, Diet diet) {
        switch (diet) {
            case CARNIVORE: {
                if (this.carnivoreEntityDiet == null || !this.carnivoreEntityDiet.containsKey(entity)) break;
                return this.carnivoreEntityDiet.get(entity);
            }
            case HERBIVORE: {
                if (this.herbivoreEntityDiet == null || !this.herbivoreEntityDiet.containsKey(entity)) break;
                return this.herbivoreEntityDiet.get(entity);
            }
            case OMNIVORE: {
                if (this.omnivoreEntityDiet == null || !this.omnivoreEntityDiet.containsKey(entity)) break;
                return this.omnivoreEntityDiet.get(entity);
            }
            case PISCIVORE: {
                if (this.piscivoreEntityDiet == null || !this.piscivoreEntityDiet.containsKey(entity)) break;
                return this.piscivoreEntityDiet.get(entity);
            }
            case CARNIVORE_EGG: {
                if (this.carnivore_eggEntityDiet == null || !this.carnivore_eggEntityDiet.containsKey(entity)) break;
                return this.carnivore_eggEntityDiet.get(entity);
            }
            case INSECTIVORE: {
                if (this.insectivoreEntityDiet == null || !this.insectivoreEntityDiet.containsKey(entity)) break;
                return this.insectivoreEntityDiet.get(entity);
            }
            case PISCCARNIVORE: {
                if (this.pisccarnivoreEntityDiet == null || !this.pisccarnivoreEntityDiet.containsKey(entity)) break;
                return this.pisccarnivoreEntityDiet.get(entity);
            }
            default: {
                return 0;
            }
        }
        return 0;
    }

    public Map<ItemStack, Integer> getFoodRenderList(Diet diet) {
        switch (diet) {
            case CARNIVORE: {
                if (this.carnivoreItemDiet == null) {
                    this.carnivoreItemDiet = Maps.newHashMap();
                }
                return this.carnivoreItemDiet;
            }
            case HERBIVORE: {
                if (this.herbivoreItemDiet == null) {
                    this.herbivoreItemDiet = Maps.newHashMap();
                }
                return this.herbivoreItemDiet;
            }
            case OMNIVORE: {
                if (this.omnivoreItemDiet == null) {
                    this.omnivoreItemDiet = Maps.newHashMap();
                }
                return this.omnivoreItemDiet;
            }
            case PISCIVORE: {
                if (this.piscivoreItemDiet == null) {
                    this.piscivoreItemDiet = Maps.newHashMap();
                }
                return this.piscivoreItemDiet;
            }
            case CARNIVORE_EGG: {
                if (this.carnivoreEggItemDiet == null) {
                    this.carnivoreEggItemDiet = Maps.newHashMap();
                }
                return this.carnivoreEggItemDiet;
            }
            case INSECTIVORE: {
                if (this.insectivoreItemDiet == null) {
                    this.insectivoreItemDiet = Maps.newHashMap();
                }
                return this.insectivoreItemDiet;
            }
            case PISCCARNIVORE: {
                if (this.pisccarnivoreItemDiet == null) {
                    this.pisccarnivoreItemDiet = Maps.newHashMap();
                }
                return this.pisccarnivoreItemDiet;
            }
        }
        return this.carnivoreItemDiet;
    }

    public void removeItemMapping(ItemStack item, Diet diet) {
        this.getFoodRenderList(diet).remove(item);
    }

    public void addMeat(Class<? extends Entity> entity, int food) {
        this.addToEntityMappings(entity, food, Diet.CARNIVORE);
        this.addToEntityMappings(entity, food, Diet.CARNIVORE_EGG);
        this.addToEntityMappings(entity, food, Diet.OMNIVORE);
        this.addToEntityMappings(entity, food, Diet.PISCCARNIVORE);
    }

    public void addMeatEntity(String entity, int food) {
        this.addToEntityMappings(entity, food, Diet.CARNIVORE);
        this.addToEntityMappings(entity, food, Diet.CARNIVORE_EGG);
        this.addToEntityMappings(entity, food, Diet.OMNIVORE);
        this.addToEntityMappings(entity, food, Diet.PISCCARNIVORE);
    }

    public void addMeat(Block block, int food) {
        this.addToBlockMappings(block, food, Diet.CARNIVORE, true);
        this.addToBlockMappings(block, food, Diet.CARNIVORE_EGG, true);
        this.addToBlockMappings(block, food, Diet.OMNIVORE, true);
        this.addToBlockMappings(block, food, Diet.PISCCARNIVORE, true);
    }

    public void addMeat(ItemStack item, int food) {
        this.addToItemMappings(item, food, Diet.CARNIVORE);
        this.addToItemMappings(item, food, Diet.CARNIVORE_EGG);
        this.addToItemMappings(item, food, Diet.OMNIVORE);
        this.addToItemMappings(item, food, Diet.PISCCARNIVORE);
    }

    public void addMeat(String ore_dictionary_name, int food) {
        this.addOreDictionary(ore_dictionary_name, food, Diet.CARNIVORE);
        this.addOreDictionary(ore_dictionary_name, food, Diet.CARNIVORE_EGG);
        this.addOreDictionary(ore_dictionary_name, food, Diet.OMNIVORE);
        this.addOreDictionary(ore_dictionary_name, food, Diet.PISCCARNIVORE);
    }

    public void addPlant(Class<? extends Entity> entity, int food) {
        this.addToEntityMappings(entity, food, Diet.HERBIVORE);
        this.addToEntityMappings(entity, food, Diet.OMNIVORE);
    }

    public void addPlant(Block block, int food) {
        this.addToBlockMappings(block, food, Diet.HERBIVORE, true);
        this.addToBlockMappings(block, food, Diet.OMNIVORE, true);
    }

    public void addPlant(ItemStack item, int food) {
        this.addToItemMappings(item, food, Diet.HERBIVORE);
        this.addToItemMappings(item, food, Diet.OMNIVORE);
    }

    public void addPlant(String ore_dictionary_name, int food) {
        this.addOreDictionary(ore_dictionary_name, food, Diet.HERBIVORE);
        this.addOreDictionary(ore_dictionary_name, food, Diet.OMNIVORE);
    }

    public void addPlantEntity(String entity, int food) {
        this.addToEntityMappings(entity, food, Diet.HERBIVORE);
        this.addToEntityMappings(entity, food, Diet.OMNIVORE);
    }

    public void addFish(Class<? extends Entity> entity, int food) {
        this.addToEntityMappings(entity, food, Diet.PISCCARNIVORE);
        this.addToEntityMappings(entity, food, Diet.PISCIVORE);
    }

    public void addFishEntity(String entity, int food) {
        this.addToEntityMappings(entity, food, Diet.PISCCARNIVORE);
        this.addToEntityMappings(entity, food, Diet.PISCIVORE);
    }

    public void addFish(Block block, int food) {
        this.addToBlockMappings(block, food, Diet.PISCCARNIVORE, true);
        this.addToBlockMappings(block, food, Diet.PISCIVORE, true);
    }

    public void addFish(ItemStack item, int food) {
        this.addToItemMappings(item, food, Diet.PISCCARNIVORE);
        this.addToItemMappings(item, food, Diet.PISCIVORE);
    }

    public void addFish(String ore_dictionary_name, int food) {
        this.addOreDictionary(ore_dictionary_name, food, Diet.PISCCARNIVORE);
        this.addOreDictionary(ore_dictionary_name, food, Diet.PISCIVORE);
    }

    public void addEgg(Class<? extends Entity> entity, int food) {
        this.addToEntityMappings(entity, food, Diet.CARNIVORE_EGG);
        this.addToEntityMappings(entity, food, Diet.OMNIVORE);
    }

    public void addEgg(Block block, int food) {
        this.addToBlockMappings(block, food, Diet.CARNIVORE_EGG, true);
        this.addToBlockMappings(block, food, Diet.OMNIVORE, true);
    }

    public void addEgg(ItemStack item, int food) {
        this.addToItemMappings(item, food, Diet.CARNIVORE_EGG);
        this.addToItemMappings(item, food, Diet.OMNIVORE);
    }

    public void addEgg(String ore_dictionary_name, int food) {
        this.addOreDictionary(ore_dictionary_name, food, Diet.CARNIVORE_EGG);
        this.addOreDictionary(ore_dictionary_name, food, Diet.OMNIVORE);
    }

    public void addEggEntity(String entity, int food) {
        this.addToEntityMappings(entity, food, Diet.CARNIVORE_EGG);
        this.addToEntityMappings(entity, food, Diet.OMNIVORE);
    }

    public void addInsect(Class<? extends Entity> entity, int food) {
        this.addToEntityMappings(entity, food, Diet.INSECTIVORE);
    }

    public void addInsectEntity(String entity, int food) {
        this.addToEntityMappings(entity, food, Diet.INSECTIVORE);
    }

    public void addInsect(Block block, int food) {
        this.addToBlockMappings(block, food, Diet.INSECTIVORE, true);
    }

    public void addInsect(ItemStack item, int food) {
        this.addToItemMappings(item, food, Diet.INSECTIVORE);
    }

    public void addInsect(String ore_dictionary_name, int food) {
        this.addOreDictionary(ore_dictionary_name, food, Diet.INSECTIVORE);
    }

    private void addOreDictionary(String dict_name, int food_value, Diet diet) {
        NonNullList stacks = OreDictionary.getOres((String)dict_name);
        if (!stacks.isEmpty()) {
            for (ItemStack stack : stacks) {
                if (stack.func_190926_b()) continue;
                if (stack.func_77973_b() instanceof ItemBlock) {
                    this.addToBlockMappings(((ItemBlock)stack.func_77973_b()).func_179223_d(), food_value, diet, true);
                    continue;
                }
                this.addToItemMappings(stack, food_value, diet);
            }
        }
    }
}

