#version 120

uniform sampler2D DiffuseSampler;
uniform float Correctness;

varying vec4 color;
varying vec2 uv;

void main() {
    vec4 tex = texture2D(DiffuseSampler, uv);
    vec3 tint = mix(vec3(1, 0.5, 0.5), vec3(0.5, 1, 0.5), Correctness);
    tex.rgb *= tint;
    tex.a *= 0.5;
    gl_FragColor = tex * color * 0.8;
}
