#version 120

varying vec2 texCoord;

uniform sampler2D DiffuseSampler;

uniform float Intensity;

void main() {
    vec4 defaultColor = texture2D(DiffuseSampler, texCoord);

    vec3 red = vec3(0.625, 0.375, 0.00);
    vec3 green = vec3(0.700, 0.300, 0.00);
    vec3 blue = vec3(0.000, 0.300, 0.70);

    vec3 newColor = vec3(dot(defaultColor.rgb, red), dot(defaultColor.rgb, green), dot(defaultColor.rgb, blue));
    gl_FragColor = vec4(mix(defaultColor.rgb, newColor, Intensity), 1.0);
}
