/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.item.IItemCharge;
import moze_intel.projecte.api.item.IModeChanger;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class TimeWatch
extends ItemPE
implements IModeChanger,
IBauble,
IPedestalItem,
IItemCharge {
    public static final Set<String> internalBlacklist = Sets.newHashSet((Object[])new String[]{"Reika.ChromatiCraft.TileEntity.AOE.TileEntityAccelerator", "com.sci.torcherino.tile.TileTorcherino", "com.sci.torcherino.tile.TileCompressedTorcherino", "thaumcraft.common.tiles.crafting.TileSmelter", "TileMultipart_cmp$$0", "TileMultipart_cmp$$1", "TileMultipart_cmp$$2", "codechicken.multipart.TileMultipart", "codechicken.multipart.BlockMultipart"});

    public TimeWatch() {
        this.func_77655_b("time_watch");
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_185043_a(ACTIVE_NAME, ACTIVE_GETTER);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (!ProjectEConfig.items.enableTimeWatch) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("pe.timewatch.disabled", new Object[0]));
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
            }
            byte current = this.getTimeBoost(stack);
            this.setTimeBoost(stack, (byte)(current == 2 ? 0 : current + 1));
            player.func_145747_a((ITextComponent)new TextComponentTranslation("pe.timewatch.mode_switch", new Object[]{new TextComponentTranslation(this.getTimeName(stack), new Object[0]).func_150261_e()}));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int invSlot, boolean isHeld) {
        float mobSlowdown;
        int bonusTicks;
        super.func_77663_a(stack, world, entity, invSlot, isHeld);
        if (!(entity instanceof EntityPlayer) || invSlot > 8) {
            return;
        }
        if (!ProjectEConfig.items.enableTimeWatch) {
            return;
        }
        byte timeControl = this.getTimeBoost(stack);
        if (world.func_82736_K().func_82766_b("doDaylightCycle")) {
            if (timeControl == 1) {
                if (world.func_72820_D() + (long)((this.getCharge(stack) + 1) * 4) > Long.MAX_VALUE) {
                    world.func_72877_b(Long.MAX_VALUE);
                } else {
                    world.func_72877_b(world.func_72820_D() + (long)((this.getCharge(stack) + 1) * 4));
                }
            } else if (timeControl == 2) {
                if (world.func_72820_D() - (long)((this.getCharge(stack) + 1) * 4) < 0L) {
                    world.func_72877_b(0L);
                } else {
                    world.func_72877_b(world.func_72820_D() - (long)((this.getCharge(stack) + 1) * 4));
                }
            }
        }
        if (world.field_72995_K || !ItemHelper.getOrCreateCompound(stack).func_74767_n("Active")) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        long reqEmc = EMCHelper.removeFractionalEMC(stack, this.getEmcPerTick(this.getCharge(stack)));
        if (!TimeWatch.consumeFuel(player, stack, reqEmc, true)) {
            return;
        }
        int charge = this.getCharge(stack);
        if (charge == 0) {
            bonusTicks = 8;
            mobSlowdown = 0.25f;
        } else if (charge == 1) {
            bonusTicks = 12;
            mobSlowdown = 0.16f;
        } else {
            bonusTicks = 16;
            mobSlowdown = 0.12f;
        }
        AxisAlignedBB bBox = player.func_174813_aQ().func_186662_g(8.0);
        this.speedUpTileEntities(world, bonusTicks, bBox);
        this.speedUpRandomTicks(world, bonusTicks, bBox);
        this.slowMobs(world, bBox, mobSlowdown);
    }

    private void slowMobs(World world, AxisAlignedBB bBox, float mobSlowdown) {
        if (bBox == null) {
            return;
        }
        for (Object obj : world.func_72872_a(EntityLiving.class, bBox)) {
            Entity ent = (Entity)obj;
            if (ent.field_70159_w != 0.0) {
                ent.field_70159_w *= (double)mobSlowdown;
            }
            if (ent.field_70179_y == 0.0) continue;
            ent.field_70179_y *= (double)mobSlowdown;
        }
    }

    private void speedUpTileEntities(World world, int bonusTicks, AxisAlignedBB bBox) {
        if (bBox == null || bonusTicks == 0) {
            return;
        }
        List<TileEntity> list = WorldHelper.getTileEntitiesWithinAABB(world, bBox);
        for (int i = 0; i < bonusTicks; ++i) {
            for (TileEntity tile : list) {
                if (tile.func_145837_r() || !(tile instanceof ITickable)) continue;
                ((ITickable)tile).func_73660_a();
            }
        }
    }

    private void speedUpRandomTicks(World world, int bonusTicks, AxisAlignedBB bBox) {
        if (bBox == null || bonusTicks == 0) {
            return;
        }
        for (BlockPos pos : WorldHelper.getPositionsFromBox(bBox)) {
            for (int i = 0; i < bonusTicks; ++i) {
                IBlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (!block.func_149653_t() || block.func_149716_u() || WorldHelper.isBlacklisted(block) || block instanceof BlockLiquid || block instanceof BlockFluidBase || block instanceof IGrowable || block instanceof IPlantable) continue;
                block.func_180650_b(world, pos, state, field_77697_d);
            }
        }
    }

    private String getTimeName(ItemStack stack) {
        byte mode = this.getTimeBoost(stack);
        switch (mode) {
            case 0: {
                return "pe.timewatch.off";
            }
            case 1: {
                return "pe.timewatch.ff";
            }
            case 2: {
                return "pe.timewatch.rw";
            }
        }
        return "ERROR_INVALID_MODE";
    }

    private byte getTimeBoost(ItemStack stack) {
        return ItemHelper.getOrCreateCompound(stack).func_74771_c("TimeMode");
    }

    private void setTimeBoost(ItemStack stack, byte time) {
        ItemHelper.getOrCreateCompound(stack).func_74774_a("TimeMode", (byte)MathHelper.func_76125_a((int)time, (int)0, (int)2));
    }

    public double getEmcPerTick(int charge) {
        int actualCharge = charge + 2;
        return 10.0 * (double)actualCharge / 20.0;
    }

    @Override
    public byte getMode(@Nonnull ItemStack stack) {
        return ItemHelper.getOrCreateCompound(stack).func_74767_n("Active") ? (byte)1 : 0;
    }

    @Override
    public boolean changeMode(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, EnumHand hand) {
        NBTTagCompound tag;
        tag.func_74757_a("Active", !(tag = ItemHelper.getOrCreateCompound(stack)).func_74767_n("Active"));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flags) {
        list.add(I18n.func_135052_a((String)"pe.timewatch.tooltip1", (Object[])new Object[0]));
        list.add(I18n.func_135052_a((String)"pe.timewatch.tooltip2", (Object[])new Object[0]));
        if (stack.func_77942_o()) {
            list.add(I18n.func_135052_a((String)"pe.timewatch.mode", (Object[])new Object[]{I18n.func_135052_a((String)this.getTimeName(stack), (Object[])new Object[0])}));
        }
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.BELT;
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.func_77663_a(stack, player.func_130014_f_(), (Entity)player, 0, false);
    }

    @Optional.Method(modid="baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        TileEntity te;
        if (!world.field_72995_K && ProjectEConfig.items.enableTimeWatch && (te = world.func_175625_s(pos)) instanceof DMPedestalTile) {
            AxisAlignedBB bBox = ((DMPedestalTile)te).getEffectBounds();
            if (ProjectEConfig.effects.timePedBonus > 0) {
                this.speedUpTileEntities(world, ProjectEConfig.effects.timePedBonus, bBox);
                this.speedUpRandomTicks(world, ProjectEConfig.effects.timePedBonus, bBox);
            }
            if (ProjectEConfig.effects.timePedMobSlowness < 1.0f) {
                this.slowMobs(world, bBox, ProjectEConfig.effects.timePedMobSlowness);
            }
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public List<String> getPedestalDescription() {
        ArrayList<String> list = new ArrayList<String>();
        if (ProjectEConfig.effects.timePedBonus > 0) {
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.timewatch.pedestal1", (Object[])new Object[]{ProjectEConfig.effects.timePedBonus}));
        }
        if (ProjectEConfig.effects.timePedMobSlowness < 1.0f) {
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.timewatch.pedestal2", (Object[])new Object[]{Float.valueOf(ProjectEConfig.effects.timePedMobSlowness)}));
        }
        return list;
    }

    public static void blacklist(Class<? extends TileEntity> clazz) {
        internalBlacklist.add(clazz.getName());
    }

    @Override
    public int getNumCharges(@Nonnull ItemStack stack) {
        return 2;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getCharge(stack) / (double)this.getNumCharges(stack);
    }
}

