/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.utils.Log;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class SideFilterData
implements ICapabilityProvider {
    public static final int INVENTORY_SIZE = 27;
    private ItemStackHandler inventory = new ItemStackHandler(27);
    private boolean matchNBT;
    private boolean matchMetadata;
    private boolean acceptUnsortedItems;

    public boolean matchNBT() {
        return this.matchNBT;
    }

    public void setMatchNBT(boolean matchNBT) {
        this.matchNBT = matchNBT;
    }

    public boolean matchMetadata() {
        return this.matchMetadata;
    }

    public void setMatchMetadata(boolean matchMetadata) {
        this.matchMetadata = matchMetadata;
    }

    public boolean acceptsUnsortedItems() {
        return this.acceptUnsortedItems;
    }

    public void setAcceptUnsortedItems(boolean acceptUnsortedItems) {
        this.acceptUnsortedItems = acceptUnsortedItems;
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        nbtTagCompound.func_74757_a("matchNBT", this.matchNBT);
        nbtTagCompound.func_74757_a("matchMetadata", this.matchMetadata);
        nbtTagCompound.func_74757_a("acceptUnsortedItems", this.acceptUnsortedItems);
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        this.inventory.deserializeNBT(nbtTagCompound.func_74775_l("inventory"));
        this.matchNBT = nbtTagCompound.func_74767_n("matchNBT");
        this.matchMetadata = nbtTagCompound.func_74767_n("matchMetadata");
        this.acceptUnsortedItems = nbtTagCompound.func_74767_n("acceptUnsortedItems");
    }

    public boolean matchesStack(ItemStack stack) {
        if (stack == null) {
            Log.error("SideFilterData.matchesSide() called with null argument!");
            return false;
        }
        if (stack == ItemStack.field_190927_a) {
            Log.error("SideFilterData.matchesSide() called with empty argument!");
            return false;
        }
        for (int index = 0; index < 27; ++index) {
            ItemStack slotStack = this.inventory.getStackInSlot(index);
            if (slotStack == ItemStack.field_190927_a || slotStack.func_77973_b() != stack.func_77973_b() || this.matchMetadata && stack.func_77952_i() != slotStack.func_77952_i()) continue;
            if (!this.matchNBT || !slotStack.func_77942_o() && !stack.func_77942_o()) {
                return true;
            }
            if (!slotStack.func_77942_o() || !stack.func_77942_o() || !slotStack.func_77978_p().equals((Object)stack.func_77978_p())) continue;
            return true;
        }
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return null;
    }
}

