/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.client.gui;

import com.verdantartifice.thaumicwonders.client.config.TWConfig;
import com.verdantartifice.thaumicwonders.common.entities.EntityFlyingCarpet;
import com.verdantartifice.thaumicwonders.common.items.tools.ItemPrimalDestroyer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.casters.ICaster;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.config.ModConfig;
import thaumcraft.common.items.tools.ItemSanityChecker;
import thaumcraft.common.items.tools.ItemThaumometer;

@SideOnly(value=Side.CLIENT)
public class HudManager {
    private static final ResourceLocation HUD = new ResourceLocation("thaumicwonders", "textures/gui/hud.png");

    public void renderHuds(Minecraft mc, float renderTickTime, EntityPlayer player, long time) {
        if (!TWConfig.general_settings.I_HUD) {
            return;
        }
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.func_78327_c(), (double)sr.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GlStateManager.func_179147_l();
        GL11.glBlendFunc((int)770, (int)771);
        if (mc.field_71415_G && Minecraft.func_71382_s()) {
            Entity ridingEntity;
            mc.field_71446_o.func_110577_a(HUD);
            ItemStack mhStack = player.func_184614_ca();
            Item mhStackItem = null;
            if (mhStack != null && !mhStack.func_190926_b()) {
                mhStackItem = mhStack.func_77973_b();
            }
            ItemStack ohStack = player.func_184592_cb();
            Item ohStackItem = null;
            if (ohStack != null && !ohStack.func_190926_b()) {
                ohStackItem = ohStack.func_77973_b();
            }
            int yStart = 0;
            if ((mhStackItem instanceof ICaster || ohStackItem instanceof ICaster) && !ModConfig.CONFIG_GRAPHICS.dialBottom) {
                yStart += 33;
            }
            if (mhStackItem instanceof ItemThaumometer || ohStackItem instanceof ItemThaumometer) {
                yStart += 80;
            }
            if (mhStackItem instanceof ItemSanityChecker || ohStackItem instanceof ItemSanityChecker) {
                yStart += 75;
            }
            if (mhStackItem instanceof ItemPrimalDestroyer) {
                this.renderPrimalDestroyerHud(mc, renderTickTime, player, mhStack, time, yStart);
                yStart += 77;
            }
            if (ohStackItem instanceof ItemPrimalDestroyer) {
                this.renderPrimalDestroyerHud(mc, renderTickTime, player, ohStack, time, yStart);
                yStart += 77;
            }
            if ((ridingEntity = player.func_184187_bx()) != null && ridingEntity instanceof EntityFlyingCarpet) {
                this.renderCarpetHud(mc, renderTickTime, player, (EntityFlyingCarpet)ridingEntity, time, yStart);
                yStart += 77;
            }
        }
        GlStateManager.func_179084_k();
        GL11.glPopMatrix();
    }

    private void renderPrimalDestroyerHud(Minecraft mc, float partialTicks, EntityPlayer player, ItemStack itemStack, long time, int yStart) {
        GL11.glPushMatrix();
        GlStateManager.func_179147_l();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslated((double)0.0, (double)yStart, (double)0.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        UtilsFX.drawTexturedQuad((float)1.0f, (float)1.0f, (float)152.0f, (float)0.0f, (float)20.0f, (float)78.0f, (double)-90.0);
        int hunger = itemStack.func_77942_o() ? itemStack.func_77978_p().func_74762_e("hunger") : 0;
        int gap = (int)((600.0f - (float)hunger) / 600.0f * 48.0f);
        if (hunger > 0) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)0.5f, (float)0.0f, (float)0.5f, (float)1.0f);
            UtilsFX.drawTexturedQuad((float)7.0f, (float)(23 + gap), (float)200.0f, (float)gap, (float)8.0f, (float)48.0f, (double)-90.0);
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        UtilsFX.drawTexturedQuad((float)1.0f, (float)1.0f, (float)128.0f, (float)0.0f, (float)20.0f, (float)78.0f, (double)-90.0);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    private void renderCarpetHud(Minecraft mc, float partialTicks, EntityPlayer player, EntityFlyingCarpet carpet, long time, int yStart) {
        GL11.glPushMatrix();
        GlStateManager.func_179147_l();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslated((double)0.0, (double)yStart, (double)0.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        UtilsFX.drawTexturedQuad((float)1.0f, (float)1.0f, (float)152.0f, (float)0.0f, (float)20.0f, (float)78.0f, (double)-90.0);
        int vis = carpet.getVisCharge();
        int gap = (int)((100.0f - (float)vis) / 100.0f * 48.0f);
        if (vis > 0) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)0.5f, (float)1.0f, (float)1.0f);
            UtilsFX.drawTexturedQuad((float)7.0f, (float)(23 + gap), (float)200.0f, (float)gap, (float)8.0f, (float)48.0f, (double)-90.0);
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        UtilsFX.drawTexturedQuad((float)1.0f, (float)1.0f, (float)176.0f, (float)0.0f, (float)20.0f, (float)78.0f, (double)-90.0);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }
}

