/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.blocks.base;

import com.verdantartifice.thaumicwonders.ThaumicWonders;
import com.verdantartifice.thaumicwonders.common.blocks.base.BlockTileTW;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.common.blocks.IBlockEnabled;
import thaumcraft.common.blocks.IBlockFacing;
import thaumcraft.common.blocks.IBlockFacingHorizontal;
import thaumcraft.common.lib.utils.BlockStateUtils;

public class BlockDeviceTW<T extends TileEntity>
extends BlockTileTW<T> {
    public BlockDeviceTW(Material mat, Class<T> tileClass, String name) {
        super(mat, tileClass, name);
        IBlockState blockState = this.field_176227_L.func_177621_b();
        if (this instanceof IBlockFacingHorizontal) {
            blockState.func_177226_a((IProperty)IBlockFacingHorizontal.FACING, (Comparable)EnumFacing.NORTH);
        } else if (this instanceof IBlockFacing) {
            blockState.func_177226_a((IProperty)IBlockFacing.FACING, (Comparable)EnumFacing.UP);
        }
        if (this instanceof IBlockEnabled) {
            blockState.func_177226_a((IProperty)IBlockEnabled.ENABLED, (Comparable)Boolean.valueOf(true));
        }
        this.func_180632_j(blockState);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.updateState(worldIn, pos, state);
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.updateState(worldIn, pos, state);
    }

    protected void updateState(World worldIn, BlockPos pos, IBlockState state) {
        if (this instanceof IBlockEnabled) {
            boolean flag;
            boolean bl = flag = !worldIn.func_175640_z(pos);
            if (flag != (Boolean)state.func_177229_b((IProperty)IBlockEnabled.ENABLED)) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)IBlockEnabled.ENABLED, (Comparable)Boolean.valueOf(flag)), 3);
            }
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = this.func_176223_P();
        if (this instanceof IBlockFacingHorizontal) {
            EnumFacing placerFacing = placer.func_174811_aO();
            state = state.func_177226_a((IProperty)IBlockFacingHorizontal.FACING, (Comparable)(placer.func_70093_af() ? placerFacing : placerFacing.func_176734_d()));
        } else if (this instanceof IBlockFacing) {
            EnumFacing direction = EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer);
            state = state.func_177226_a((IProperty)IBlockFacing.FACING, (Comparable)(placer.func_70093_af() ? direction.func_176734_d() : direction));
        }
        if (this instanceof IBlockEnabled) {
            state = state.func_177226_a((IProperty)IBlockEnabled.ENABLED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        try {
            if (this instanceof IBlockFacingHorizontal) {
                EnumFacing facing = BlockStateUtils.getFacing((int)meta);
                if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
                    facing = EnumFacing.NORTH;
                }
                state = state.func_177226_a((IProperty)IBlockFacingHorizontal.FACING, (Comparable)facing);
            } else if (this instanceof IBlockFacing) {
                state = state.func_177226_a((IProperty)IBlockFacing.FACING, (Comparable)BlockStateUtils.getFacing((int)meta));
            }
            if (this instanceof IBlockEnabled) {
                state = state.func_177226_a((IProperty)IBlockEnabled.ENABLED, (Comparable)Boolean.valueOf(BlockStateUtils.isEnabled((int)meta)));
            }
        }
        catch (Exception e) {
            ThaumicWonders.LOGGER.catching((Throwable)e);
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (this instanceof IBlockFacingHorizontal) {
            meta = ((EnumFacing)state.func_177229_b((IProperty)IBlockFacingHorizontal.FACING)).func_176745_a();
        } else if (this instanceof IBlockFacing) {
            meta = ((EnumFacing)state.func_177229_b((IProperty)IBlockFacing.FACING)).func_176745_a();
        }
        if (this instanceof IBlockEnabled && !((Boolean)state.func_177229_b((IProperty)IBlockEnabled.ENABLED)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    protected BlockStateContainer func_180661_e() {
        ArrayList<Object> properties = new ArrayList<Object>();
        if (this instanceof IBlockFacingHorizontal) {
            properties.add(IBlockFacingHorizontal.FACING);
        } else if (this instanceof IBlockFacing) {
            properties.add(IBlockFacing.FACING);
        }
        if (this instanceof IBlockEnabled) {
            properties.add(IBlockEnabled.ENABLED);
        }
        return properties.size() == 0 ? super.func_180661_e() : new BlockStateContainer((Block)this, properties.toArray(new IProperty[properties.size()]));
    }
}

