/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.blocks.devices;

import com.verdantartifice.thaumicwonders.common.blocks.base.BlockDeviceTW;
import com.verdantartifice.thaumicwonders.common.tiles.devices.TileAlkahestVat;
import java.util.List;
import java.util.Random;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.damagesource.DamageSourceThaumcraft;

public class BlockAlkahestVat
extends BlockDeviceTW<TileAlkahestVat> {
    protected static final AxisAlignedBB AABB_LEGS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0);
    protected static final AxisAlignedBB AABB_WALL_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB AABB_WALL_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_EAST = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);
    protected int delay = 0;

    public BlockAlkahestVat() {
        super(Material.field_151573_f, TileAlkahestVat.class, "alkahest_vat");
        this.func_149672_a(SoundType.field_185852_e);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        BlockAlkahestVat.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_LEGS);
        BlockAlkahestVat.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_WEST);
        BlockAlkahestVat.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_NORTH);
        BlockAlkahestVat.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_EAST);
        BlockAlkahestVat.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_SOUTH);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!worldIn.field_72995_K) {
            if (entityIn instanceof EntityItem) {
                this.releaseVis(worldIn, pos, ((EntityItem)entityIn).func_92059_d());
                entityIn.func_70106_y();
                this.playHissSound(worldIn, pos);
            } else {
                ++this.delay;
                if (this.delay >= 10) {
                    this.delay = 0;
                    if (entityIn instanceof EntityLivingBase) {
                        entityIn.func_70097_a(DamageSourceThaumcraft.dissolve, 1.0f);
                        this.playHissSound(worldIn, pos);
                    }
                }
            }
        }
        super.func_180634_a(worldIn, pos, state, entityIn);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && facing == EnumFacing.UP) {
            ItemStack tempStack = playerIn.func_184586_b(hand).func_77946_l();
            tempStack.func_190920_e(1);
            this.releaseVis(worldIn, pos, tempStack);
            playerIn.field_71071_by.func_70298_a(playerIn.field_71071_by.field_70461_c, 1);
            this.playHissSound(worldIn, pos);
        }
        return true;
    }

    protected void releaseVis(World worldIn, BlockPos pos, ItemStack stack) {
        if (stack != null && !stack.func_190926_b()) {
            ItemStack tempStack = stack.func_77946_l();
            tempStack.func_190920_e(1);
            float toRelease = (float)stack.func_190916_E() * 0.01f * MathHelper.func_76129_c((float)AspectHelper.getObjectAspects((ItemStack)tempStack).visSize());
            if (toRelease > 0.0f) {
                AuraHelper.addVis((World)worldIn, (BlockPos)pos, (float)toRelease);
            }
        }
    }

    protected void playHissSound(World worldIn, BlockPos pos) {
        worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.4f, 2.0f + worldIn.field_73012_v.nextFloat() * 0.4f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(10) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.1f + rand.nextFloat() * 0.1f, 1.2f + rand.nextFloat() * 0.2f, false);
        }
    }
}

