/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.blocks.devices;

import com.verdantartifice.thaumicwonders.common.blocks.BlocksTW;
import com.verdantartifice.thaumicwonders.common.blocks.base.BlockTW;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aura.AuraHelper;

public class BlockFluxCapacitor
extends BlockTW {
    public static final PropertyInteger CHARGE = PropertyInteger.func_177719_a((String)"charge", (int)0, (int)10);

    public BlockFluxCapacitor() {
        super(Material.field_151576_e, "flux_capacitor");
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)CHARGE, (Comparable)Integer.valueOf(0)));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            int charge = this.func_176201_c(state);
            if (worldIn.func_175640_z(pos)) {
                if (charge > 0) {
                    AuraHelper.polluteAura((World)worldIn, (BlockPos)pos, (float)1.0f, (boolean)true);
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)CHARGE, (Comparable)Integer.valueOf(charge - 1)));
                    worldIn.func_175684_a(pos, state.func_177230_c(), 5);
                }
            } else {
                float flux = AuraHelper.getFlux((World)worldIn, (BlockPos)pos);
                if (charge < 10 && flux >= 1.0f) {
                    AuraHelper.drainFlux((World)worldIn, (BlockPos)pos, (float)1.0f, (boolean)false);
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)CHARGE, (Comparable)Integer.valueOf(charge + 1)));
                    worldIn.func_175684_a(pos, state.func_177230_c(), 100 + rand.nextInt(100));
                }
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (worldIn.func_175640_z(pos)) {
            worldIn.func_175684_a(pos, (Block)this, 1);
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return this.func_176201_c(blockState);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177230_c().func_176201_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(IBlockState state, IBlockAccess source, BlockPos pos) {
        int i = source.func_175626_b(pos, state.getLightValue(source, pos));
        int j = 180;
        int k = i & 0xFF;
        int l = j & 0xFF;
        int i1 = i >> 16 & 0xFF;
        int j1 = j >> 16 & 0xFF;
        return (k > l ? k : l) | (i1 > j1 ? i1 : j1) << 16;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CHARGE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CHARGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)CHARGE);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        ItemStack drop = new ItemStack((Block)this);
        if (!drop.func_77942_o()) {
            drop.func_77982_d(new NBTTagCompound());
        }
        drop.func_77978_p().func_74768_a("charge", this.func_176201_c(state));
        BlockFluxCapacitor.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)drop);
    }

    public int getCharge(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() == BlocksTW.FLUX_CAPACITOR) {
            return state.func_177230_c().func_176201_c(state);
        }
        return 0;
    }

    public void decrementCharge(World worldIn, BlockPos pos, int amount) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() == BlocksTW.FLUX_CAPACITOR) {
            int charge = this.func_176201_c(state);
            int newCharge = Math.max(0, charge - amount);
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)CHARGE, (Comparable)Integer.valueOf(newCharge)));
        }
    }
}

