/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.crafting.recipes;

import com.verdantartifice.thaumicwonders.common.items.ItemsTW;
import com.verdantartifice.thaumicwonders.common.items.entities.ItemFlyingCarpet;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.DyeUtils;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeFlyingCarpetDyes
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public RecipeFlyingCarpetDyes() {
        this.setRegistryName(new ResourceLocation("thaumicwonders", "flying_carpet_dyes"));
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World worldIn) {
        boolean foundCarpet = false;
        boolean foundDye = false;
        for (int index = 0; index < inv.func_70302_i_(); ++index) {
            ItemStack stack = inv.func_70301_a(index);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == ItemsTW.FLYING_CARPET && !foundCarpet) {
                foundCarpet = true;
                continue;
            }
            if (DyeUtils.isDye((ItemStack)stack) && !foundDye) {
                foundDye = true;
                continue;
            }
            return false;
        }
        return foundCarpet && foundDye;
    }

    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        ItemStack carpetStack = ItemStack.field_190927_a;
        EnumDyeColor color = null;
        for (int index = 0; index < inv.func_70302_i_(); ++index) {
            ItemStack stack = inv.func_70301_a(index);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == ItemsTW.FLYING_CARPET) {
                carpetStack = stack.func_77946_l();
                continue;
            }
            if (!DyeUtils.isDye((ItemStack)stack)) continue;
            color = DyeUtils.colorFromStack((ItemStack)stack).orElse(null);
        }
        if (!carpetStack.func_190926_b() && carpetStack.func_77973_b() instanceof ItemFlyingCarpet && color != null) {
            ((ItemFlyingCarpet)carpetStack.func_77973_b()).setDyeColor(carpetStack, color);
        }
        return carpetStack;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 || height >= 2;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }
}

