/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.network.packets;

import com.verdantartifice.thaumicwonders.common.misc.OreHelper;
import com.verdantartifice.thaumicwonders.common.tiles.devices.TileOreDiviner;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.common.lib.utils.Utils;

public class PacketOreDivinerSearch
implements IMessage {
    protected BlockPos origin;
    protected ItemStack searchStack;

    public PacketOreDivinerSearch() {
        this.origin = null;
        this.searchStack = null;
    }

    public PacketOreDivinerSearch(BlockPos origin, ItemStack searchStack) {
        this.origin = origin;
        this.searchStack = searchStack;
    }

    public void fromBytes(ByteBuf buf) {
        this.origin = BlockPos.func_177969_a((long)buf.readLong());
        this.searchStack = new ItemStack(Utils.readNBTTagCompoundFromBuffer((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.origin.func_177986_g());
        Utils.writeNBTTagCompoundToBuffer((ByteBuf)buf, (NBTTagCompound)this.searchStack.func_77955_b(new NBTTagCompound()));
    }

    public static class Handler
    implements IMessageHandler<PacketOreDivinerSearch, IMessage> {
        public IMessage onMessage(PacketOreDivinerSearch message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private void handle(PacketOreDivinerSearch message, MessageContext ctx) {
            TileEntity tile;
            WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
            EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
            if (message.origin != null && message.searchStack != null && (tile = world.func_175625_s(message.origin)) != null && tile instanceof TileOreDiviner && OreHelper.isOreBlock(message.searchStack)) {
                BlockPos target = this.search((World)world, message.origin, message.searchStack, 20);
                if (target == null) {
                    entityPlayer.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)"event.ore_diviner.not_found", (Object[])new Object[0])), true);
                } else {
                    BlockPos delta = target.func_177973_b((Vec3i)message.origin);
                    EnumFacing facing = EnumFacing.func_176737_a((float)delta.func_177958_n(), (float)delta.func_177956_o(), (float)delta.func_177952_p());
                    entityPlayer.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)("event.ore_diviner.found." + facing.func_176610_l()), (Object[])new Object[0])), true);
                }
                ((TileOreDiviner)tile).setTarget(target);
            }
        }

        @SideOnly(value=Side.CLIENT)
        @Nullable
        private BlockPos search(World world, BlockPos origin, ItemStack searchStack, int maxRange) {
            BlockPos target = null;
            for (int dist = 1; dist <= maxRange && (target = this.searchShell(world, origin, searchStack, dist)) == null; ++dist) {
            }
            return target;
        }

        @SideOnly(value=Side.CLIENT)
        @Nullable
        private BlockPos searchShell(World world, BlockPos origin, ItemStack searchStack, int distance) {
            Set<BlockPos> posSet = this.generateShell(origin, distance);
            for (BlockPos pos : posSet) {
                ItemStack posStack = this.getStackAtPos(world, pos);
                if (posStack == null || !OreHelper.isOreMatch(posStack, searchStack)) continue;
                return pos;
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private Set<BlockPos> generateShell(BlockPos origin, int radius) {
            HashSet<BlockPos> posSet = new HashSet<BlockPos>();
            this.generateXPlanes(origin, radius, posSet);
            this.generateYPlanes(origin, radius, posSet);
            this.generateZPlanes(origin, radius, posSet);
            return posSet;
        }

        @SideOnly(value=Side.CLIENT)
        private void generateXPlanes(BlockPos origin, int radius, Set<BlockPos> posSet) {
            for (int yy = -radius; yy <= radius; ++yy) {
                for (int zz = -radius; zz <= radius; ++zz) {
                    posSet.add(origin.func_177982_a(radius, yy, zz));
                    posSet.add(origin.func_177982_a(-radius, yy, zz));
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void generateYPlanes(BlockPos origin, int radius, Set<BlockPos> posSet) {
            for (int xx = -radius; xx <= radius; ++xx) {
                for (int zz = -radius; zz <= radius; ++zz) {
                    posSet.add(origin.func_177982_a(xx, radius, zz));
                    posSet.add(origin.func_177982_a(xx, -radius, zz));
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void generateZPlanes(BlockPos origin, int radius, Set<BlockPos> posSet) {
            for (int xx = -radius; xx <= radius; ++xx) {
                for (int yy = -radius; yy <= radius; ++yy) {
                    posSet.add(origin.func_177982_a(xx, yy, radius));
                    posSet.add(origin.func_177982_a(xx, yy, -radius));
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        @Nonnull
        private ItemStack getStackAtPos(World world, BlockPos pos) {
            ItemStack stack = ItemStack.field_190927_a;
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() != Blocks.field_150350_a && state.func_177230_c() != Blocks.field_150357_h) {
                Item item;
                stack = new ItemStack(item, 1, (item = Item.func_150898_a((Block)state.func_177230_c())).func_77614_k() ? state.func_177230_c().func_176201_c(state) : 0);
            }
            return stack;
        }
    }
}

