/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.network.packets;

import com.verdantartifice.thaumicwonders.common.items.misc.ItemTimewinder;
import com.verdantartifice.thaumicwonders.common.network.PacketHandler;
import com.verdantartifice.thaumicwonders.common.network.packets.PacketLocalizedMessage;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.items.RechargeHelper;

public class PacketTimewinderAction
implements IMessage {
    private int targetPhase;

    public PacketTimewinderAction() {
        this.targetPhase = -1;
    }

    public PacketTimewinderAction(int targetPhase) {
        this.targetPhase = targetPhase;
    }

    public void fromBytes(ByteBuf buf) {
        this.targetPhase = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.targetPhase);
    }

    public static class Handler
    implements IMessageHandler<PacketTimewinderAction, IMessage> {
        public IMessage onMessage(PacketTimewinderAction message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketTimewinderAction message, MessageContext ctx) {
            EntityPlayerMP entityPlayer = ctx.getServerHandler().field_147369_b;
            ItemStack timewinderStack = this.getTimewinderStack(entityPlayer);
            World world = entityPlayer.func_130014_f_();
            long currentTime = world.func_72820_D();
            long dayStart = currentTime - currentTime % 24000L;
            if (timewinderStack == null) {
                return;
            }
            if (RechargeHelper.consumeCharge((ItemStack)timewinderStack, (EntityLivingBase)entityPlayer, (int)25)) {
                if (message.targetPhase >= 0 && message.targetPhase <= 7) {
                    int currentMoonPhase = (int)(currentTime / 24000L % 8L + 8L) % 8;
                    int daysToAdvance = message.targetPhase != currentMoonPhase ? (message.targetPhase - currentMoonPhase + 8) % 8 : (currentTime % 24000L <= 13500L ? 0 : 8);
                    long targetTime = dayStart + (long)daysToAdvance * 24000L + 13500L;
                    this.doTimeJump(timewinderStack, world, entityPlayer, targetTime);
                } else if (message.targetPhase == 8) {
                    this.doTimeJump(timewinderStack, world, entityPlayer, dayStart + 24000L);
                }
            }
        }

        @Nullable
        private ItemStack getTimewinderStack(EntityPlayerMP entityPlayer) {
            ItemStack stack = entityPlayer.func_184614_ca();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemTimewinder) {
                return stack;
            }
            stack = entityPlayer.func_184592_cb();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemTimewinder) {
                return stack;
            }
            return null;
        }

        private void doTimeJump(ItemStack stack, World world, EntityPlayerMP entityPlayer, long targetTime) {
            entityPlayer.func_184811_cZ().func_185145_a(stack.func_77973_b(), 1200);
            world.func_72877_b(targetTime);
            AuraHelper.polluteAura((World)world, (BlockPos)entityPlayer.func_180425_c(), (float)10.0f, (boolean)true);
            PacketHandler.INSTANCE.sendToAll((IMessage)new PacketLocalizedMessage("event.timewinder.used"));
        }
    }
}

