/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.research.theorycraft;

import com.verdantartifice.thaumicwonders.common.tiles.devices.IResearchEngine;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.api.research.theorycraft.ResearchTableData;
import thaumcraft.api.research.theorycraft.TheorycraftCard;

public abstract class AbstractResearchEngineCard
extends TheorycraftCard {
    protected abstract Class<? extends IResearchEngine> getEngineTileClass();

    protected abstract int getResearchAmount(Random var1);

    public boolean isAidOnly() {
        return true;
    }

    public boolean initialize(EntityPlayer player, ResearchTableData data) {
        return this.findFueledEngine(data.table.func_145831_w(), data.table.func_174877_v()) != null;
    }

    public boolean activate(EntityPlayer player, ResearchTableData data) {
        IResearchEngine engineTile = this.findFueledEngine(data.table.func_145831_w(), data.table.func_174877_v());
        if (engineTile != null && engineTile.deductCost()) {
            data.addTotal(this.getResearchCategory(), this.getResearchAmount(player.func_70681_au()));
            ++data.bonusDraws;
            return true;
        }
        return false;
    }

    public int getInspirationCost() {
        return -1;
    }

    private IResearchEngine findFueledEngine(World world, BlockPos tablePos) {
        BlockPos.PooledMutableBlockPos pmbp = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int i = -4; i <= 4; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -4; k <= 4; ++k) {
                    IResearchEngine engineTile;
                    pmbp.func_181079_c(tablePos.func_177958_n() + i, tablePos.func_177956_o() + j, tablePos.func_177952_p() + k);
                    TileEntity tile = world.func_175625_s((BlockPos)pmbp);
                    if (tile == null || !tile.getClass().equals(this.getEngineTileClass()) || !(engineTile = (IResearchEngine)tile).isFueled()) continue;
                    pmbp.func_185344_t();
                    return engineTile;
                }
            }
        }
        pmbp.func_185344_t();
        return null;
    }
}

