/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.blocks.bedobstruction.mixin;

import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfigGeneral;
import mod.acgaming.universaltweaks.config.UTConfigTweaks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityPlayer.class})
public class UTBedObstructionMixin {
    @Inject(at={@At(value="HEAD")}, method={"getBedSpawnLocation(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Z)Lnet/minecraft/util/math/BlockPos;"}, cancellable=true)
    private static void utBedSpawnLocation(World world, BlockPos bedLocation, boolean forceSpawn, CallbackInfoReturnable<BlockPos> cir) {
        IBlockState state;
        Block block;
        if (!UTConfigTweaks.BLOCKS.utBedObstructionToggle) {
            return;
        }
        if (UTConfigGeneral.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTBedObstruction ::: Get bed spawn location");
        }
        if (!(block = (state = world.func_180495_p(bedLocation)).func_177230_c()).isBed(state, (IBlockAccess)world, bedLocation, null)) {
            if (!forceSpawn) {
                cir.setReturnValue(null);
            } else {
                cir.setReturnValue((Object)UTBedObstructionMixin.ut$iterateSpawnPoint(world, bedLocation));
            }
        } else {
            cir.setReturnValue((Object)UTBedObstructionMixin.ut$iterateBedPoint(world, bedLocation));
        }
    }

    @Unique
    private static BlockPos ut$iterateSpawnPoint(World world, BlockPos pos) {
        if (UTBedObstructionMixin.ut$isValidSpawnPos(world, pos, false)) {
            return pos;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int xIter = x - 1; xIter <= x + 1; ++xIter) {
            for (int zIter = z - 1; zIter <= z + 1; ++zIter) {
                BlockPos blockPos = new BlockPos(xIter, y, zIter);
                if (!UTBedObstructionMixin.ut$isValidSpawnPos(world, blockPos, false)) continue;
                return blockPos;
            }
        }
        return null;
    }

    @Unique
    private static BlockPos ut$iterateBedPoint(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        EnumFacing enumFacing = blockState.func_177227_a().contains(BlockHorizontal.field_185512_D) ? (EnumFacing)blockState.func_177229_b((IProperty)BlockHorizontal.field_185512_D) : EnumFacing.NORTH;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int yOffset = 0; yOffset <= 1; ++yOffset) {
            for (int facingOffset = 0; facingOffset <= 1; ++facingOffset) {
                int xOffset = x - enumFacing.func_82601_c() * facingOffset;
                int zOffset = z - enumFacing.func_82599_e() * facingOffset;
                for (int xIter = xOffset - 1; xIter <= xOffset + 1; ++xIter) {
                    for (int zIter = zOffset - 1; zIter <= zOffset + 1; ++zIter) {
                        BlockPos blockPos = new BlockPos(xIter, y + yOffset, zIter);
                        if (!UTBedObstructionMixin.ut$isValidSpawnPos(world, blockPos, true)) continue;
                        return blockPos;
                    }
                }
            }
        }
        return null;
    }

    @Unique
    private static boolean ut$isValidSpawnPos(World worldIn, BlockPos blockPos, boolean requireFloor) {
        return (worldIn.func_180495_p(blockPos.func_177977_b()).func_185904_a().func_76220_a() || !requireFloor) && worldIn.func_180495_p(blockPos).func_177230_c().func_181623_g() && worldIn.func_180495_p(blockPos.func_177984_a()).func_177230_c().func_181623_g();
    }
}

