/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.entities.spawning.creeper.confetti.mixin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfigGeneral;
import mod.acgaming.universaltweaks.config.UTConfigTweaks;
import mod.acgaming.universaltweaks.util.UTRandomUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.item.ItemDye;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityCreeper.class})
public abstract class UTCreeperConfettiMixin
extends EntityMob {
    @Unique
    private static final DataParameter<Boolean> ut$CONFETTI = EntityDataManager.func_187226_a(EntityCreeper.class, (DataSerializer)DataSerializers.field_187198_h);

    protected UTCreeperConfettiMixin(World worldIn) {
        super(worldIn);
    }

    @Shadow
    public abstract boolean func_70830_n();

    @Shadow
    protected abstract void func_190741_do();

    @Inject(method={"entityInit"}, at={@At(value="TAIL")})
    private void utRegisterConfetti(CallbackInfo ci) {
        this.field_70180_af.func_187214_a(ut$CONFETTI, (Object)Boolean.FALSE);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void utInitConfetti(World worldIn, CallbackInfo ci) {
        if (worldIn == null || worldIn.field_72995_K) {
            return;
        }
        double chargedChance = UTConfigTweaks.ENTITIES.CREEPER_CONFETTI.utCreeperConfettiChance;
        if (chargedChance > 0.0 && UTRandomUtil.chance(chargedChance, this.field_70146_Z)) {
            this.field_70180_af.func_187227_b(ut$CONFETTI, (Object)Boolean.TRUE);
        }
    }

    @Inject(method={"explode"}, at={@At(value="HEAD")}, cancellable=true)
    private void utDoConfetti(CallbackInfo ci) {
        if (!((Boolean)this.field_70180_af.func_187225_a(ut$CONFETTI)).booleanValue()) {
            return;
        }
        if (UTConfigGeneral.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTCreeperConfetti ::: Explode");
        }
        if (this.field_70170_p.field_72995_K) {
            BlockPos pos = this.func_180425_c();
            boolean powered = this.func_70830_n();
            this.field_70170_p.func_92088_a((double)pos.func_177958_n(), (double)((float)pos.func_177956_o() + (powered ? 2.5f : 0.5f)), (double)pos.func_177952_p(), 0.0, 0.0, 0.0, this.ut$generateTag(powered));
        } else {
            this.field_70729_aU = true;
            this.func_70106_y();
            this.func_190741_do();
            this.ut$damagePlayers((EntityCreeper)this);
        }
        ci.cancel();
    }

    @Unique
    private NBTTagCompound ut$generateTag(boolean powered) {
        NBTTagCompound fireworkTag = new NBTTagCompound();
        NBTTagCompound fireworkItemTag = new NBTTagCompound();
        NBTTagList nbttaglist = new NBTTagList();
        ArrayList list = Lists.newArrayList();
        list.add(ItemDye.field_150922_c[1]);
        list.add(ItemDye.field_150922_c[4]);
        list.add(ItemDye.field_150922_c[11]);
        for (int i = 0; i < this.field_70146_Z.nextInt(3) + 3; ++i) {
            list.add(ItemDye.field_150922_c[this.field_70146_Z.nextInt(15)]);
        }
        int[] colours = new int[list.size()];
        for (int j = 0; j < colours.length; ++j) {
            colours[j] = (Integer)list.get(j);
        }
        fireworkTag.func_74783_a("Colors", colours);
        fireworkTag.func_74757_a("Flicker", true);
        fireworkTag.func_74774_a("Type", (byte)(powered ? 3 : 4));
        nbttaglist.func_74742_a((NBTBase)fireworkTag);
        fireworkItemTag.func_74782_a("Explosions", (NBTBase)nbttaglist);
        return fireworkItemTag;
    }

    @Unique
    private void ut$damagePlayers(EntityCreeper creeper) {
        float explosionStrength = (float)(creeper.func_70830_n() ? UTConfigTweaks.ENTITIES.CREEPER_CONFETTI.utCreeperConfettiDamage * 2.0 : UTConfigTweaks.ENTITIES.CREEPER_CONFETTI.utCreeperConfettiDamage);
        Explosion explosion = new Explosion(creeper.func_130014_f_(), (Entity)creeper, creeper.field_70165_t, creeper.field_70163_u, creeper.field_70161_v, 3.0f * explosionStrength, false, false);
        explosion.func_77278_a();
    }
}

