/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.api.block;

import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.api.world.IWorldProvider;
import javax.annotation.Nonnull;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IFluidloggable {
    default public boolean isFluidloggable(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos) {
        return true;
    }

    default public boolean isFluidValid(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Fluid fluid) {
        return this.isFluidloggable(state, world, pos);
    }

    default public boolean isFluidloggable(@Nonnull IBlockState state, @Nonnull IBlockAccess access, @Nonnull BlockPos pos, @Nonnull FluidState fluidState) {
        World world = IWorldProvider.getWorld(access);
        if (fluidState.isEmpty()) {
            return this.isFluidloggable(state, world, pos);
        }
        if (!fluidState.isSource()) {
            return FluidloggedUtils.canFluidOccupy(state.func_185899_b(access, pos), access, pos, fluidState) && this.isFluidValid(state, world, pos, fluidState.getFluid());
        }
        return this.isFluidValid(state, world, pos, fluidState.getFluid());
    }

    default public boolean canFluidFlow(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState here, @Nonnull EnumFacing side) {
        return here.func_193401_d(world, pos, side) != BlockFaceShape.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean shouldFluidRender(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState here, @Nonnull FluidState fluidState) {
        return true;
    }

    @Nonnull
    default public EnumActionResult onFluidChange(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState here, @Nonnull FluidState newFluid, int blockFlags) {
        return newFluid.isEmpty() ? this.onFluidDrain(world, pos, here, blockFlags) : this.onFluidFill(world, pos, here, newFluid, blockFlags);
    }

    @Nonnull
    default public EnumActionResult onFluidFill(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState here, @Nonnull FluidState newFluid, int blockFlags) {
        return EnumActionResult.PASS;
    }

    @Nonnull
    default public EnumActionResult onFluidDrain(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState here, int blockFlags) {
        return EnumActionResult.PASS;
    }

    default public boolean overrideApplyDefaultsSetting() {
        return false;
    }
}

