/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.api.world;

import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.world.IChunkProvider;
import git.jbredwards.fluidlogged_api.api.world.IFluidStateProvider;
import git.jbredwards.fluidlogged_api.api.world.IWorldChunkProvider;
import git.jbredwards.fluidlogged_api.api.world.IWorldProvider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IBlockAccessWrapper
extends IBlockAccess,
IWorldChunkProvider {
    @Nonnull
    public IBlockAccess getWrapped();

    @Nonnull
    default public IBlockState func_180495_p(@Nonnull BlockPos pos) {
        return this.getWrapped().func_180495_p(pos);
    }

    @Nullable
    default public TileEntity func_175625_s(@Nonnull BlockPos pos) {
        return this.getWrapped().func_175625_s(pos);
    }

    default public int func_175627_a(@Nonnull BlockPos pos, @Nonnull EnumFacing direction) {
        return this.getWrapped().func_175627_a(pos, direction);
    }

    default public boolean func_175623_d(@Nonnull BlockPos pos) {
        return this.getWrapped().func_175623_d(pos);
    }

    default public boolean isSideSolid(@Nonnull BlockPos pos, @Nonnull EnumFacing side, boolean _default) {
        return this.getWrapped().isSideSolid(pos, side, _default);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    default public Biome func_180494_b(@Nonnull BlockPos pos) {
        return this.getWrapped().func_180494_b(pos);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    default public WorldType func_175624_G() {
        return this.getWrapped().func_175624_G();
    }

    @SideOnly(value=Side.CLIENT)
    default public int func_175626_b(@Nonnull BlockPos pos, int lightValue) {
        return this.getWrapped().func_175626_b(pos, lightValue);
    }

    @Override
    @Nullable
    default public Chunk getChunk(int chunkX, int chunkZ) {
        return this.getWrapped() instanceof IChunkProvider ? ((IChunkProvider)this.getWrapped()).getChunk(chunkX, chunkZ) : null;
    }

    @Override
    @Nonnull
    default public FluidState getFluidState(int x, int y, int z) {
        return this.getWrapped() instanceof IFluidStateProvider ? ((IFluidStateProvider)this.getWrapped()).getFluidState(x, y, z) : FluidState.EMPTY;
    }

    @Override
    @Nonnull
    default public World getWorld() {
        return IWorldProvider.getWorld(this.getWrapped());
    }

    public static class Impl
    implements IBlockAccessWrapper {
        @Nonnull
        public final IBlockAccess wrapped;

        public Impl(@Nonnull IBlockAccess wrappedIn) {
            this.wrapped = wrappedIn;
        }

        @Override
        @Nonnull
        public IBlockAccess getWrapped() {
            return this.wrapped;
        }
    }
}

