/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.modded.cofhcore;

import cofh.core.fluid.BlockFluidInteractive;
import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfig;
import git.jbredwards.fluidlogged_api.mod.common.fluid.handler.FluidCollisionHandler;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.FluidCache;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.IFluidBlock;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginCoFHCore
implements IASMPlugin {
    final boolean isInteractive;

    public PluginCoFHCore(boolean isInteractiveIn) {
        this.isInteractive = isInteractiveIn;
    }

    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (method.name.equals("handleFogDensityEvent")) {
            return 1;
        }
        return method.name.equals("handleFluidBlockOverlayEvent") ? 2 : 0;
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (this.checkMethod(insn, obfuscated ? "func_180495_p" : "getBlockState")) {
            if (index == 1) {
                instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraftforge/client/event/EntityViewRenderEvent", "getState", "()Lnet/minecraft/block/state/IBlockState;", false));
                instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
                this.removeFrom(instructions, insn, -3);
                return true;
            }
            if (index == 2) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("git/jbredwards/fluidlogged_api/api/util/FluidloggedUtils", "getFluidOrReal", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;"));
                instructions.remove(insn);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        if (classNode.name.endsWith("EventHandlerRender")) {
            return true;
        }
        if (this.isInteractive) {
            classNode.interfaces.add(this.getAccessorClass());
            this.addMethod(classNode, "interactWithBlock_Public", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V", null, null, generator -> {
                generator.visitVarInsn(25, 0);
                generator.visitVarInsn(25, 1);
                generator.visitVarInsn(25, 2);
                generator.visitMethodInsn(182, "cofh/core/fluid/BlockFluidInteractive", "interactWithBlock", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V", false);
            });
            this.overrideMethod(classNode, (MethodNode method) -> method.name.equals("checkForInteraction"), "checkForInteraction", this.withAccessorClass("(L%s;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V"), (GeneratorAdapter generator) -> {
                generator.visitVarInsn(25, 0);
                generator.visitVarInsn(25, 1);
                generator.visitVarInsn(25, 2);
            });
        } else {
            this.overrideMethod(classNode, (MethodNode method) -> method.name.equals("isEntityInsideMaterial"), "isInsideMaterial", "(Lnet/minecraftforge/fluids/BlockFluidBase;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;DLnet/minecraft/block/material/Material;Z)Ljava/lang/Boolean;", (GeneratorAdapter generator) -> {
                generator.visitVarInsn(25, 0);
                generator.visitVarInsn(25, 1);
                generator.visitVarInsn(25, 2);
                generator.visitVarInsn(25, 3);
                generator.visitVarInsn(25, 4);
                generator.visitVarInsn(24, 5);
                generator.visitVarInsn(25, 7);
                generator.visitVarInsn(21, 8);
            });
        }
        return false;
    }

    public static interface Accessor
    extends IFluidBlock {
        public void interactWithBlock_Public(@Nonnull World var1, @Nonnull BlockPos var2);
    }

    public static final class Hooks {
        @Nonnull
        public static final ThreadLocal<BlockPos> fluid_pos_access = new ThreadLocal();

        public static void checkForInteraction(@Nonnull Accessor fluid, @Nonnull World world, @Nonnull BlockPos pos) {
            FluidCache cache = new FluidCache((IBlockAccess)world, (Vec3i)pos, 2, 2);
            if (FluidloggedUtils.isCompatibleFluid(FluidloggedUtils.getFluidState(cache, pos).getFluid(), fluid.getFluid())) {
                if (FluidloggedAPIConfig.fixBadFluidMixing) {
                    HashSet<BlockPos> interactedCorners = new HashSet<BlockPos>();
                    for (EnumFacing side : EnumFacing.field_176754_o) {
                        EnumFacing cornerCCW;
                        BlockPos offsetCCW;
                        BlockPos offset = pos.func_177972_a(side);
                        if (!Hooks.hasInteraction((BlockFluidInteractive)fluid, cache, pos, offset, side)) continue;
                        Hooks.interactWithBlock(fluid, world, offset, pos);
                        EnumFacing cornerCW = side.func_176746_e();
                        BlockPos offsetCW = offset.func_177972_a(cornerCW);
                        if (Hooks.hasInteraction((BlockFluidInteractive)fluid, cache, offset, offsetCW, cornerCW) && !interactedCorners.contains(offsetCW)) {
                            Hooks.interactWithBlock(fluid, world, offsetCW, pos);
                            interactedCorners.add(offsetCW);
                        }
                        if (!Hooks.hasInteraction((BlockFluidInteractive)fluid, cache, offset, offsetCCW = offset.func_177972_a(cornerCCW = side.func_176735_f()), cornerCCW) || interactedCorners.contains(offsetCCW)) continue;
                        Hooks.interactWithBlock(fluid, world, offsetCCW, pos);
                        interactedCorners.add(offsetCCW);
                    }
                } else {
                    Hooks.interactWithBlock(fluid, world, (BlockPos)cache.mutablePos.func_181079_c(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1), pos);
                    Hooks.interactWithBlock(fluid, world, (BlockPos)cache.mutablePos.func_181079_c(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1), pos);
                    Hooks.interactWithBlock(fluid, world, (BlockPos)cache.mutablePos.func_181079_c(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()), pos);
                    Hooks.interactWithBlock(fluid, world, (BlockPos)cache.mutablePos.func_181079_c(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p()), pos);
                    Hooks.interactWithBlock(fluid, world, (BlockPos)cache.mutablePos.func_181079_c(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p() - 1), pos);
                    Hooks.interactWithBlock(fluid, world, (BlockPos)cache.mutablePos.func_181079_c(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p() - 1), pos);
                    Hooks.interactWithBlock(fluid, world, (BlockPos)cache.mutablePos.func_181079_c(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p() + 1), pos);
                    Hooks.interactWithBlock(fluid, world, (BlockPos)cache.mutablePos.func_181079_c(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p() + 1), pos);
                }
            }
        }

        public static boolean hasInteraction(@Nonnull BlockFluidInteractive fluid, @Nonnull FluidCache cache, @Nonnull BlockPos origin, @Nonnull BlockPos offset, @Nonnull EnumFacing side) {
            if (!FluidloggedUtils.canFluidFlow(cache, origin, cache.func_180495_p(origin), side)) {
                return false;
            }
            if (!cache.func_175623_d(offset) && fluid.hasInteraction(FluidloggedUtils.getFluidState(cache, offset).getState())) {
                return cache.func_180495_p(offset).func_177230_c().func_176200_f((IBlockAccess)cache, offset) && FluidloggedUtils.canFluidFlow(cache, offset, cache.func_180495_p(offset), side.func_176734_d());
            }
            return true;
        }

        public static void interactWithBlock(@Nonnull Accessor fluid, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockPos fluidPos) {
            fluid_pos_access.set(fluidPos);
            fluid.interactWithBlock_Public(world, pos);
            fluid_pos_access.set(null);
        }

        @Nullable
        public static Boolean isInsideMaterial(@Nonnull BlockFluidBase fluid, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entity, double yToTest, @Nonnull Material materialIn, boolean testingHead) {
            return fluid.getDensity() < 0 ? Boolean.FALSE : FluidCollisionHandler.isEntityInsideMaterial(worldIn, pos, state, entity, yToTest, testingHead ? state.func_185904_a() : materialIn, testingHead);
        }
    }
}

