/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.block;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfig;
import git.jbredwards.fluidlogged_api.mod.common.fluid.handler.FluidExtendedStateHandler;
import git.jbredwards.fluidlogged_api.mod.common.fluid.handler.FluidFlowHandler;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.FluidCache;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.impl.SpecializedFluidNeighborInfo;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginBlockLiquid
implements IASMPlugin {
    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (method.name.equals(obfuscated ? "func_149645_b" : "getRenderType")) {
            return 1;
        }
        return method.name.equals(obfuscated ? "func_180655_c" : "randomDisplayTick") ? 2 : 0;
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1 && insn.getOpcode() == 176) {
            instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("getRenderType", "(Lnet/minecraft/util/EnumBlockRenderType;)Lnet/minecraft/util/EnumBlockRenderType;"));
            return true;
        }
        if (index == 2 && this.checkMethod(insn, obfuscated ? "func_185896_q" : "isTopSolid")) {
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("spawnDripParticles", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Ljava/util/Random;)Z"));
            instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 4));
            instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 3));
            instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 2));
            instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
            this.removeFrom(instructions, insn, -4);
            return true;
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        classNode.interfaces.add("git/jbredwards/fluidlogged_api/api/fluid/IFlowCostFluid");
        classNode.interfaces.add("git/jbredwards/fluidlogged_api/api/fluid/IFluidloggableFluid");
        classNode.interfaces.add("net/minecraftforge/fluids/IFluidBlock");
        classNode.methods.removeIf(method -> method.name.equals("getFogColor"));
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals(obfuscated ? "func_180661_e" : "createBlockState"), "createLiquidBlockState", "(Lnet/minecraft/block/Block;)Lnet/minecraft/block/state/BlockStateContainer;", (GeneratorAdapter generator) -> generator.visitVarInsn(25, 0));
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals(obfuscated ? "func_176225_a" : "shouldSideBeRendered"), null, null, (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
            generator.visitInsn(2);
            generator.visitMethodInsn(184, PluginBlockLiquid.getFluidHookClass(), "shouldFluidSideBeRendered", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;I)Z", false);
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals(obfuscated ? "func_189543_a" : "getFlow"), "getFlow", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/util/math/Vec3d;", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
        });
        this.overrideMethod(classNode, (MethodNode method) -> this.checkMethod((MethodNode)method, obfuscated ? "func_190973_f" : "getBlockLiquidHeight", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)F"), "getBlockLiquidHeight", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)F", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals(obfuscated ? "func_176365_e" : "checkForMixing"), "checkForMixing", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
        });
        this.addMethod(classNode, "getExtendedState", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;", "getLiquidExtendedState", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/block/state/IBlockState;", generator -> {
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 1);
        });
        this.addMethod(classNode, "getStateAtViewpoint", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/Vec3d;)Lnet/minecraft/block/state/IBlockState;", null, null, generator -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
            generator.visitMethodInsn(184, "git/jbredwards/fluidlogged_api/mod/common/fluid/handler/FluidCollisionHandler", "getStateAtViewpoint", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/Vec3d;)Lnet/minecraft/block/state/IBlockState;", false);
        });
        this.addMethod(classNode, "isEntityInsideMaterial", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;DLnet/minecraft/block/material/Material;Z)Ljava/lang/Boolean;", null, null, generator -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
            generator.visitVarInsn(24, 5);
            generator.visitVarInsn(25, 7);
            generator.visitVarInsn(21, 8);
            generator.visitMethodInsn(184, "git/jbredwards/fluidlogged_api/mod/common/fluid/handler/FluidCollisionHandler", "isEntityInsideMaterial", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;DLnet/minecraft/block/material/Material;Z)Ljava/lang/Boolean;", false);
        });
        this.addMethod(classNode, "isAABBInsideMaterial", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/block/material/Material;)Ljava/lang/Boolean;", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraft/block/Block", obfuscated ? "field_149764_J" : "material", "Lnet/minecraft/block/material/Material;");
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
            generator.visitMethodInsn(184, "git/jbredwards/fluidlogged_api/mod/common/fluid/handler/FluidCollisionHandler", "isAABBInsideMaterial", "(Lnet/minecraft/block/material/Material;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/block/material/Material;)Ljava/lang/Boolean;", false);
        });
        this.addMethod(classNode, "isAABBInsideLiquid", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;)Ljava/lang/Boolean;", null, null, generator -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitMethodInsn(184, "git/jbredwards/fluidlogged_api/mod/common/fluid/handler/FluidCollisionHandler", "isAABBInsideLiquid", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;)Ljava/lang/Boolean;", false);
        });
        this.addMethod(classNode, "getFluid", "()Lnet/minecraftforge/fluids/Fluid;", "getLiquid", "(Lnet/minecraft/block/material/Material;)Lnet/minecraftforge/fluids/Fluid;", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraft/block/Block", obfuscated ? "field_149764_J" : "material", "Lnet/minecraft/block/material/Material;");
        });
        this.addMethod(classNode, "place", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraftforge/fluids/FluidStack;Z)I", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(21, 4);
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraft/block/Block", obfuscated ? "field_149764_J" : "material", "Lnet/minecraft/block/material/Material;");
            generator.visitMethodInsn(184, "net/minecraft/block/BlockLiquid", obfuscated ? "func_176361_a" : "getFlowingBlock", "(Lnet/minecraft/block/material/Material;)Lnet/minecraft/block/BlockDynamicLiquid;", false);
            generator.visitMethodInsn(182, "net/minecraft/block/Block", obfuscated ? "func_176223_P" : "getDefaultState", "()Lnet/minecraft/block/state/IBlockState;", false);
            generator.visitMethodInsn(184, PluginBlockLiquid.getFluidClassicClass(), "place", "(Lnet/minecraftforge/fluids/IFluidBlock;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraftforge/fluids/FluidStack;ZLnet/minecraft/block/state/IBlockState;)I", false);
        });
        this.addMethod(classNode, "drain", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Z)Lnet/minecraftforge/fluids/FluidStack;", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(21, 3);
            generator.visitInsn(1);
            generator.visitMethodInsn(184, PluginBlockLiquid.getFluidClassicClass(), "drain", "(Lnet/minecraftforge/fluids/IFluidBlock;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;ZLnet/minecraftforge/fluids/FluidStack;)Lnet/minecraftforge/fluids/FluidStack;", false);
        });
        this.addMethod(classNode, "canDrain", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitMethodInsn(184, PluginBlockLiquid.getFluidClassicClass(), "canDrain", "(Lnet/minecraftforge/fluids/IFluidBlock;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Z", false);
        });
        this.addMethod(classNode, "getFilledPercentage", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)F", null, null, generator -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitMethodInsn(184, "git/jbredwards/fluidlogged_api/api/util/FluidloggedUtils", "getFluidOrReal", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;", false);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitMethodInsn(184, this.getHookClass(), "getFilledPercentage", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)F", false);
        });
        this.addMethod(classNode, "getFlowCost", "(Lgit/jbredwards/fluidlogged_api/api/util/FluidState;Lnet/minecraft/world/World;)I", "getFlowCost", "(Lgit/jbredwards/fluidlogged_api/api/util/FluidState;Lnet/minecraft/world/World;)I", generator -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
        });
        this.addMethod(classNode, obfuscated ? "func_149698_L" : "requiresUpdates", "()Z", null, null, generator -> generator.visitInsn(3));
        return true;
    }

    @Nonnull
    static String getFluidHookClass() {
        return "git/jbredwards/fluidlogged_api/mod/asm/plugins/forge/PluginBlockFluidBase$Hooks";
    }

    @Nonnull
    static String getFluidClassicClass() {
        return "git/jbredwards/fluidlogged_api/mod/asm/plugins/forge/PluginBlockFluidClassic$Hooks";
    }

    public static final class Hooks {
        public static boolean checkForMixing(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
            if (state.func_185904_a() == Material.field_151587_i) {
                int level = FluidState.of(state).getLevel();
                if (level > 4) {
                    return false;
                }
                FluidCache cache = new FluidCache((IBlockAccess)world, (Vec3i)pos, 2, 2);
                if (!cache.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)cache, pos)) {
                    return false;
                }
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    if (FluidloggedAPIConfig.fixBadFluidMixing && !FluidloggedUtils.canFluidFlow(cache, pos, cache.func_180495_p(pos), side)) continue;
                    BlockPos offset = pos.func_177972_a(side);
                    if (side == EnumFacing.DOWN || cache.getFluidOrReal((Vec3i)offset).getMaterial() != Material.field_151586_h || FluidloggedAPIConfig.fixBadFluidMixing && !FluidloggedUtils.canFluidFlow(cache, offset, cache.func_180495_p(offset), side.func_176734_d())) continue;
                    world.func_175656_a(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((World)world, (BlockPos)pos, (BlockPos)pos, (IBlockState)(level == 0 ? Blocks.field_150343_Z : Blocks.field_150347_e).func_176223_P()));
                    ((BlockLiquid)state.func_177230_c()).func_180688_d(world, pos);
                    return true;
                }
            }
            return false;
        }

        @Nonnull
        public static BlockStateContainer createLiquidBlockState(@Nonnull Block block) {
            return new BlockStateContainer.Builder(block).add((IUnlistedProperty[])BlockFluidBase.FLUID_RENDER_PROPS.toArray((Object[])new IUnlistedProperty[0])).add(new IProperty[]{BlockLiquid.field_176367_b}).build();
        }

        @Nonnull
        public static IBlockState getLiquidExtendedState(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState oldState) {
            return FluidExtendedStateHandler.getExtendedState(oldState, new SpecializedFluidNeighborInfo.Vanilla(world, pos, FluidState.of(oldState), 1), FluidFlowHandler::getFlowAngle);
        }

        public static float getBlockLiquidHeight(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
            IBlockState up = worldIn.func_180495_p(pos.func_177984_a());
            boolean flag = FluidloggedUtils.isCompatibleFluid(FluidloggedUtils.getFluidState(worldIn, pos.func_177984_a(), up).getFluid(), FluidloggedUtils.getFluidFromState(state)) && FluidloggedUtils.canFluidFlow(worldIn, pos.func_177984_a(), up, EnumFacing.DOWN) && FluidloggedUtils.canFluidFlow(worldIn, pos, worldIn.func_180495_p(pos), EnumFacing.UP);
            return flag ? 1.0f : 1.0f - BlockLiquid.func_149801_b((int)((Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b)));
        }

        public static float getFilledPercentage(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
            return Math.min(Hooks.getBlockLiquidHeight(state, worldIn, pos) * 9.0f / 8.0f, 1.0f);
        }

        @Nonnull
        public static Vec3d getFlow(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState here) {
            return FluidFlowHandler.getFlowVec(new SpecializedFluidNeighborInfo.Vanilla(world, pos, FluidloggedUtils.getFluidState(world, pos, here), 1));
        }

        public static int getFlowCost(@Nonnull FluidState fluidState, @Nonnull World world) {
            return fluidState.getMaterial() == Material.field_151587_i && !world.field_73011_w.func_177500_n() ? 2 : 1;
        }

        @Nonnull
        public static Fluid getLiquid(@Nonnull Material material) {
            return material == Material.field_151586_h ? FluidRegistry.WATER : FluidRegistry.LAVA;
        }

        @Nonnull
        public static EnumBlockRenderType getRenderType(@Nonnull EnumBlockRenderType oldType) {
            return FluidloggedAPIConfig.fancyFluidRenderer ? EnumBlockRenderType.MODEL : oldType;
        }

        public static double getSlopeAngle(@Nonnull BlockLiquid block, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
            Vec3d vec = block.func_189543_a(world, pos, world.func_180495_p(pos));
            return vec.field_72450_a == 0.0 && vec.field_72449_c == 0.0 ? -1000.0 : MathHelper.func_181159_b((double)vec.field_72449_c, (double)vec.field_72450_a) - 1.5707963267948966;
        }

        public static boolean spawnDripParticles(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rand) {
            IBlockState under;
            Chunk chunk = world.func_175726_f(pos);
            IBlockState here = chunk.func_177435_g(pos);
            IBlockState below = chunk.func_177435_g(pos.func_177977_b());
            double spawnY = 0.0;
            if (here != state && !FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos, here, EnumFacing.DOWN) && !below.func_185904_a().func_76230_c() && FluidloggedUtils.getFluidState(chunk, pos.func_177977_b(), below).isEmpty()) {
                spawnY = 0.05;
            }
            if (!FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos.func_177977_b(), below, EnumFacing.UP) && FluidloggedUtils.getFluidState(chunk, pos.func_177977_b(), below).isEmpty() && !(under = chunk.func_177435_g(pos.func_177979_c(2))).func_185904_a().func_76230_c() && FluidloggedUtils.getFluidState(chunk, pos.func_177979_c(2), under).isEmpty()) {
                spawnY = 1.05;
            }
            if (spawnY != 0.0) {
                world.func_175688_a(state.func_185904_a() == Material.field_151586_h ? EnumParticleTypes.DRIP_WATER : EnumParticleTypes.DRIP_LAVA, (double)pos.func_177958_n() + rand.nextDouble(), (double)pos.func_177956_o() - spawnY, (double)pos.func_177952_p() + rand.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
            }
            return false;
        }
    }
}

