/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.world;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginTemplate
implements IASMPlugin {
    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (method.name.equals("<init>")) {
            return 1;
        }
        if (method.name.equals(obfuscated ? "func_186254_a" : "takeBlocksFromWorld")) {
            return 2;
        }
        if (this.checkMethod(method, obfuscated ? "func_189960_a" : "addBlocksToWorld", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/gen/structure/template/ITemplateProcessor;Lnet/minecraft/world/gen/structure/template/PlacementSettings;I)V")) {
            return 3;
        }
        if (method.name.equals(obfuscated ? "func_189552_a" : "writeToNBT")) {
            return 4;
        }
        if (method.name.equals(obfuscated ? "func_186256_b" : "read")) {
            return 5;
        }
        return 0;
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new TypeInsnNode(187, "java/util/ArrayList"));
            list.add((AbstractInsnNode)new InsnNode(89));
            list.add((AbstractInsnNode)new MethodInsnNode(183, "java/util/ArrayList", "<init>", "()V", false));
            list.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/world/gen/structure/template/Template", "fluidStates", "Ljava/util/List;"));
            instructions.insert(insn, list);
            return true;
        }
        if (index == 2) {
            if (this.checkMethod(insn.getPrevious(), obfuscated ? "func_177982_a" : "add", "(III)Lnet/minecraft/util/math/BlockPos;")) {
                instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(185, "java/util/List", "clear", "()V", true));
                instructions.insert(insn, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/gen/structure/template/Template", "fluidStates", "Ljava/util/List;"));
                instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                return false;
            }
            if (this.checkMethod(insn.getPrevious(), obfuscated ? "func_175625_s" : "getTileEntity")) {
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                list.add((AbstractInsnNode)new VarInsnNode(25, 13));
                list.add((AbstractInsnNode)new VarInsnNode(25, 14));
                list.add((AbstractInsnNode)new VarInsnNode(25, 5));
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/gen/structure/template/Template", "fluidStates", "Ljava/util/List;"));
                list.add((AbstractInsnNode)this.genMethodNode("addFluidState", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/Block;Ljava/util/List;)V"));
                instructions.insert(insn, list);
                return true;
            }
        } else if (index == 3) {
            if (this.checkMethod(insn, obfuscated ? "func_180501_a" : "setBlockState")) {
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/gen/structure/template/Template", "keepOldFluidStates", "Z"));
                instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("keepOldFlag", "(IZ)I"));
                return false;
            }
            if (insn.getOpcode() == 177) {
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 2));
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/gen/structure/template/Template", obfuscated ? "field_186272_c" : "size", "Lnet/minecraft/util/math/BlockPos;"));
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 4));
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(21, 5));
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/gen/structure/template/Template", "fluidStates", "Ljava/util/List;"));
                instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("addFluidsToWorld", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/gen/structure/template/PlacementSettings;ILjava/util/List;)V"));
                return true;
            }
        }
        if (index == 4) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/gen/structure/template/Template", "keepOldFluidStates", "Z"));
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/gen/structure/template/Template", "fluidStates", "Ljava/util/List;"));
            list.add((AbstractInsnNode)this.genMethodNode("writeTemplate", "(Lnet/minecraft/nbt/NBTTagCompound;ZLjava/util/List;)V"));
            return true;
        }
        if (index == 5) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/gen/structure/template/Template", "fluidStates", "Ljava/util/List;"));
            list.add((AbstractInsnNode)this.genMethodNode("readTemplate", "(Lnet/minecraft/gen/structure/template/Template;Lnet/minecraft/nbt/NBTTagCompound;Ljava/util/List;)V"));
            return true;
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        classNode.fields.add(new FieldNode(1, "keepOldFluidStates", "Z", null, null));
        classNode.fields.add(new FieldNode(17, "fluidStates", "Ljava/util/List;", "Ljava/util/List<Lorg/apache/commons/lang3/tuple/Pair<Lnet/minecraft/util/math/BlockPos;Lgit/jbredwards/fluidlogged_api/api/util/FluidState;>;>;", null));
        classNode.interfaces.add("git/jbredwards/fluidlogged_api/mod/asm/plugins/vanilla/world/PluginTemplate$Accessor");
        this.addMethod(classNode, "setKeepOldFluidStates", "(Z)V", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(21, 1);
            generator.visitFieldInsn(181, "net/minecraft/world/gen/structure/template/Template", "keepOldFluidStates", "Z");
        });
        return true;
    }

    public static interface Accessor {
        public void setKeepOldFluidStates(boolean var1);
    }

    public static final class Hooks {
        public static void addFluidState(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockPos transformedPos, @Nullable Block toIgnore, @Nonnull List<Pair<BlockPos, FluidState>> fluidStates) {
            FluidState fluidState = FluidState.get((IBlockAccess)world, pos);
            if (fluidState != FluidState.EMPTY && fluidState.getBlock() != toIgnore) {
                fluidStates.add((Pair<BlockPos, FluidState>)Pair.of((Object)transformedPos, (Object)((Object)fluidState)));
            }
        }

        public static void addFluidsToWorld(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockPos size, @Nonnull PlacementSettings settings, int flags, @Nonnull List<Pair<BlockPos, FluidState>> fluidStates) {
            if (!fluidStates.isEmpty() && size.func_177958_n() > 0 && size.func_177952_p() > 0) {
                for (Pair<BlockPos, FluidState> entry : fluidStates) {
                    BlockPos transformedPos = Template.func_186266_a((PlacementSettings)settings, (BlockPos)((BlockPos)entry.getKey())).func_177971_a((Vec3i)pos);
                    FluidloggedUtils.setFluidState(world, transformedPos, null, (FluidState)((Object)entry.getValue()), false, flags);
                }
            }
        }

        public static int keepOldFlag(int blockFlags, boolean keepOldFluidStates) {
            return blockFlags | (keepOldFluidStates ? 64 : 32);
        }

        public static void readTemplate(@Nonnull Template template, @Nonnull NBTTagCompound compound, @Nonnull List<Pair<BlockPos, FluidState>> fluidStates) {
            if (compound.func_150297_b("fluidStates", 9)) {
                fluidStates.clear();
                for (NBTBase nbtBase : compound.func_150295_c("fluidStates", 10)) {
                    NBTTagCompound nbt = (NBTTagCompound)nbtBase;
                    FluidState fluidState = nbt.func_150297_b("state", 8) ? FluidState.of(Block.func_149684_b((String)nbt.func_74779_i("state"))) : FluidState.of(NBTUtil.func_190008_d((NBTTagCompound)nbt));
                    if (fluidState == FluidState.EMPTY) continue;
                    fluidStates.add((Pair<BlockPos, FluidState>)Pair.of((Object)BlockPos.func_177969_a((long)nbt.func_74763_f("pos")), (Object)((Object)fluidState)));
                }
            }
            if (compound.func_150297_b("keepOldFluidStates", 1)) {
                ((Accessor)template).setKeepOldFluidStates(compound.func_74767_n("keepOldFluidStates"));
            }
        }

        public static void writeTemplate(@Nonnull NBTTagCompound compound, boolean keepOldFluidStates, @Nonnull List<Pair<BlockPos, FluidState>> fluidStates) {
            if (!fluidStates.isEmpty()) {
                NBTTagList list = new NBTTagList();
                for (Pair<BlockPos, FluidState> entry : fluidStates) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    NBTUtil.func_190009_a((NBTTagCompound)nbt, (IBlockState)((FluidState)((Object)entry.getValue())).getState()).func_74772_a("pos", ((BlockPos)entry.getKey()).func_177986_g());
                    list.func_74742_a((NBTBase)nbt);
                }
                compound.func_74782_a("fluidStates", (NBTBase)list);
            }
            compound.func_74757_a("keepOldFluidStates", keepOldFluidStates);
        }
    }
}

