/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.cableflux.pipes;

import com.zeitheron.hammercore.utils.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tk.zeitheron.cableflux.pipes.IPipe;
import tk.zeitheron.cableflux.pipes.PipeManager;

public class PipeGrid {
    public IPipe masterPipe;
    public World world;
    public List<BlockPos> pipes = new ArrayList<BlockPos>();

    public static boolean isPipeAt(World world, BlockPos pos, Class<? extends IPipe> type) {
        IPipe pipe = PipeManager.getPipe((IBlockAccess)world, pos);
        return pipe != null && type.isAssignableFrom(pipe.getClass());
    }

    public static PipeGrid defineGrid(World world, BlockPos pos) {
        PipeGrid grid = new PipeGrid();
        grid.world = world;
        if (PipeGrid.isPipeAt(world, pos, IPipe.class)) {
            grid.pipes.add(pos);
            grid.masterPipe = PipeManager.getPipe((IBlockAccess)world, pos);
            grid.masterPipe.setGrid(grid);
            if (grid.masterPipe == null) {
                return null;
            }
        } else {
            return null;
        }
        for (int i = 0; i < grid.pipes.size(); ++i) {
            grid.expandGrid(grid.pipes.get(i));
        }
        grid.orderGrid();
        return grid;
    }

    public void expandGrid(BlockPos from) {
        if (this.pipes.contains(from)) {
            IPipe cur = PipeManager.getPipe((IBlockAccess)this.world, from);
            for (EnumFacing face : EnumFacing.field_82609_l) {
                BlockPos op = from.func_177972_a(face);
                IPipe p = PipeManager.getPipe((IBlockAccess)this.world, op);
                if (p == null || !cur.canAddToSameGrid(p) || this.pipes.contains(op)) continue;
                this.pipes.add(op);
                p.setGrid(this);
            }
        }
    }

    public <T> Stream<? extends T> streamOfPipes(Class<T> type) {
        return this.pipes.stream().map(pos -> WorldUtil.cast((Object)PipeManager.getPipe((IBlockAccess)this.world, pos), (Class)type)).filter(p -> p != null);
    }

    public void orderGrid() {
        this.pipes.removeIf(pos -> PipeManager.getPipe((IBlockAccess)this.world, pos) == null);
        this.pipes.sort((a, b) -> (int)a.func_177951_i((Vec3i)b));
    }

    public IPipe getMasterPipe() {
        return this.masterPipe;
    }

    public void majorGridChange() {
        this.orderGrid();
        if (this.pipes.isEmpty()) {
            return;
        }
        this.masterPipe = PipeManager.getPipe((IBlockAccess)this.world, this.pipes.get(0));
        if (this.masterPipe == null) {
            return;
        }
        this.pipes.clear();
        this.pipes.add(this.masterPipe.getCoords());
        for (int i = 0; i < this.pipes.size(); ++i) {
            this.expandGrid(this.pipes.get(i));
        }
        this.orderGrid();
        this.getMasterPipe().balanceGrid();
    }

    public void addPipe(IPipe pipe) {
        if (pipe != null) {
            PipeGrid og = pipe.getGrid();
            if (og != null) {
                og.pipes.forEach(pos -> {
                    IPipe ip = PipeManager.getPipe((IBlockAccess)this.world, pos);
                    if (ip != null) {
                        ip.setGrid(null);
                    }
                });
                og.pipes.clear();
            }
            if (!this.pipes.contains(pipe.getCoords())) {
                this.pipes.add(pipe.getCoords());
                pipe.setGrid(this);
                this.majorGridChange();
            }
        }
    }
}

