/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.block.tile;

import ic2.api.energy.prefab.BasicSource;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.info.ILocatable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import weissmoon.electromagictools.ElectroMagicTools;
import weissmoon.electromagictools.api.ISolarRequirements;
import weissmoon.electromagictools.block.solar.SolarBlockBase;
import weissmoon.electromagictools.block.tile.SolarRegistry;

public class SolarTileEntity
extends TileEntity
implements ITickable,
IEnergySource,
ILocatable {
    private ISolarRequirements requirements = SolarRegistry.defaultRequirements;
    private BasicSource energySource = new BasicSource((ILocatable)this, 3000.0, 1);
    private boolean loaded;
    private BlockPos upPos;

    public void func_73660_a() {
        if (!this.loaded) {
            this.loadProperties();
            this.loaded = true;
            this.upPos = this.field_174879_c.func_177984_a();
        }
        if (!this.field_145850_b.field_72995_K && this.requirements.canGenerate(this.field_145850_b, this.upPos)) {
            this.energySource.setEnergyStored(this.requirements.getEnergyPerTick(this.field_145850_b, this.field_174879_c));
        }
    }

    private void loadProperties() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!(state.func_177230_c() instanceof SolarBlockBase)) {
            return;
        }
        int tileID = (Integer)state.func_177229_b((IProperty)SolarBlockBase.ELEMENT);
        if (((Boolean)state.func_177229_b((IProperty)SolarBlockBase.COMPRESSED)).booleanValue()) {
            tileID += 8;
        }
        if (!((SolarBlockBase)state.func_177230_c()).compressedPanel) {
            switch (tileID) {
                case 0: {
                    this.requirements = SolarRegistry.compressed1;
                    break;
                }
                case 1: {
                    this.requirements = SolarRegistry.aqua1;
                    break;
                }
                case 2: {
                    this.requirements = SolarRegistry.perditio1;
                    break;
                }
                case 3: {
                    this.requirements = SolarRegistry.ordo1;
                    break;
                }
                case 4: {
                    this.requirements = SolarRegistry.ignis1;
                    break;
                }
                case 5: {
                    this.requirements = SolarRegistry.aer1;
                    break;
                }
                case 6: {
                    this.requirements = SolarRegistry.terra1;
                    break;
                }
                case 8: {
                    this.requirements = SolarRegistry.compressed2;
                    break;
                }
                case 9: {
                    this.requirements = SolarRegistry.aqua2;
                    break;
                }
                case 10: {
                    this.requirements = SolarRegistry.perditio2;
                    break;
                }
                case 11: {
                    this.requirements = SolarRegistry.ordo2;
                    break;
                }
                case 12: {
                    this.requirements = SolarRegistry.ignis2;
                    break;
                }
                case 13: {
                    this.requirements = SolarRegistry.aer2;
                    break;
                }
                case 14: {
                    this.requirements = SolarRegistry.terra2;
                    break;
                }
                default: {
                    this.requirements = SolarRegistry.defaultRequirements;
                    ElectroMagicTools.logger.fatal("Broken Solar Panel at:");
                    ElectroMagicTools.logger.fatal((Object)this.field_174879_c);
                    break;
                }
            }
        } else {
            switch (tileID) {
                case 0: {
                    this.requirements = SolarRegistry.compressed3;
                    break;
                }
                case 1: {
                    this.requirements = SolarRegistry.aqua3;
                    break;
                }
                case 2: {
                    this.requirements = SolarRegistry.perditio3;
                    break;
                }
                case 3: {
                    this.requirements = SolarRegistry.ordo3;
                    break;
                }
                case 4: {
                    this.requirements = SolarRegistry.ignis3;
                    break;
                }
                case 5: {
                    this.requirements = SolarRegistry.aer3;
                    break;
                }
                case 6: {
                    this.requirements = SolarRegistry.terra3;
                    break;
                }
                default: {
                    this.requirements = SolarRegistry.defaultRequirements;
                    ElectroMagicTools.logger.fatal("Broken Solar Panel at:");
                    ElectroMagicTools.logger.fatal((Object)this.field_174879_c);
                }
            }
        }
    }

    public void onLoad() {
        super.onLoad();
        this.energySource.onLoad();
    }

    public void func_145843_s() {
        this.energySource.invalidate();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.energySource.onChunkUnload();
        super.onChunkUnload();
    }

    public double getOfferedEnergy() {
        return this.energySource.getOfferedEnergy();
    }

    public void drawEnergy(double amount) {
        this.energySource.drawEnergy(amount);
    }

    public int getSourceTier() {
        return 1;
    }

    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return side != EnumFacing.UP;
    }

    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    public World getWorldObj() {
        return this.field_145850_b;
    }
}

