/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.item.armour.boots;

import ic2.api.classic.item.IDamagelessElectricItem;
import ic2.api.classic.item.IElectricTool;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.items.IVisDiscountGear;
import thaumcraft.common.lib.events.PlayerEvents;
import weissmoon.core.item.armour.ItemArmourBase;
import weissmoon.electromagictools.ElectroMagicTools;
import weissmoon.electromagictools.item.armour.boots.ItemNanoBootsTraveller;
import weissmoon.electromagictools.util.ItemHelper;

public class ItemElectricBootsTraveller
extends ItemArmourBase
implements IDamagelessElectricItem,
IVisDiscountGear,
IMetalArmor,
ISpecialArmor,
IElectricTool {
    protected float jumpBonus;
    protected float speedBonus;
    protected int tier;
    protected int energyPerDamage;
    protected int visDiscount;
    protected int maxCharge;
    protected int transferLimit;
    private static final Map<ItemStack, Integer> counter = new HashMap<ItemStack, Integer>(10);

    public ItemElectricBootsTraveller() {
        this("itemElectricBoots", ItemArmor.ArmorMaterial.IRON, 10000, 100, 0.16f, 0.0225f, 1, 1000, 2);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected ItemElectricBootsTraveller(String name, ItemArmor.ArmorMaterial materialIn, int maxCharge, int transferLimit, float jumpBonus, float speedBonus, int tier, int energyPerDamage, int visDiscount) {
        super(name, materialIn, 0, EntityEquipmentSlot.FEET);
        this.setNoRepair();
        this.func_77656_e(0);
        this.func_77637_a((CreativeTabs)ElectroMagicTools.EMTtab);
        this.maxCharge = maxCharge;
        this.transferLimit = transferLimit;
        this.jumpBonus = jumpBonus;
        this.tier = tier;
        this.energyPerDamage = energyPerDamage;
        this.visDiscount = visDiscount;
        this.speedBonus = speedBonus;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "welectromagic:textures/models/armor/electricarmour.png";
    }

    public CreativeTabs[] getCreativeTabs() {
        return new CreativeTabs[]{ElectroMagicTools.EMTtab, CreativeTabs.field_78037_j};
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this, 1, 0);
            list.add((Object)stack);
            list.add((Object)ItemHelper.getChargedItem((IElectricItem)this, 1));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return ItemHelper.getElectricDurability(stack);
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxCharge(ItemStack stack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack stack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack stack) {
        return this.transferLimit;
    }

    public int getVisDiscount(ItemStack stack, EntityPlayer player) {
        return this.visDiscount;
    }

    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        double absorptionRatio = 0.15 * this.getAbsorptionRatio();
        double damageLimit = 25.0 * ElectricItem.manager.getCharge(armor) / (double)this.energyPerDamage;
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, (int)damageLimit);
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        if (ElectricItem.manager.getCharge(armor) >= (double)this.energyPerDamage) {
            return (int)Math.round(3.0 * this.getAbsorptionRatio());
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
        ElectricItem.manager.discharge(stack, (double)(damage * this.energyPerDamage), Integer.MAX_VALUE, true, false, false);
    }

    protected double getAbsorptionRatio() {
        return 0.5;
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && this.playerHasBoots(player = (EntityPlayer)event.getEntityLiving())) {
            boolean energyRecieved;
            ItemStack stack = player.func_184582_a(EntityEquipmentSlot.FEET);
            double discharge = ElectricItem.manager.discharge(stack, (double)(((ItemElectricBootsTraveller)stack.func_77973_b()).jumpBonus * 100.0f), this.getTier(stack), true, false, true);
            boolean bl = energyRecieved = discharge != 0.0;
            if (energyRecieved) {
                player.field_70181_x += (double)((ItemElectricBootsTraveller)stack.func_77973_b()).jumpBonus;
                player.field_70143_R -= (float)((double)((ItemElectricBootsTraveller)stack.func_77973_b()).jumpBonus * 8.5);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerFall(LivingFallEvent event) {
        ItemStack stack;
        double discharge;
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && this.playerHasBoots(player = (EntityPlayer)event.getEntityLiving()) && (discharge = ElectricItem.manager.discharge(stack = player.func_184582_a(EntityEquipmentSlot.FEET), (double)(event.getDistance() * 100.0f), this.getTier(stack), true, false, true)) != 0.0) {
            if (stack.func_77973_b() instanceof ItemNanoBootsTraveller) {
                event.setDamageMultiplier(0.0f);
            } else {
                event.setDamageMultiplier(0.2f);
            }
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (!world.field_72995_K && player.field_70173_aa % 200 == 0) {
            ElectricItem.manager.discharge(stack, 100.0, ((ItemElectricBootsTraveller)stack.func_77973_b()).getTier(stack), true, false, false);
        }
        if (!player.field_71075_bZ.field_75100_b) {
            double charge = world.field_72995_K ? (ElectricItem.manager.canUse(stack, 1.2) ? 1.2 : 0.0) : ElectricItem.manager.discharge(stack, 1.2, ((ItemElectricBootsTraveller)stack.func_77973_b()).getTier(stack), true, false, true);
            if (charge == 0.0) {
                if (PlayerEvents.prevStep.containsKey(player.func_145782_y())) {
                    player.field_70138_W = ((Float)PlayerEvents.prevStep.get(player.func_145782_y())).floatValue();
                    PlayerEvents.prevStep.remove(player.func_145782_y());
                }
                return;
            }
            if (!PlayerEvents.prevStep.containsKey(player.func_145782_y())) {
                PlayerEvents.prevStep.put(player.func_145782_y(), Float.valueOf(player.field_70138_W));
                player.field_70138_W = player.func_70093_af() ? 0.61f : 1.25f;
            }
            if (player.func_70051_ag()) {
                player.func_191958_b(0.0f, 0.0f, ((ItemElectricBootsTraveller)stack.func_77973_b()).getSpeedBonus(), 2.0f);
                ElectricItem.manager.discharge(stack, charge, ((ItemElectricBootsTraveller)stack.func_77973_b()).getTier(stack), true, false, false);
            } else if (player.field_191988_bg > 0.0f) {
                if (player.field_70122_E) {
                    float bonus = 0.05f;
                    if (player.func_70090_H()) {
                        bonus /= 4.0f;
                    }
                    player.func_191958_b(0.0f, 0.0f, bonus, 1.0f);
                } else {
                    if (player.func_70090_H()) {
                        player.func_191958_b(0.0f, 0.0f, 0.025f, 1.0f);
                    }
                    player.field_70747_aH = 0.05f;
                }
            }
        }
    }

    @SubscribeEvent
    public static void handleStepHeight(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (player.field_70170_p.field_72995_K && !(((ItemStack)player.field_71071_by.field_70460_b.get(0)).func_77973_b() instanceof ItemElectricBootsTraveller) && PlayerEvents.prevStep.containsKey(player.func_145782_y())) {
                player.field_70138_W = ((Float)PlayerEvents.prevStep.get(player.func_145782_y())).floatValue();
                PlayerEvents.prevStep.remove(player.func_145782_y());
            }
        }
    }

    public float getSpeedBonus() {
        return this.speedBonus;
    }

    public boolean playerHasBoots(EntityPlayer player) {
        ItemStack stack = player.func_184582_a(EntityEquipmentSlot.FEET);
        return stack.func_77973_b() instanceof ItemElectricBootsTraveller;
    }

    public EnumEnchantmentType getType(ItemStack itemStack) {
        return EnumEnchantmentType.ARMOR_FEET;
    }

    public boolean isSpecialSupported(ItemStack itemStack, Enchantment enchantment) {
        return false;
    }

    public boolean isExcluded(ItemStack itemStack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185296_A || enchantment == Enchantments.field_92091_k;
    }
}

