/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.item.armour.wings;

import ic2.api.item.ElectricItem;
import ic2.api.util.Keys;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weissmoon.core.utils.NBTHelper;
import weissmoon.electromagictools.client.WingsModelRenderer;
import weissmoon.electromagictools.item.ModItems;
import weissmoon.electromagictools.item.armour.wings.ItemNanoWings;

public class ItemQuantumWings
extends ItemNanoWings {
    public ItemQuantumWings() {
        super("itemQuantumWings", ItemArmor.ArmorMaterial.IRON);
        this.fallReduction = 0.2f;
        this.fallDamage = 0.0f;
        this.propulsion = 0.33f;
        this.tier = 3;
        this.visDiscount = 6;
        this.maxCharge = 10000000;
        this.transferLimit = 12000;
        this.energyPerDamage = 20000;
        this.energyPerJump = 6;
    }

    @Override
    protected double getAbsorptionRatio() {
        return 1.0;
    }

    @Override
    public void tickWings(@Nonnull EntityPlayer player, ItemStack wings, World world) {
        byte flap = NBTHelper.getByte((ItemStack)wings, (String)"flap");
        if (!Keys.instance.isJumpKeyDown(player) && flap > 0) {
            ElectricItem.manager.use(wings, (double)(this.energyPerJump * flap), (EntityLivingBase)player);
        }
        if (ElectricItem.manager.getCharge(wings) > 5.0) {
            super.tickWings(player, wings, world);
        }
    }

    @Override
    public IRarity getForgeRarity(ItemStack stack) {
        return EnumRarity.RARE;
    }

    @Override
    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "welectromagic:textures/models/armor/quantumarmour.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped original) {
        if (this.model == null) {
            ItemStack s = new ItemStack((Item)ModItems.materials, 1, 16);
            NBTHelper.setInteger((ItemStack)s, (String)"icon", (int)2);
            this.model = new WingsModelRenderer(s, 2);
        }
        return this.model;
    }
}

