/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.info.providers;

import java.util.List;
import java.util.Locale;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.tape.IItemTapeStorage;
import pl.asie.computronics.integration.info.ConfigValues;
import pl.asie.computronics.integration.info.providers.ComputronicsInfoProvider;
import pl.asie.computronics.tile.TapeDriveState;
import pl.asie.computronics.tile.TileTapeDrive;
import pl.asie.computronics.util.StringUtil;

public class InfoTapeDrive
extends ComputronicsInfoProvider {
    @Override
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!ConfigValues.Tape.getValue(config)) {
            return currenttip;
        }
        NBTTagCompound data = accessor.getNBTData();
        ItemStack is = new ItemStack(data.func_150295_c("Inventory", 10).func_150305_b(0));
        if (!is.func_190926_b() && is.func_77973_b() instanceof IItemTapeStorage) {
            String label = Computronics.itemTape.getLabel(is);
            if (label.length() > 0 && ConfigValues.TapeName.getValue(config)) {
                currenttip.add(StringUtil.localizeAndFormat("tooltip.computronics.tape.labeltapeinserted", label + TextFormatting.RESET));
            } else {
                currenttip.add(StringUtil.localize("tooltip.computronics.tape.tapeinserted"));
            }
            if (ConfigValues.DriveState.getValue(config)) {
                currenttip.add(StringUtil.localizeAndFormat("tooltip.computronics.tape.state", StringUtil.localize("tooltip.computronics.tape.state." + TapeDriveState.State.VALUES[data.func_74771_c("state")].name().toLowerCase(Locale.ENGLISH))));
            }
        } else {
            currenttip.add(StringUtil.localize("tooltip.computronics.tape.notapeinserted"));
        }
        return currenttip;
    }

    @Optional.Method(modid="waila")
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te instanceof TileTapeDrive) {
            TileTapeDrive drive = (TileTapeDrive)te;
            NBTTagCompound data = new NBTTagCompound();
            drive.func_189515_b(data);
            tag.func_74774_a("state", data.func_74771_c("state"));
            tag.func_74782_a("Inventory", (NBTBase)data.func_150295_c("Inventory", 10));
        }
        return tag;
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public String getUID() {
        return "tape_drive";
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tileEntity = world.func_175625_s(data.getPos());
        if (!(tileEntity instanceof TileTapeDrive)) {
            return;
        }
        TileTapeDrive tile = (TileTapeDrive)tileEntity;
        ItemStack is = tile.func_70301_a(0);
        if (!is.func_190926_b() && is.func_77973_b() instanceof IItemTapeStorage) {
            String label = Computronics.itemTape.getLabel(is);
            if (label.length() > 0) {
                probeInfo.text(StringUtil.localizeAndFormat("tooltip.computronics.waila.tape.labeltapeinserted", label + TextFormatting.RESET));
            } else {
                probeInfo.text(StringUtil.localize("tooltip.computronics.waila.tape.tapeinserted"));
            }
            probeInfo.text(StringUtil.localizeAndFormat("tooltip.computronics.waila.tape.state", StringUtil.localize("tooltip.computronics.waila.tape.state." + tile.getEnumState().name().toLowerCase(Locale.ENGLISH))));
        } else {
            probeInfo.text(StringUtil.localize("tooltip.computronics.waila.tape.notapeinserted"));
        }
    }
}

