/*
 * Decompiled with CFR 0.152.
 */
package meldexun.asmutil2;

import java.util.List;
import meldexun.asmutil2.ClassNodeTransformer;
import meldexun.asmutil2.ClassVisitorClassTransformer;
import meldexun.asmutil2.ITransformInfo;
import meldexun.asmutil2.Lazy;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public abstract class ClassNodeClassTransformer
extends ClassVisitorClassTransformer<ClassNode> {
    @Override
    protected ITransformInfo<ClassNode> getTransformInfo(String name) {
        final List<ClassNodeTransformer> transformers = this.getClassNodeTransformers(name);
        if (transformers == null || transformers.isEmpty()) {
            return null;
        }
        return new ITransformInfo<ClassNode>(){
            private int writeFlags;

            @Override
            public ClassNode visitor(Lazy<ClassWriter> classWriter) {
                return new ClassNode();
            }

            @Override
            public boolean transform(ClassNode classVisitor, Lazy<ClassWriter> classWriter) {
                boolean transformed = false;
                for (ClassNodeTransformer transformer : transformers) {
                    if (!transformer.transform(classVisitor)) continue;
                    this.writeFlags |= transformer.writeFlags();
                    transformed = true;
                }
                if (transformed) {
                    classVisitor.accept((ClassVisitor)classWriter.get());
                }
                return transformed;
            }

            @Override
            public int writeFlags() {
                return this.writeFlags;
            }

            @Override
            public int readFlags() {
                return 0;
            }
        };
    }

    protected abstract List<ClassNodeTransformer> getClassNodeTransformers(String var1);
}

