/*
 * Decompiled with CFR 0.152.
 */
package meldexun.randomutil;

import java.util.Random;

public class FastRandom
extends Random {
    private static final long serialVersionUID = 5655469615636521736L;
    private long seed;
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private static long seedUniquifier = 8682522807148012L;
    private double nextNextGaussian;
    private boolean haveNextNextGaussian;

    public FastRandom() {
        this(FastRandom.seedUniquifier() ^ System.nanoTime());
    }

    private static long seedUniquifier() {
        return seedUniquifier *= 1181783497276652981L;
    }

    public FastRandom(long seed) {
        super(seed);
    }

    private static long initialScramble(long seed) {
        return (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    @Override
    public void setSeed(long seed) {
        this.seed = FastRandom.initialScramble(seed);
        this.haveNextNextGaussian = false;
    }

    @Override
    protected int next(int bits) {
        this.seed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(this.seed >>> 48 - bits);
    }

    @Override
    public double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        this.nextNextGaussian = v2 * multiplier;
        this.haveNextNextGaussian = true;
        return v1 * multiplier;
    }
}

