/*
 * Decompiled with CFR 0.152.
 */
package meldexun.renderlib.opengl.debug;

import javax.annotation.Nullable;
import meldexun.renderlib.RenderLib;
import meldexun.renderlib.config.RenderLibConfig;
import meldexun.renderlib.opengl.debug.GLDebugMessageFilter;
import meldexun.renderlib.opengl.debug.Severity;
import meldexun.renderlib.opengl.debug.Source;
import meldexun.renderlib.opengl.debug.Type;
import meldexun.renderlib.util.GLException;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.opengl.KHRDebugCallback;

public enum OpenGLDebugMode {
    OpenGL43{

        @Override
        public void enable(GLDebugMessageFilter[] messageFilters) {
            GL11.glEnable((int)37600);
            GL11.glEnable((int)33346);
            GL43.glDebugMessageCallback((KHRDebugCallback)new KHRDebugCallback(this::log));
            GL43.glDebugMessageControl((int)4352, (int)4352, (int)4352, null, (boolean)false);
            for (GLDebugMessageFilter messageFilter : messageFilters) {
                int source = this.getSource(messageFilter.source);
                int type = this.getType(messageFilter.type);
                int severity = this.getSeverity(messageFilter.severity);
                GL43.glDebugMessageControl((int)source, (int)type, (int)severity, null, (boolean)messageFilter.enabled);
            }
        }

        @Override
        public void disable() {
            GL11.glDisable((int)37600);
            GL11.glDisable((int)33346);
            GL43.glDebugMessageCallback(null);
            GL43.glDebugMessageControl((int)4352, (int)4352, (int)4352, null, (boolean)false);
        }

        @Override
        protected Source getSource(int source) {
            switch (source) {
                case 33350: {
                    return Source.API;
                }
                case 33351: {
                    return Source.WINDOW_SYSTEM;
                }
                case 33352: {
                    return Source.SHADER_COMPILER;
                }
                case 33353: {
                    return Source.THIRD_PARTY;
                }
                case 33354: {
                    return Source.APPLICATION;
                }
                case 33355: {
                    return Source.OTHER;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected int getSource(Source source) {
            switch (source) {
                case ANY: {
                    return 4352;
                }
                case API: {
                    return 33350;
                }
                case WINDOW_SYSTEM: {
                    return 33351;
                }
                case SHADER_COMPILER: {
                    return 33352;
                }
                case THIRD_PARTY: {
                    return 33353;
                }
                case APPLICATION: {
                    return 33354;
                }
                case OTHER: {
                    return 33355;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected Type getType(int type) {
            switch (type) {
                case 33356: {
                    return Type.ERROR;
                }
                case 33357: {
                    return Type.DEPRECATED_BEHAVIOR;
                }
                case 33358: {
                    return Type.UNDEFINED_BEHAVIOR;
                }
                case 33359: {
                    return Type.PORTABILITY;
                }
                case 33360: {
                    return Type.PERFORMANCE;
                }
                case 33384: {
                    return Type.MARKER;
                }
                case 33385: {
                    return Type.PUSH_GROUP;
                }
                case 33386: {
                    return Type.POP_GROUP;
                }
                case 33361: {
                    return Type.OTHER;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected int getType(Type type) {
            switch (type) {
                case ANY: {
                    return 4352;
                }
                case ERROR: {
                    return 33356;
                }
                case DEPRECATED_BEHAVIOR: {
                    return 33357;
                }
                case UNDEFINED_BEHAVIOR: {
                    return 33358;
                }
                case PORTABILITY: {
                    return 33359;
                }
                case PERFORMANCE: {
                    return 33360;
                }
                case MARKER: {
                    return 33384;
                }
                case PUSH_GROUP: {
                    return 33385;
                }
                case POP_GROUP: {
                    return 33386;
                }
                case OTHER: {
                    return 33361;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected Severity getSeverity(int severity) {
            switch (severity) {
                case 37190: {
                    return Severity.HIGH;
                }
                case 37191: {
                    return Severity.MEDIUM;
                }
                case 37192: {
                    return Severity.LOW;
                }
                case 33387: {
                    return Severity.NOTIFICATION;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected int getSeverity(Severity severity) {
            switch (severity) {
                case ANY: {
                    return 4352;
                }
                case HIGH: {
                    return 37190;
                }
                case MEDIUM: {
                    return 37191;
                }
                case LOW: {
                    return 37192;
                }
                case NOTIFICATION: {
                    return 33387;
                }
            }
            throw new IllegalArgumentException();
        }
    }
    ,
    KHR{

        @Override
        public void enable(GLDebugMessageFilter[] messageFilters) {
            GL11.glEnable((int)37600);
            GL11.glEnable((int)33346);
            KHRDebug.glDebugMessageCallback((KHRDebugCallback)new KHRDebugCallback(this::log));
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)4352, null, (boolean)false);
            for (GLDebugMessageFilter messageFilter : messageFilters) {
                int source = this.getSource(messageFilter.source);
                int type = this.getType(messageFilter.type);
                int severity = this.getSeverity(messageFilter.severity);
                KHRDebug.glDebugMessageControl((int)source, (int)type, (int)severity, null, (boolean)messageFilter.enabled);
            }
        }

        @Override
        public void disable() {
            GL11.glDisable((int)37600);
            GL11.glDisable((int)33346);
            KHRDebug.glDebugMessageCallback(null);
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)4352, null, (boolean)false);
        }

        @Override
        protected Source getSource(int source) {
            switch (source) {
                case 33350: {
                    return Source.API;
                }
                case 33351: {
                    return Source.WINDOW_SYSTEM;
                }
                case 33352: {
                    return Source.SHADER_COMPILER;
                }
                case 33353: {
                    return Source.THIRD_PARTY;
                }
                case 33354: {
                    return Source.APPLICATION;
                }
                case 33355: {
                    return Source.OTHER;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected int getSource(Source source) {
            switch (source) {
                case ANY: {
                    return 4352;
                }
                case API: {
                    return 33350;
                }
                case WINDOW_SYSTEM: {
                    return 33351;
                }
                case SHADER_COMPILER: {
                    return 33352;
                }
                case THIRD_PARTY: {
                    return 33353;
                }
                case APPLICATION: {
                    return 33354;
                }
                case OTHER: {
                    return 33355;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected Type getType(int type) {
            switch (type) {
                case 33356: {
                    return Type.ERROR;
                }
                case 33357: {
                    return Type.DEPRECATED_BEHAVIOR;
                }
                case 33358: {
                    return Type.UNDEFINED_BEHAVIOR;
                }
                case 33359: {
                    return Type.PORTABILITY;
                }
                case 33360: {
                    return Type.PERFORMANCE;
                }
                case 33384: {
                    return Type.MARKER;
                }
                case 33385: {
                    return Type.PUSH_GROUP;
                }
                case 33386: {
                    return Type.POP_GROUP;
                }
                case 33361: {
                    return Type.OTHER;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected int getType(Type type) {
            switch (type) {
                case ANY: {
                    return 4352;
                }
                case ERROR: {
                    return 33356;
                }
                case DEPRECATED_BEHAVIOR: {
                    return 33357;
                }
                case UNDEFINED_BEHAVIOR: {
                    return 33358;
                }
                case PORTABILITY: {
                    return 33359;
                }
                case PERFORMANCE: {
                    return 33360;
                }
                case MARKER: {
                    return 33384;
                }
                case PUSH_GROUP: {
                    return 33385;
                }
                case POP_GROUP: {
                    return 33386;
                }
                case OTHER: {
                    return 33361;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected Severity getSeverity(int severity) {
            switch (severity) {
                case 37190: {
                    return Severity.HIGH;
                }
                case 37191: {
                    return Severity.MEDIUM;
                }
                case 37192: {
                    return Severity.LOW;
                }
                case 33387: {
                    return Severity.NOTIFICATION;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected int getSeverity(Severity severity) {
            switch (severity) {
                case ANY: {
                    return 4352;
                }
                case HIGH: {
                    return 37190;
                }
                case MEDIUM: {
                    return 37191;
                }
                case LOW: {
                    return 37192;
                }
                case NOTIFICATION: {
                    return 33387;
                }
            }
            throw new IllegalArgumentException();
        }
    };

    private static RenderLibConfig.OpenGLDebugConfiguration currentConfig;

    public static void setupDebugOutput(RenderLibConfig.OpenGLDebugConfiguration config) {
        OpenGLDebugMode debugMode = OpenGLDebugMode.getSupported();
        RenderLib.LOGGER.info("OpenGL Debug: supported={}, enabled={}", (Object)debugMode, (Object)config.enabled);
        if (debugMode == null) {
            return;
        }
        currentConfig = config;
        if (config.enabled) {
            debugMode.enable(config.getMessageFilters());
        } else {
            debugMode.disable();
        }
    }

    @Nullable
    public static OpenGLDebugMode getSupported() {
        ContextCapabilities capabilities = GLContext.getCapabilities();
        if (capabilities.OpenGL43) {
            return OpenGL43;
        }
        if (capabilities.GL_KHR_debug) {
            return KHR;
        }
        return null;
    }

    public abstract void enable(GLDebugMessageFilter[] var1);

    public abstract void disable();

    protected void log(int source, int type, int id, int severity, String message) {
        OpenGLDebugMode.log(this.getSource(source), this.getType(type), this.getSeverity(severity), id, message);
    }

    private static void log(Source source, Type type, Severity severity, int id, String message) {
        StringBuilder sb = new StringBuilder();
        sb.append("OpenGL");
        sb.append(' ');
        sb.append((Object)source);
        sb.append(' ');
        sb.append((Object)type);
        sb.append(' ');
        sb.append((Object)severity);
        sb.append(' ');
        sb.append(id);
        sb.append(' ');
        sb.append(message);
        if (type == Type.ERROR && OpenGLDebugMode.currentConfig.crashOnError) {
            throw new GLException(sb.toString());
        }
        if (OpenGLDebugMode.currentConfig.logStackTrace.shouldLogStackTrace(source, type, severity, id)) {
            sb.append('\n');
            for (StackTraceElement stackTraceElement : new Exception().getStackTrace()) {
                sb.append('\t');
                sb.append("at");
                sb.append(' ');
                sb.append(stackTraceElement.getClassName());
                sb.append('.');
                sb.append(stackTraceElement.getMethodName());
                sb.append('(');
                sb.append(stackTraceElement.getFileName());
                sb.append(':');
                sb.append(stackTraceElement.getLineNumber());
                sb.append(')');
                sb.append('\n');
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        RenderLib.LOGGER.log(type == Type.ERROR ? Level.ERROR : Level.INFO, (CharSequence)sb);
    }

    protected abstract Source getSource(int var1);

    protected abstract int getSource(Source var1);

    protected abstract Type getType(int var1);

    protected abstract int getType(Type var1);

    protected abstract Severity getSeverity(int var1);

    protected abstract int getSeverity(Severity var1);
}

