/*
 * Decompiled with CFR 0.152.
 */
package meldexun.renderlib.util;

import meldexun.renderlib.util.Vec3;

public class Vec4 {
    public final float x;
    public final float y;
    public final float z;
    public final float w;

    public Vec4(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vec4(Vec3 xyz, float w) {
        this(xyz.x, xyz.y, xyz.z, w);
    }

    public Vec4 add(Vec4 other) {
        return new Vec4(this.x + other.x, this.y + other.y, this.z + other.z, this.w + other.w);
    }

    public Vec4 mult(float f) {
        return new Vec4(this.x * f, this.y * f, this.z * f, this.w * f);
    }

    public Vec3 cross(Vec3 other) {
        return new Vec3(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    public Vec3 cross(Vec4 other) {
        return new Vec3(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    public float dot(Vec3 other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public float dot(Vec4 other) {
        return this.x * other.x + this.y * other.y + this.z * other.z + this.w * other.w;
    }

    public Vec4 normalize() {
        return this.mult(1.0f / this.length());
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSqr());
    }

    public float lengthSqr() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }
}

