/*
 * Decompiled with CFR 0.152.
 */
package elec332.craftingtableiv;

import com.google.common.base.Preconditions;
import elec332.core.ElecCore;
import elec332.core.api.mod.IElecCoreMod;
import elec332.core.api.network.ModNetworkHandler;
import elec332.core.inventory.window.IWindowHandler;
import elec332.core.inventory.window.WindowManager;
import elec332.core.network.IElecNetworkHandler;
import elec332.core.util.InventoryHelper;
import elec332.core.util.RegistryHelper;
import elec332.craftingtableiv.api.CraftingTableIVAPI;
import elec332.craftingtableiv.blocks.BlockCraftingTableIV;
import elec332.craftingtableiv.handler.CraftingHandler;
import elec332.craftingtableiv.handler.RecipeHandler;
import elec332.craftingtableiv.handler.vanilla.ForgeRecipeHandler;
import elec332.craftingtableiv.handler.vanilla.VanillaRecipeHandler;
import elec332.craftingtableiv.network.PacketCraft;
import elec332.craftingtableiv.network.PacketInitRecipes;
import elec332.craftingtableiv.proxies.CommonProxy;
import elec332.craftingtableiv.tileentity.TileEntityCraftingTableIV;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

@Mod(modid="craftingtableiv", name="CraftingTable-IV", dependencies="required-after:eleccore@[1.9.453,)", acceptedMinecraftVersions="[1.12,)", useMetadata=true, guiFactory="elec332.craftingtableiv.client.GuiFactory")
public class CraftingTableIV
implements IElecCoreMod {
    public static final String ModName = "CraftingTable-IV";
    public static final String ModID = "craftingtableiv";
    @SidedProxy(clientSide="elec332.craftingtableiv.proxies.ClientProxy", serverSide="elec332.craftingtableiv.proxies.CommonProxy")
    public static CommonProxy proxy;
    public static byte guiID;
    public static Block craftingTableIV;
    public static Item item;
    @Mod.Instance(value="craftingtableiv")
    public static CraftingTableIV instance;
    @ModNetworkHandler
    public static IElecNetworkHandler networkHandler;
    public static Logger logger;
    private Configuration config;
    private boolean listenMappings = false;
    private static final String[] CONFIG_CATEGORIES;
    public static int recursionDepth;
    public static boolean nuggetFilter;
    public static boolean enableDoor;
    public static boolean enableNoise;
    public static String[] disabledMods;
    public static String[] defaultDisabledMods;
    public static boolean debugTimings;
    public static float doorRange;
    public static boolean aggressiveLoopCheck;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        this.config = new Configuration(new File(event.getModConfigurationDirectory(), "/Elec's Mods/craftingtableiv.cfg"));
        craftingTableIV = ((Block)GameData.register_impl((IForgeRegistryEntry)new BlockCraftingTableIV(new ResourceLocation(ModID, ModID)))).func_149647_a(CreativeTabs.field_78031_c);
        item = (Item)GameData.register_impl((IForgeRegistryEntry)new ItemBlock(craftingTableIV).setRegistryName(craftingTableIV.getRegistryName()));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerTileEntity(TileEntityCraftingTableIV.class, (ResourceLocation)new ResourceLocation(ModID, "TileEntityCraftingTableIV"));
        WindowManager.INSTANCE.register((IWindowHandler)proxy, new ResourceLocation(ModID, "windowfactory"));
        proxy.registerRenders();
        networkHandler.registerClientPacket(PacketInitRecipes.class);
        networkHandler.registerServerPacket(PacketCraft.class);
        GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation(ModID, "ctivrecipe"), null, (ItemStack)new ItemStack(craftingTableIV), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150462_ai)}), Ingredient.func_193367_a((Item)Items.field_151122_aG)});
        this.config.load();
        recursionDepth = this.config.getInt("Recursion depth", "general", 5, 0, 10, "Set to 0 to disable recursion");
        enableDoor = this.config.getBoolean("EnableDoor", "client", true, "Set to false to disable the opening door on the CTIV");
        enableNoise = this.config.getBoolean("EnableNoise", "client", true, "Set to false to disable the door noise when opening and closing");
        disabledMods = this.config.getStringList("DisabledMods", "general", defaultDisabledMods, "Every item from the modID's specified here will not show up in the CraftingTable");
        debugTimings = this.config.getBoolean("DebugTimings", "debug", true, "When true, will print messages to the log regarding how long it took to load all recipes in de CTIV bench (when opened)");
        doorRange = this.config.getFloat("Doorrange", "client", doorRange, 0.0f, 100.0f, "The squared distance from craftingtable -> player at which the door will start opening.");
        aggressiveLoopCheck = this.config.getBoolean("AggressiveLoopCheck", "general", false, "Whether to aggressively search for recipe loops, will cause some recipes to search less deep than normal.");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.registerVanillaHandlers();
        RecipeHandler.getCompatHandler().closeRegistry();
        this.listenMappings = true;
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.reloadRecipes();
    }

    @Mod.EventHandler
    public void mappingChanged(FMLModIdMappingEvent evt) {
        if (this.listenMappings) {
            this.reloadRecipes();
        }
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        networkHandler.sendTo((IMessage)new PacketInitRecipes(), (EntityPlayerMP)event.player);
    }

    public void reloadRecipes() {
        long l = System.currentTimeMillis();
        CraftingHandler.rebuildList();
        logger.info("Initialised " + CraftingHandler.getAllRecipes().size() + " recipes in " + (System.currentTimeMillis() - l) + " ms");
    }

    private void registerVanillaHandlers() {
        CraftingTableIVAPI.getAPI().registerHandler(new ForgeRecipeHandler());
        CraftingTableIVAPI.getAPI().registerHandler(new VanillaRecipeHandler());
    }

    public static Stream<ConfigCategory> getConfigCategories() {
        return Arrays.stream(CONFIG_CATEGORIES).map(arg_0 -> ((Configuration)CraftingTableIV.instance.config).getCategory(arg_0));
    }

    public void sendCraftingMessage(CraftingHandler.IWorldAccessibleInventory inventory, NBTTagCompound recipe) {
        NBTTagCompound message = new NBTTagCompound();
        NBTTagCompound iwa = new NBTTagCompound();
        inventory.writeToNBT(iwa);
        iwa.func_74778_a("iwa_ident", inventory.getClass().getName());
        message.func_74782_a("iwa", (NBTBase)iwa);
        message.func_74782_a("recipe", (NBTBase)recipe);
        networkHandler.sendToServer((IMessage)new PacketCraft(message));
    }

    @SideOnly(value=Side.CLIENT)
    public String getFullItemName(ItemStack stack) {
        StringBuilder stringBuilder = new StringBuilder();
        List tooltip = InventoryHelper.getTooltip((ItemStack)stack, (EntityPlayer)ElecCore.proxy.getClientPlayer(), (boolean)Minecraft.func_71410_x().field_71474_y.field_82882_x);
        boolean appendH = false;
        for (Object o : tooltip) {
            stringBuilder.append(o);
            if (appendH) {
                stringBuilder.append("#");
                continue;
            }
            appendH = true;
        }
        return stringBuilder.toString().toLowerCase();
    }

    public static String getItemRegistryName(ItemStack stack) {
        ResourceLocation rl = RegistryHelper.getItemRegistry().getKey((IForgeRegistryEntry)stack.func_77973_b());
        if (rl == null) {
            logger.info("Found a recipe with an unregistered item! " + stack.func_77973_b().toString());
            return null;
        }
        return rl.toString();
    }

    public static String getItemIdentifier(@Nonnull ItemStack stack) {
        return ((ResourceLocation)Preconditions.checkNotNull((Object)RegistryHelper.getItemRegistry().getKey((IForgeRegistryEntry)stack.func_77973_b()))).func_110624_b();
    }

    static {
        guiID = (byte)33;
        CONFIG_CATEGORIES = new String[]{"general", "client", "debug"};
        recursionDepth = 5;
        nuggetFilter = false;
        enableDoor = true;
        enableNoise = true;
        defaultDisabledMods = new String[]{"ztones", "agricraft"};
        debugTimings = true;
        doorRange = 7.0f;
        aggressiveLoopCheck = false;
    }
}

