/*
 * Decompiled with CFR 0.152.
 */
package elec332.craftingtableiv.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;

public interface IRecipeHandler {
    public boolean canHandleRecipe(IRecipe var1);

    default public List<Ingredient> getIngredients(IRecipe recipe) {
        return recipe.func_192400_c();
    }

    @Nonnull
    default public ItemStack[][] getIngredientStacks(IRecipe recipe) {
        ItemStack[][] ret = (ItemStack[][])this.getIngredients(recipe).stream().map(ing -> this.getMatchingStacks(recipe, (Ingredient)ing)).toArray(x$0 -> new ItemStack[x$0][]);
        Lists.newArrayList((Object[])ret);
        return ret;
    }

    default public ItemStack[] getMatchingStacks(IRecipe recipe, Ingredient ingredient) {
        return (ItemStack[])Preconditions.checkNotNull((Object)ingredient.func_193365_a());
    }

    default public int getRecipeWidth(IRecipe recipe) {
        return -1;
    }

    default public boolean isValidIngredientFor(IRecipe recipe, Ingredient ingredient, ItemStack inventoryStack) {
        return ingredient.apply(inventoryStack);
    }

    @Nullable
    default public ItemStack getCraftingResult(IRecipe recipe, InventoryCrafting usedStacks) {
        return recipe.func_77572_b(usedStacks);
    }

    default public boolean logHandlerErrors() {
        return true;
    }
}

