/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.mc.renderer.chunk;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import meldexun.nothirium.api.renderer.chunk.IRenderChunkDispatcher;
import meldexun.nothirium.mc.Nothirium;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;

public class RenderChunkDispatcher
implements IRenderChunkDispatcher {
    private final ExecutorService executor = new ForkJoinPool(Math.max(Runtime.getRuntime().availableProcessors() - 2, 1), pool -> new ForkJoinWorkerThread(pool){}, (thread, exception) -> Minecraft.func_71410_x().func_71404_a(new CrashReport("Chunk Compile Thread crashed.", exception)), true);
    private final BlockingQueue<Runnable> taskQueue = new LinkedBlockingQueue<Runnable>();
    private final Thread thread = Thread.currentThread();

    @Override
    public void update() {
        Runnable task;
        while ((task = (Runnable)this.taskQueue.poll()) != null) {
            task.run();
        }
    }

    @Override
    public <T> CompletableFuture<T> runAsync(Supplier<T> supplier) {
        return RenderChunkDispatcher.crashMinecraftOnError(CompletableFuture.supplyAsync(supplier, this.executor));
    }

    @Override
    public <T> CompletableFuture<T> runOnRenderThread(Supplier<T> supplier) {
        if (Thread.currentThread() == this.thread) {
            return CompletableFuture.completedFuture(supplier.get());
        }
        return RenderChunkDispatcher.crashMinecraftOnError(CompletableFuture.supplyAsync(supplier, this.taskQueue::add));
    }

    @Override
    public CompletableFuture<Void> runAsync(Runnable runnable) {
        return RenderChunkDispatcher.crashMinecraftOnError(CompletableFuture.runAsync(runnable, this.executor));
    }

    @Override
    public CompletableFuture<Void> runOnRenderThread(Runnable runnable) {
        if (Thread.currentThread() == this.thread) {
            runnable.run();
            return CompletableFuture.completedFuture(null);
        }
        return RenderChunkDispatcher.crashMinecraftOnError(CompletableFuture.runAsync(runnable, this.taskQueue::add));
    }

    private static <T> CompletableFuture<T> crashMinecraftOnError(CompletableFuture<T> future) {
        return future.whenComplete((r, t) -> {
            if (t != null) {
                Minecraft.func_71410_x().func_71404_a(new CrashReport("Failed compiling chunk", t));
            }
        });
    }

    @Override
    public void dispose() {
        this.executor.shutdown();
        this.update();
        try {
            if (!this.executor.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                    Nothirium.LOGGER.error("ChunkRenderDispatcher did not terminate!");
                }
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.update();
    }
}

