/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.mc.vertex;

import meldexun.memoryutil.UnsafeUtil;
import meldexun.nothirium.mc.vertex.ExtendedBufferBuilder;
import meldexun.nothirium.mc.vertex.VertexConsumer;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import sun.misc.Unsafe;

public class PositionUploader {
    private static final VertexConsumer FLOAT = new VertexConsumer(){

        @Override
        public void pos(ExtendedBufferBuilder buffer, double x, double y, double z) {
            Unsafe unsafe = UnsafeUtil.UNSAFE;
            long address = buffer.getAddress() + (long)buffer.getOffset();
            unsafe.putFloat(address, (float)(x + buffer.xOffset()));
            unsafe.putFloat(address + 4L, (float)(y + buffer.yOffset()));
            unsafe.putFloat(address + 8L, (float)(z + buffer.zOffset()));
        }
    };
    private static final VertexConsumer INT = new VertexConsumer(){

        @Override
        public void pos(ExtendedBufferBuilder buffer, double x, double y, double z) {
            Unsafe unsafe = UnsafeUtil.UNSAFE;
            long address = buffer.getAddress() + (long)buffer.getOffset();
            unsafe.putInt(address, Float.floatToRawIntBits((float)(x + buffer.xOffset())));
            unsafe.putInt(address + 4L, Float.floatToRawIntBits((float)(y + buffer.yOffset())));
            unsafe.putInt(address + 8L, Float.floatToRawIntBits((float)(z + buffer.zOffset())));
        }
    };
    private static final VertexConsumer SHORT = new VertexConsumer(){

        @Override
        public void pos(ExtendedBufferBuilder buffer, double x, double y, double z) {
            Unsafe unsafe = UnsafeUtil.UNSAFE;
            long address = buffer.getAddress() + (long)buffer.getOffset();
            unsafe.putShort(address, (short)(x + buffer.xOffset()));
            unsafe.putShort(address + 2L, (short)(y + buffer.yOffset()));
            unsafe.putShort(address + 4L, (short)(z + buffer.zOffset()));
        }
    };
    private static final VertexConsumer BYTE = new VertexConsumer(){

        @Override
        public void pos(ExtendedBufferBuilder buffer, double x, double y, double z) {
            Unsafe unsafe = UnsafeUtil.UNSAFE;
            long address = buffer.getAddress() + (long)buffer.getOffset();
            unsafe.putByte(address, (byte)(x + buffer.xOffset()));
            unsafe.putByte(address + 1L, (byte)(y + buffer.yOffset()));
            unsafe.putByte(address + 2L, (byte)(z + buffer.zOffset()));
        }
    };

    public static VertexConsumer fromType(VertexFormatElement.EnumType type) {
        switch (type) {
            case FLOAT: {
                return FLOAT;
            }
            case UINT: 
            case INT: {
                return INT;
            }
            case USHORT: 
            case SHORT: {
                return SHORT;
            }
            case UBYTE: 
            case BYTE: {
                return BYTE;
            }
        }
        return null;
    }
}

