/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.util.collection;

import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import meldexun.nothirium.util.collection.IEnumMap;

public class Enum2IntMap<E extends Enum<E>>
implements IEnumMap<E, Integer> {
    private final E[] enums;
    private final int[] values;

    public Enum2IntMap(Class<E> enumClass) {
        this.enums = (Enum[])enumClass.getEnumConstants();
        this.values = new int[this.enums.length];
    }

    public Enum2IntMap(Class<E> enumClass, ToIntFunction<E> mapper) {
        this(enumClass);
        this.fill(mapper);
    }

    public Enum2IntMap(Class<E> enumClass, IntSupplier mapper) {
        this(enumClass);
        this.fill(mapper);
    }

    @Override
    @Deprecated
    public Integer get(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void set(E e, Integer t) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Stream<Integer> stream() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void forEach(BiConsumer<E, Integer> action) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void forEach(Consumer<Integer> action) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void fill(Function<E, Integer> mapper) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void fill(Supplier<Integer> mapper) {
        throw new UnsupportedOperationException();
    }

    public int getInt(E e) {
        return this.values[((Enum)e).ordinal()];
    }

    @Override
    public void set(E e, int t) {
        this.values[((Enum)e).ordinal()] = t;
    }

    public void or(E e, int t) {
        int n = ((Enum)e).ordinal();
        this.values[n] = this.values[n] | t;
    }

    public void and(E e, int t) {
        int n = ((Enum)e).ordinal();
        this.values[n] = this.values[n] & t;
    }

    public IntStream streamInt() {
        return Arrays.stream(this.values);
    }

    @Override
    public void forEach(ObjIntConsumer<E> action) {
        for (E e : this.enums) {
            action.accept(e, this.values[((Enum)e).ordinal()]);
        }
    }

    public void forEach(IntConsumer action) {
        for (int t : this.values) {
            action.accept(t);
        }
    }

    @Override
    public void fill(ToIntFunction<E> mapper) {
        for (E e : this.enums) {
            this.values[((Enum)e).ordinal()] = mapper.applyAsInt(e);
        }
    }

    public void fill(IntSupplier mapper) {
        for (E e : this.enums) {
            this.values[((Enum)e).ordinal()] = mapper.getAsInt();
        }
    }
}

