/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.advancedsolars.items;

import ic2.api.classic.item.ICropAnalyzer;
import ic2.api.classic.item.IEUReader;
import ic2.api.classic.item.IThermometer;
import ic2.api.item.ElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2.core.block.generator.tile.TileEntitySolarPanel;
import ic2.core.entity.IC2Potion;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.item.armor.base.ItemElectricArmorBase;
import ic2.core.item.misc.ItemTinCan;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.IColorEffectedTexture;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import ic2.core.util.obj.plugins.IBaublesPlugin;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.advancedsolars.util.AdvancedSolarLang;

public class ItemArmorAdvancedSolarHelmet
extends ItemElectricArmorBase
implements IMetalArmor,
IColorEffectedTexture,
IEUReader,
IThermometer,
ICropAnalyzer {
    private final int id;
    private final int production;
    private final int lowerProduction;
    private final int energyPerDamage;
    double damageAbsorpationRatio;
    String texture;

    public ItemArmorAdvancedSolarHelmet(String name, int id, int pro, int lowPro, int maxCharge, int maxTransfer, int tier, int energyPerDamage, double damageAbsorpationRatio, String texture) {
        super(-1, EntityEquipmentSlot.HEAD, maxCharge, maxTransfer, tier);
        this.id = id;
        this.production = pro;
        this.lowerProduction = lowPro;
        this.energyPerDamage = energyPerDamage;
        this.damageAbsorpationRatio = damageAbsorpationRatio;
        this.texture = texture;
        this.func_77655_b(name + "SolarHelmet");
        this.func_77656_e(0);
    }

    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        sortedTooltip.get(ToolTipType.Shift).add(AdvancedSolarLang.helmetProduction.getLocalizedFormatted(new Object[]{this.production}));
        sortedTooltip.get(ToolTipType.Shift).add(AdvancedSolarLang.helmetLowerPorduction.getLocalizedFormatted(new Object[]{this.lowerProduction}));
        sortedTooltip.get(ToolTipType.Shift).add(Ic2InfoLang.qArmorFeedsYou.getLocalized());
        sortedTooltip.get(ToolTipType.Shift).add(Ic2InfoLang.qArmorRemovePotions.getLocalized());
        sortedTooltip.get(ToolTipType.Shift).add(Ic2InfoLang.qArmorGivesAir.getLocalized());
        NBTTagCompound nbt = StackUtil.getNbtData((ItemStack)stack);
        if (nbt.func_74764_b("EUReaderUpgrade")) {
            sortedTooltip.get(ToolTipType.Shift).add(Ic2Lang.upgradeEU.getLocalized());
        }
        if (nbt.func_74764_b("CropUpgrade")) {
            sortedTooltip.get(ToolTipType.Shift).add(Ic2Lang.upgradeCrop.getLocalized());
        }
        if (nbt.func_74764_b("ThermometerUpgrade")) {
            sortedTooltip.get(ToolTipType.Shift).add(Ic2Lang.upgradeThermo.getLocalized());
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        boolean server;
        if (!IC2.platform.isRendering() && world.field_73011_w.func_191066_m() && world.func_175678_i(player.func_180425_c())) {
            if (TileEntitySolarPanel.isSunVisible((World)world, (BlockPos)player.func_180425_c())) {
                this.chargeInventory(player, this.production, this.tier, itemStack);
            } else {
                this.chargeInventory(player, this.lowerProduction, this.tier, itemStack);
            }
        }
        if (server = IC2.platform.isSimulating()) {
            PotionEffect wither;
            PotionEffect radiation;
            PotionEffect poison;
            ItemStack result;
            IItemTransporter trans;
            int air = player.func_70086_ai();
            if (air < 100 && this.canUseEnergy(itemStack, 1000.0)) {
                player.func_70050_g(air + 200);
                this.useEnergy(itemStack, 1000.0, (EntityLivingBase)player);
            }
            if (player.func_71024_bL().func_75121_c() && this.canUseEnergy(itemStack, 1000.0) && (trans = TransporterManager.manager.getTransporter((Object)player, true)) != null && !(result = trans.removeItem(ItemTinCan.foodCanFilter, EnumFacing.DOWN, 1, true)).func_190926_b()) {
                ItemTinCan can = (ItemTinCan)result.func_77973_b();
                can.onFoodEaten(result, world, player);
                this.useEnergy(itemStack, 1000.0, (EntityLivingBase)player);
            }
            if ((poison = player.func_70660_b(MobEffects.field_76436_u)) != null && this.canUseEnergy(itemStack, 10000 * poison.func_76458_c())) {
                this.useEnergy(itemStack, 10000 * poison.func_76458_c(), (EntityLivingBase)player);
                IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76436_u);
            }
            if ((radiation = player.func_70660_b((Potion)IC2Potion.radiation)) != null && this.canUseEnergy(itemStack, 20000 * radiation.func_76458_c())) {
                this.useEnergy(itemStack, 20000 * radiation.func_76458_c(), (EntityLivingBase)player);
                IC2.platform.removePotion((EntityLivingBase)player, (Potion)IC2Potion.radiation);
            }
            if ((wither = player.func_70660_b(MobEffects.field_82731_v)) != null && this.canUseEnergy(itemStack, 25000 * wither.func_76458_c())) {
                this.useEnergy(itemStack, 25000 * wither.func_76458_c(), (EntityLivingBase)player);
                IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_82731_v);
            }
        }
    }

    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    public String getTexture() {
        return "advancedsolars" + this.texture;
    }

    public ItemStack getRepairItem() {
        return ItemStack.field_190927_a;
    }

    public double getDamageAbsorptionRatio() {
        return this.damageAbsorpationRatio;
    }

    public int getEnergyPerDamage() {
        return this.energyPerDamage;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        return Ic2Icons.getTextures((String)"advancedsolars_items")[this.id];
    }

    public int chargeInventory(EntityPlayer player, int provided, int tier, ItemStack helmet) {
        List<NonNullList> invList = Arrays.asList(player.field_71071_by.field_70460_b, player.field_71071_by.field_184439_c, player.field_71071_by.field_70462_a);
        if (ElectricItem.manager.getCharge(helmet) != ElectricItem.manager.getMaxCharge(helmet)) {
            int charged = (int)ElectricItem.manager.charge(helmet, (double)provided, this.tier, false, false);
            provided -= charged;
        } else {
            int i;
            for (NonNullList inventory : invList) {
                int inventorySize = inventory.size();
                for (i = 0; i < inventorySize && provided > 0; ++i) {
                    ItemStack tStack = (ItemStack)inventory.get(i);
                    if (tStack.func_190926_b()) continue;
                    int charged = (int)ElectricItem.manager.charge(tStack, (double)provided, this.tier, false, false);
                    provided -= charged;
                }
            }
            IBaublesPlugin plugin = (IBaublesPlugin)IC2.loader.getPlugin("baubles", IBaublesPlugin.class);
            if (plugin != null) {
                IHasInventory inv = plugin.getBaublesInventory(player);
                for (i = 0; i < inv.getSlotCount() && provided > 0; ++i) {
                    provided = (int)((double)provided - ElectricItem.manager.charge(inv.getStackInSlot(i), (double)provided, tier, false, false));
                }
            }
        }
        return provided;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        switch (this.id) {
            case 11: {
                return EnumRarity.UNCOMMON;
            }
            case 12: {
                return EnumRarity.RARE;
            }
            case 13: {
                return EnumRarity.EPIC;
            }
        }
        return super.func_77613_e(stack);
    }

    public boolean isCropAnalyzer(ItemStack stack) {
        return StackUtil.getNbtData((ItemStack)stack).func_74767_n("CropUpgrade");
    }

    public boolean isThermometer(ItemStack stack) {
        return StackUtil.getNbtData((ItemStack)stack).func_74767_n("ThermometerUpgrade");
    }

    public boolean isEUReader(ItemStack stack) {
        return StackUtil.getNbtData((ItemStack)stack).func_74767_n("EUReaderUpgrade");
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !StackUtil.getNbtData((ItemStack)stack).func_74767_n("HideDurability");
    }

    public boolean func_82816_b_(ItemStack stack) {
        NBTTagCompound nbt = stack.func_179543_a("display");
        return nbt != null && nbt.func_74764_b("color");
    }

    public boolean hasOverlay(ItemStack stack) {
        return this.func_82816_b_(stack);
    }

    public void func_82813_b(ItemStack stack, int color) {
        stack.func_190925_c("display").func_74768_a("color", color);
    }

    public int func_82814_b(ItemStack stack) {
        return StackUtil.getNbtData((ItemStack)stack).func_74775_l("display").func_74762_e("color");
    }

    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == DamageSource.field_76379_h && this.field_77881_a == EntityEquipmentSlot.FEET) {
            int energyPerDamage = this.getEnergyPerDamage();
            int damageLimit = (int)(energyPerDamage > 0 ? ElectricItem.manager.discharge(armor, 2.147483647E9, Integer.MAX_VALUE, true, false, true) / (double)energyPerDamage : 0.0);
            return new ISpecialArmor.ArmorProperties(10, (double)IC2.config.getFloat("electricSuitAbsorbtionScale"), damageLimit);
        }
        return super.getProperties(player, armor, source, damage, slot);
    }
}

