/*
 * Decompiled with CFR 0.152.
 */
package magicbees.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forestry.core.models.BlankModel;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import magicbees.MagicBees;
import magicbees.bees.EnumBeeModifiers;
import magicbees.client.tesr.TileEntityEffectJarRenderer;
import magicbees.elec332.corerepack.util.MoonPhase;
import magicbees.init.BlockRegister;
import magicbees.init.ItemRegister;
import magicbees.item.types.EnumNuggetType;
import magicbees.item.types.EnumResourceType;
import magicbees.tile.TileEntityEffectJar;
import magicbees.util.Config;
import magicbees.util.MagicBeesResourceLocation;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiVideoSettings;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class ModelHandler {
    private static final ModelResourceLocation moonDialModelLocation = new ModelResourceLocation((ResourceLocation)new MagicBeesResourceLocation("moondialworkaround"), "inventory");
    public static final ModelResourceLocation effectJarModel = new ModelResourceLocation((ResourceLocation)new MagicBeesResourceLocation("effectJar"), "normal");
    public static final ModelResourceLocation effectJarModelOld = new ModelResourceLocation((ResourceLocation)new MagicBeesResourceLocation("effectJar_old"), "normal");
    private static final ResourceLocation someModel = new ResourceLocation("stick");
    private static ItemCameraTransforms itemTransform;
    private static boolean tesrRegistered;
    private static IBakedModel jarModel;
    private static ModelResourceLocation effectJarLink;
    private static final ItemCameraTransforms item;

    @SubscribeEvent
    public void loadModels(ModelRegistryEvent event) {
        OBJLoader.INSTANCE.addDomain("magicbees");
        ModelLoader.registerItemVariants((Item)ItemRegister.moonDial, (ResourceLocation[])new ResourceLocation[]{someModel});
        ModelHandler.setItemModelLocation(ItemRegister.moonDial, stack -> moonDialModelLocation, new ModelResourceLocation[0]);
        ModelHandler.setForestryModel(ItemRegister.combItem, "bee_combs");
        ModelHandler.setForestryModel(ItemRegister.dropItem, "honey_drop");
        ModelHandler.setForestryModel(ItemRegister.pollenItem, "pollen");
        ModelHandler.setForestryModel(ItemRegister.propolisItem, "propolis");
        ModelHandler.setForestryModel(ItemRegister.waxItem, "beeswax");
        ModelHandler.setItemModels(ItemRegister.resourceItem, EnumResourceType.values().length, value -> {
            EnumResourceType resourceType = EnumResourceType.values()[value];
            return ModelHandler.createMRL(resourceType.toString().toLowerCase());
        });
        ModelHandler.setItemModels(ItemRegister.orePartItem, EnumNuggetType.values().length, value -> {
            EnumNuggetType resourceType = EnumNuggetType.values()[value];
            return ModelHandler.createMRL("part" + resourceType.toString().toLowerCase());
        });
        ModelResourceLocation on = ModelHandler.createMRL("mysteriousmagnet_on");
        ModelResourceLocation off = ModelHandler.createMRL("mysteriousmagnet_off");
        ModelHandler.setItemModelLocation(ItemRegister.mysteriousMagnet, stack -> ItemRegister.mysteriousMagnet.isMagnetActive((ItemStack)stack) ? on : off, on, off);
        for (EnumBeeModifiers modifier : EnumBeeModifiers.values()) {
            Item item = ItemRegister.getBeeFrames().get((Object)modifier);
            ModelHandler.setItemModelLocation(item, ModelHandler.createMRL("frame_" + modifier.getName().toLowerCase()));
        }
        ModelHandler.setItemModelLocation(ItemRegister.manasteelgrafter, ModelHandler.createMRL("manasteel_grafter"));
        ModelHandler.setItemModelLocation(ItemRegister.manasteelScoop, ModelHandler.createMRL("manasteel_scoop"));
        ModelHandler.setItemModelLocation(ItemRegister.thaumiumgrafter, ModelHandler.createMRL("thaumium_grafter"));
        ModelHandler.setItemModelLocation(ItemRegister.thaumiumScoop, ModelHandler.createMRL("thaumium_scoop"));
        ModelHandler.setItemModelLocation((Item)ItemRegister.jellyBaby, ModelHandler.createMRL("jelly_babies"));
        ModelHandler.linkItemTextureToBlock(BlockRegister.hiveBlock);
        ModelHandler.linkItemTextureToBlock(BlockRegister.enchantedEarth);
        ModelHandler.setItemModelLocation(Item.func_150898_a((Block)BlockRegister.effectJar), effectJarModel);
        this.registerTESRs();
    }

    private void registerTESRs() {
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent
            public void onGuiButtonClicked(GuiScreenEvent.ActionPerformedEvent.Post event) {
                if (!(event.getGui() instanceof GuiVideoSettings)) {
                    return;
                }
                if (Minecraft.func_71410_x().field_71474_y.field_74347_j && !tesrRegistered) {
                    ModelHandler.this.registerFancyTESRs();
                }
            }
        });
        this.registerFancyTESRs();
    }

    private void registerFancyTESRs() {
        if (Minecraft.func_71410_x().field_71474_y.field_74347_j && !tesrRegistered) {
            if (Config.fancyJarRenderer) {
                ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEffectJar.class, (TileEntitySpecialRenderer)new TileEntityEffectJarRenderer());
            }
            tesrRegistered = true;
        }
    }

    @SubscribeEvent
    public void loadSpecialModels(ModelBakeEvent event) {
        itemTransform = item;
        event.getModelRegistry().func_82595_a((Object)moonDialModelLocation, (Object)new BlankModel(){

            @Nonnull
            protected ItemOverrideList createOverrides() {
                return new ItemOverrideList(Collections.emptyList()){
                    IBakedModel[] models;
                    {
                        this.models = new IBakedModel[MoonPhase.values().length];
                    }

                    @Nonnull
                    public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                        MoonPhase phase;
                        int i;
                        Object model;
                        if (world == null) {
                            world = Minecraft.func_71410_x().field_71441_e;
                        }
                        if ((model = this.models[i = (phase = MoonPhase.getMoonPhase(world)).ordinal()]) == null) {
                            this.models[i] = model = new BlankModel(){
                                List<BakedQuad> quad;
                                {
                                    this.quad = ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)((TextureAtlasSprite)ModelLoader.defaultTextureGetter().apply(new MagicBeesResourceLocation("items/moondial." + i))), (VertexFormat)DefaultVertexFormats.field_176599_b, Optional.empty());
                                }

                                @Nonnull
                                public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
                                    return side == null ? this.quad : super.func_188616_a(state, side, rand);
                                }

                                @Nonnull
                                public ItemCameraTransforms func_177552_f() {
                                    return itemTransform;
                                }
                            };
                        }
                        return model;
                    }
                };
            }
        });
        if (Config.oldJarModel) {
            IBakedModel originalModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)effectJarModel);
            if (originalModel != null) {
                Object replacement;
                try {
                    IModel model = OBJLoader.INSTANCE.loadModel((ResourceLocation)new MagicBeesResourceLocation("models/block/obj/effectjar.obj"));
                    final IBakedModel oldModelBase = model.bake((IModelState)ModelRotation.X0_Y0, DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
                    final IBakedModel lidModel = ModelHandler.getOBJParts(model, "jarLid");
                    final IBakedModel baseModel = ModelHandler.getOBJParts(model, "jarBase");
                    BlankModel oldJarModel = new BlankModel(){

                        @Nonnull
                        protected ItemOverrideList createOverrides() {
                            return new ItemOverrideList(Collections.emptyList()){

                                @Nonnull
                                public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                                    return oldModelBase;
                                }
                            };
                        }

                        @Nonnull
                        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
                            BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
                            if (layer == null) {
                                return oldModelBase.func_188616_a(state, side, rand);
                            }
                            if (layer == BlockRenderLayer.TRANSLUCENT) {
                                return baseModel.func_188616_a(state, side, rand);
                            }
                            if (layer == BlockRenderLayer.SOLID) {
                                return lidModel.func_188616_a(state, side, rand);
                            }
                            return Collections.emptyList();
                        }
                    };
                    replacement = new BlankModel((IBakedModel)oldJarModel, originalModel){
                        final /* synthetic */ IBakedModel val$oldJarModel;
                        final /* synthetic */ IBakedModel val$originalModel;
                        {
                            this.val$oldJarModel = iBakedModel;
                            this.val$originalModel = iBakedModel2;
                        }

                        @Nonnull
                        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
                            return (Config.oldJarModel ? this.val$oldJarModel : this.val$originalModel).func_188616_a(state, side, rand);
                        }
                    };
                }
                catch (Exception e) {
                    replacement = originalModel;
                    MagicBees.logger.error("Error loading models for Bee Collector's Jar, using backup...", (Throwable)e);
                }
                event.getModelRegistry().func_82595_a((Object)effectJarModel, replacement);
            } else {
                throw new RuntimeException("Error creating model for Bee Collector's Jar");
            }
        }
    }

    @SubscribeEvent
    public void registerTextures(TextureStitchEvent event) {
        TextureMap map = event.getMap();
        for (int i = 0; i < MoonPhase.values().length; ++i) {
            map.func_174942_a((ResourceLocation)new MagicBeesResourceLocation("items/moondial." + i));
        }
        map.func_174942_a((ResourceLocation)new MagicBeesResourceLocation("model/jartexture"));
    }

    private static void linkItemTextureToBlock(Block block) {
        Item item = Item.func_150898_a((Block)block);
        if (item == null || item == Items.field_190931_a) {
            return;
        }
        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{someModel});
        DefaultStateMapper stateMapper = new DefaultStateMapper();
        Map modelLocsIbs = stateMapper.func_178130_a(block);
        HashMap modelLocs = Maps.newHashMap();
        for (IBlockState state : modelLocsIbs.keySet()) {
            modelLocs.put(state.func_177230_c().func_176201_c(state), modelLocsIbs.get(state));
        }
        ModelHandler.setItemModelLocation(item, stack -> {
            ModelResourceLocation loc = (ModelResourceLocation)modelLocs.get(stack.func_77952_i());
            if (loc == null) {
                return (ModelResourceLocation)modelLocs.get(0);
            }
            return loc;
        }, new ModelResourceLocation[0]);
    }

    private static IBakedModel getOBJParts(IModel model, String ... parts) {
        ArrayList partsList = Lists.newArrayList((Object[])parts);
        return ModelHandler.getOBJParts(model, partsList::contains);
    }

    private static IBakedModel getOBJParts(ModelLoader modelLoader, ModelResourceLocation location, String ... parts) {
        ArrayList partsList = Lists.newArrayList((Object[])parts);
        return ModelHandler.getOBJParts(modelLoader, location, partsList::contains);
    }

    private static IBakedModel getOBJParts(ModelLoader modelLoader, ModelResourceLocation location, Predicate<String> filter) {
        try {
            Field f = ModelLoader.class.getDeclaredField("stateModels");
            f.setAccessible(true);
            Map stateModels = (Map)f.get(modelLoader);
            IModel model = (IModel)stateModels.get(location);
            return ModelHandler.getOBJParts(model, filter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static IBakedModel getOBJParts(IModel model, Predicate<String> filter) {
        try {
            if (!(model instanceof OBJModel)) {
                Class<?> clazz = Class.forName("net.minecraftforge.client.model.ModelLoader$WeightedRandomModel");
                Field f2 = clazz.getDeclaredField("models");
                f2.setAccessible(true);
                model = (IModel)((List)f2.get(model)).get(0);
                if (!(model instanceof OBJModel)) {
                    throw new RuntimeException("No OBJ model found for " + model.toString());
                }
            }
            OBJModel objModel = (OBJModel)model;
            OBJModel.MaterialLibrary lib = objModel.getMatLib().makeLibWithReplacements(ImmutableMap.of());
            Field f3 = OBJModel.MaterialLibrary.class.getDeclaredField("groups");
            f3.setAccessible(true);
            HashMap map = Maps.newHashMap((Map)lib.getGroups());
            lib.getGroups().forEach((s, group) -> {
                if (!filter.test((String)s)) {
                    map.remove(s);
                }
            });
            f3.set(lib, map);
            OBJModel newModel = new OBJModel(lib, (ResourceLocation)new MagicBeesResourceLocation("neen"));
            return newModel.bake((IModelState)ModelRotation.X0_Y0, DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ModelResourceLocation createMRL(String name) {
        return new ModelResourceLocation((ResourceLocation)new MagicBeesResourceLocation(name), "inventory");
    }

    private static void setForestryModel(Item item, String resource) {
        ModelHandler.setItemModelLocation(item, new ModelResourceLocation(new ResourceLocation("forestry", resource), "inventory"));
    }

    private static void setItemModels(Item item, int types, IntFunction<ModelResourceLocation> loc) {
        ModelResourceLocation[] locs = new ModelResourceLocation[types];
        for (int i = 0; i < types; ++i) {
            locs[i] = loc.apply(i);
        }
        ModelHandler.setItemModelLocation(item, stack -> {
            int d = stack.func_77952_i();
            if (d > types || d < 0) {
                d = 0;
            }
            return locs[d];
        }, locs);
    }

    private static void setItemModelLocation(Item item, ModelResourceLocation loc) {
        ModelHandler.setItemModelLocation(item, stack -> loc, loc);
    }

    private static void setItemModelLocation(Item item, final Function<ItemStack, ModelResourceLocation> func, ModelResourceLocation ... vars) {
        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])vars);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){

            @Nonnull
            public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
                return (ModelResourceLocation)func.apply(stack);
            }
        });
    }

    private static Vector3f applyTranslationScale(Vector3f vec) {
        vec.scale(0.0625f);
        return vec;
    }

    static {
        tesrRegistered = false;
        effectJarLink = new ModelResourceLocation((ResourceLocation)new MagicBeesResourceLocation("runtimeLoadedEffJarModelLink"), "normal");
        item = new ItemCameraTransforms(new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), ModelHandler.applyTranslationScale(new Vector3f(0.0f, 3.0f, 1.0f)), new Vector3f(0.55f, 0.55f, 0.55f)), new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), ModelHandler.applyTranslationScale(new Vector3f(0.0f, 3.0f, 1.0f)), new Vector3f(0.55f, 0.55f, 0.55f)), new ItemTransformVec3f(new Vector3f(0.0f, -90.0f, 25.0f), ModelHandler.applyTranslationScale(new Vector3f(1.13f, 3.2f, 1.13f)), new Vector3f(0.68f, 0.68f, 0.68f)), new ItemTransformVec3f(new Vector3f(0.0f, -90.0f, 25.0f), ModelHandler.applyTranslationScale(new Vector3f(1.13f, 3.2f, 1.13f)), new Vector3f(0.68f, 0.68f, 0.68f)), new ItemTransformVec3f(new Vector3f(0.0f, 180.0f, 0.0f), ModelHandler.applyTranslationScale(new Vector3f(0.0f, 13.0f, 7.0f)), new Vector3f(1.0f, 1.0f, 1.0f)), ItemTransformVec3f.field_178366_a, new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), ModelHandler.applyTranslationScale(new Vector3f(0.0f, 2.0f, 0.0f)), new Vector3f(0.5f, 0.5f, 0.5f)), ItemTransformVec3f.field_178366_a);
    }
}

