/*
 * Decompiled with CFR 0.152.
 */
package magicbees.init;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.storage.BackpackDefinition;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import magicbees.MagicBees;
import magicbees.bees.EnumBeeModifiers;
import magicbees.elec332.corerepack.item.ItemEnumBased;
import magicbees.integration.thaumcraft.ItemThaumiumGrafter;
import magicbees.integration.thaumcraft.ItemThaumiumScoop;
import magicbees.item.ItemMagicBeesFrame;
import magicbees.item.ItemManaSteelGrafter;
import magicbees.item.ItemManaSteelScoop;
import magicbees.item.ItemMoonDial;
import magicbees.item.ItemMysteriousMagnet;
import magicbees.item.types.EnumCombType;
import magicbees.item.types.EnumDropType;
import magicbees.item.types.EnumNuggetType;
import magicbees.item.types.EnumPollenType;
import magicbees.item.types.EnumPropolisType;
import magicbees.item.types.EnumResourceType;
import magicbees.item.types.EnumWaxType;
import magicbees.util.MagicBeesResourceLocation;
import magicbees.util.Utils;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ItemRegister {
    public static ItemEnumBased<EnumCombType> combItem;
    public static ItemEnumBased<EnumDropType> dropItem;
    public static ItemEnumBased<EnumPollenType> pollenItem;
    public static ItemEnumBased<EnumPropolisType> propolisItem;
    public static ItemEnumBased<EnumWaxType> waxItem;
    public static ItemEnumBased<EnumResourceType> resourceItem;
    public static ItemEnumBased<EnumNuggetType> orePartItem;
    public static ItemMagicBeesFrame magicFrame;
    public static ItemMagicBeesFrame resilientFrame;
    public static ItemMagicBeesFrame gentleFrame;
    public static ItemMagicBeesFrame metabolicFrame;
    public static ItemMagicBeesFrame necroticFrame;
    public static ItemMagicBeesFrame temporalFrame;
    public static ItemMagicBeesFrame oblivionFrame;
    public static Item moonDial;
    public static Item ironNugget;
    public static Item manasteelgrafter;
    public static Item manasteelScoop;
    public static Item thaumiumgrafter;
    public static Item thaumiumScoop;
    public static ItemMysteriousMagnet mysteriousMagnet;
    public static ItemFood jellyBaby;
    public static Item thaumaturgeBackpackT1;
    public static Item thaumaturgeBackpackT2;
    public static Predicate<ItemStack> tcBackpackFilter;
    private static Map<EnumBeeModifiers, ItemMagicBeesFrame> frames;

    public static void preInit() {
        combItem = new ItemEnumBased<EnumCombType>(new MagicBeesResourceLocation("beeComb"), EnumCombType.class);
        dropItem = new ItemEnumBased<EnumDropType>(new MagicBeesResourceLocation("drop"), EnumDropType.class);
        pollenItem = new ItemEnumBased<EnumPollenType>(new MagicBeesResourceLocation("pollen"), EnumPollenType.class);
        propolisItem = new ItemEnumBased<EnumPropolisType>(new MagicBeesResourceLocation("propolis"), EnumPropolisType.class);
        waxItem = new ItemEnumBased<EnumWaxType>(new MagicBeesResourceLocation("wax"), EnumWaxType.class);
        resourceItem = new ItemEnumBased<EnumResourceType>(new MagicBeesResourceLocation("resource"), EnumResourceType.class);
        orePartItem = new ItemEnumBased<EnumNuggetType>(new MagicBeesResourceLocation("orepart"), EnumNuggetType.class);
        HashMap framez = Maps.newHashMap();
        magicFrame = new ItemMagicBeesFrame(EnumBeeModifiers.MAGIC);
        framez.put(EnumBeeModifiers.MAGIC, magicFrame);
        resilientFrame = new ItemMagicBeesFrame(EnumBeeModifiers.RESILIENT);
        framez.put(EnumBeeModifiers.RESILIENT, resilientFrame);
        gentleFrame = new ItemMagicBeesFrame(EnumBeeModifiers.GENTLE);
        framez.put(EnumBeeModifiers.GENTLE, gentleFrame);
        metabolicFrame = new ItemMagicBeesFrame(EnumBeeModifiers.METABOLIC);
        framez.put(EnumBeeModifiers.METABOLIC, metabolicFrame);
        necroticFrame = new ItemMagicBeesFrame(EnumBeeModifiers.NECROTIC);
        framez.put(EnumBeeModifiers.NECROTIC, necroticFrame);
        temporalFrame = new ItemMagicBeesFrame(EnumBeeModifiers.TEMPORAL);
        framez.put(EnumBeeModifiers.TEMPORAL, temporalFrame);
        oblivionFrame = new ItemMagicBeesFrame(EnumBeeModifiers.OBLIVION);
        framez.put(EnumBeeModifiers.OBLIVION, oblivionFrame);
        frames = Collections.unmodifiableMap(framez);
        mysteriousMagnet = new ItemMysteriousMagnet();
        moonDial = new ItemMoonDial();
        manasteelgrafter = new ItemManaSteelGrafter();
        manasteelScoop = new ItemManaSteelScoop();
        thaumiumgrafter = new ItemThaumiumGrafter();
        thaumiumScoop = new ItemThaumiumScoop();
        String backpackUid = "backpack.thaumaturge";
        BackpackDefinition def = new BackpackDefinition(new Color(8847558), new Color(0xFFFFFF), tcBackpackFilter);
        BackpackManager.backpackInterface.registerBackpackDefinition(backpackUid, (IBackpackDefinition)def);
        thaumaturgeBackpackT1 = BackpackManager.backpackInterface.createBackpack(backpackUid, EnumBackpackType.NORMAL);
        thaumaturgeBackpackT1.setRegistryName((ResourceLocation)new MagicBeesResourceLocation("backpack_thaumaturge_t1"));
        thaumaturgeBackpackT1.func_77655_b("backpack.thaumaturgeT1");
        thaumaturgeBackpackT1.func_77637_a(MagicBees.creativeTab);
        thaumaturgeBackpackT2 = BackpackManager.backpackInterface.createBackpack(backpackUid, EnumBackpackType.WOVEN);
        thaumaturgeBackpackT2.setRegistryName((ResourceLocation)new MagicBeesResourceLocation("backpack_thaumaturge_t2"));
        thaumaturgeBackpackT2.func_77655_b("backpack.thaumaturgeT2");
        thaumaturgeBackpackT2.func_77637_a(MagicBees.creativeTab);
        jellyBaby = new ItemFood(1, false).func_77848_i().func_185070_a(new PotionEffect(MobEffects.field_76424_c, 5, 1), 1.0f);
        jellyBaby.func_77637_a(MagicBees.creativeTab);
        jellyBaby.setRegistryName((ResourceLocation)new MagicBeesResourceLocation("jelly_babies"));
        Utils.setUnlocalizedName((Item)jellyBaby);
        ItemRegister.fixIronNuggetStuff();
    }

    public static void registerOreDictionary() {
        for (EnumCombType comb : EnumCombType.values()) {
            OreDictionary.registerOre((String)"beeComb", (ItemStack)combItem.getStackFromType(comb));
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{combItem, dropItem, pollenItem, propolisItem, waxItem, resourceItem, orePartItem});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{mysteriousMagnet, moonDial});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{manasteelgrafter, manasteelScoop});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{thaumiumgrafter, thaumiumScoop});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{thaumaturgeBackpackT1, thaumaturgeBackpackT2});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{jellyBaby});
        for (Item item : ItemRegister.getBeeFrames().values()) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    public static Map<EnumBeeModifiers, ItemMagicBeesFrame> getBeeFrames() {
        return frames;
    }

    private static void fixIronNuggetStuff() {
        ironNugget = (Item)Preconditions.checkNotNull((Object)Items.field_191525_da);
    }

    static {
        tcBackpackFilter = s -> true;
    }
}

