/*
 * Decompiled with CFR 0.152.
 */
package magicbees.integration.thaumcraft;

import com.google.common.base.Preconditions;
import forestry.api.recipes.RecipeManagers;
import forestry.apiculture.items.EnumPropolis;
import java.util.Arrays;
import magicbees.init.ItemRegister;
import magicbees.item.types.EnumCombType;
import magicbees.item.types.EnumPropolisType;
import magicbees.item.types.EnumResourceType;
import magicbees.item.types.EnumWaxType;
import magicbees.util.CentrifugeRecipe;
import magicbees.util.MagicBeesResourceLocation;
import magicbees.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.items.resources.ItemCrystalEssence;

public class ThaumcraftRecipes {
    static void addRecipes() {
        ThaumcraftRecipes.registerNormalRecipes();
        ThaumcraftRecipes.registerCentrifugeRecipes();
        ThaumcraftRecipes.registerCarpenterRecipes();
        ThaumcraftRecipes.registerThaumcraftRecipes();
    }

    private static void registerNormalRecipes() {
        ItemStack lf = ItemRegister.resourceItem.getStackFromType(EnumResourceType.LORE_FRAGMENT);
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("lore_fragment"), null, (ItemStack)new ItemStack(ItemsTC.amber), (Object[])new Object[]{"lll", "lll", "lll", Character.valueOf('l'), lf});
        Arrays.stream(EnumResourceType.values()).filter(r -> r.toString().startsWith("TC_DUST_")).forEach(dust -> {
            Aspect aspect1;
            String aspect = dust.toString().replace("TC_DUST_", "").toLowerCase();
            try {
                aspect1 = (Aspect)Aspect.class.getDeclaredField(aspect.toUpperCase()).get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException("Aspect " + aspect + " not found.");
            }
            ItemCrystalEssence crystalEssence = (ItemCrystalEssence)ItemsTC.crystalEssence;
            ItemStack result = new ItemStack((Item)crystalEssence);
            crystalEssence.setAspects(result, new AspectList().add((Aspect)Preconditions.checkNotNull((Object)aspect1), 8));
            GameData.register_impl((IForgeRegistryEntry)new ShapelessRecipes("", result, NonNullList.func_191197_a((int)4, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemRegister.resourceItem.getStackFromType((EnumResourceType)dust)}))).setRegistryName((ResourceLocation)new MagicBeesResourceLocation("tc_shard_" + aspect)));
        });
    }

    private static void registerCentrifugeRecipes() {
        ItemStack magicWax = ItemRegister.waxItem.getStackFromType(EnumWaxType.MAGIC);
        ItemStack propolis = Utils.getApicultureItems().propolis.get(EnumPropolis.NORMAL, 1);
        CentrifugeRecipe recipe = new CentrifugeRecipe(EnumCombType.TC_AIR);
        recipe.addProduct(magicWax, 1.0f);
        recipe.addProduct(new ItemStack(Items.field_151008_G), 0.6f);
        recipe.addProduct(ThaumcraftRecipes.getPropolis(EnumPropolisType.AIR), 0.8f);
        recipe.register(20);
        recipe = new CentrifugeRecipe(EnumCombType.TC_FIRE);
        recipe.addProduct(magicWax, 1.0f);
        recipe.addProduct(new ItemStack(Items.field_151065_br), 0.6f);
        recipe.addProduct(ThaumcraftRecipes.getPropolis(EnumPropolisType.FIRE), 0.8f);
        recipe.register(20);
        recipe = new CentrifugeRecipe(EnumCombType.TC_WATER);
        recipe.addProduct(magicWax, 1.0f);
        recipe.addProduct(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.LIGHT_BLUE.func_176765_a()), 0.6f);
        recipe.addProduct(ThaumcraftRecipes.getPropolis(EnumPropolisType.WATER), 0.8f);
        recipe.register(20);
        recipe = new CentrifugeRecipe(EnumCombType.TC_EARTH);
        recipe.addProduct(magicWax, 1.0f);
        recipe.addProduct(new ItemStack(Items.field_151119_aD), 0.6f);
        recipe.addProduct(ThaumcraftRecipes.getPropolis(EnumPropolisType.EARTH), 0.8f);
        recipe.register(20);
        recipe = new CentrifugeRecipe(EnumCombType.TC_ORDER);
        recipe.addProduct(magicWax, 1.0f);
        recipe.addProduct(new ItemStack(Items.field_151137_ax), 0.6f);
        recipe.addProduct(ThaumcraftRecipes.getPropolis(EnumPropolisType.ORDER), 0.8f);
        recipe.register(20);
        recipe = new CentrifugeRecipe(EnumCombType.TC_ENTROPY);
        recipe.addProduct(magicWax, 1.0f);
        recipe.addProduct(new ItemStack(Items.field_151016_H), 0.6f);
        recipe.addProduct(ThaumcraftRecipes.getPropolis(EnumPropolisType.ENTROPY), 0.8f);
        recipe.register(20);
        recipe = new CentrifugeRecipe(EnumPropolisType.AIR);
        recipe.addProduct(propolis, 1.0f);
        recipe.addProduct(ThaumcraftRecipes.getResource(EnumResourceType.TC_DUST_AIR), 0.9f);
        recipe.register(8);
        recipe = new CentrifugeRecipe(EnumPropolisType.FIRE);
        recipe.addProduct(propolis, 1.0f);
        recipe.addProduct(ThaumcraftRecipes.getResource(EnumResourceType.TC_DUST_FIRE), 0.9f);
        recipe.register(8);
        recipe = new CentrifugeRecipe(EnumPropolisType.WATER);
        recipe.addProduct(propolis, 1.0f);
        recipe.addProduct(ThaumcraftRecipes.getResource(EnumResourceType.TC_DUST_WATER), 0.8f);
        recipe.register(8);
        recipe = new CentrifugeRecipe(EnumPropolisType.EARTH);
        recipe.addProduct(propolis, 1.0f);
        recipe.addProduct(ThaumcraftRecipes.getResource(EnumResourceType.TC_DUST_EARTH), 0.8f);
        recipe.register(8);
        recipe = new CentrifugeRecipe(EnumPropolisType.ORDER);
        recipe.addProduct(propolis, 1.0f);
        recipe.addProduct(ThaumcraftRecipes.getResource(EnumResourceType.TC_DUST_ORDER), 0.8f);
        recipe.register(8);
        recipe = new CentrifugeRecipe(EnumPropolisType.ENTROPY);
        recipe.addProduct(propolis, 1.0f);
        recipe.addProduct(ThaumcraftRecipes.getResource(EnumResourceType.TC_DUST_ENTROPY), 0.8f);
        recipe.register(8);
    }

    private static void registerCarpenterRecipes() {
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("thaumium_backpack"), null, (ItemStack)new ItemStack(ItemRegister.thaumaturgeBackpackT1), (Object[])new Object[]{"sws", "aca", "sws", Character.valueOf('w'), "blockWool", Character.valueOf('s'), "string", Character.valueOf('c'), Item.func_150898_a((Block)Blocks.field_150486_ae), Character.valueOf('a'), "gemAmber"});
        RecipeManagers.carpenterManager.addRecipe(200, new FluidStack(FluidRegistry.WATER, 1000), ItemStack.field_190927_a, new ItemStack(ItemRegister.thaumaturgeBackpackT2), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Items.field_151045_i, Character.valueOf('W'), Utils.getCoreItems().craftingMaterial.getWovenSilk(), Character.valueOf('T'), new ItemStack(ItemRegister.thaumaturgeBackpackT1)});
    }

    private static void registerThaumcraftRecipes() {
        ThaumcraftRecipes.mbCrucibleRecipes();
        ThaumcraftRecipes.mbArcaneRecipes();
        ThaumcraftRecipes.mbInfusionRecipes();
    }

    private static ItemStack getPropolis(EnumPropolisType propolis) {
        return ItemRegister.propolisItem.getStackFromType(propolis);
    }

    private static ItemStack getResource(EnumResourceType resource) {
        return ItemRegister.resourceItem.getStackFromType(resource);
    }

    private static void mbArcaneRecipes() {
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("magicbees", "thaumium_scoop"), (IArcaneRecipe)new ShapedArcaneRecipe(new ResourceLocation(""), "MB_Scoop", 10, new AspectList(), ItemRegister.thaumiumScoop, new Object[]{"SWS", "STS", " T ", Character.valueOf('S'), "stickWood", Character.valueOf('W'), "blockWool", Character.valueOf('T'), "ingotThaumium"}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("magicbees", "thaumium_grafter"), (IArcaneRecipe)new ShapedArcaneRecipe(new ResourceLocation(""), "MB_Grafter", 10, new AspectList(), ItemRegister.thaumiumgrafter, new Object[]{"  T", " S ", "S  ", Character.valueOf('S'), "stickWood", Character.valueOf('T'), "ingotThaumium"}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("magicbees", "essence_oblivion"), (IArcaneRecipe)new ShapelessArcaneRecipe(new ResourceLocation(""), "MB_EssenceOblivion", 500, new AspectList(), ThaumcraftRecipes.getResource(EnumResourceType.ESSENCE_SCORNFUL_OBLIVION), new Object[]{new ItemStack(Blocks.field_150380_bt), ThaumcraftRecipes.getResource(EnumResourceType.DIMENSIONAL_SINGULARITY)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("magicbees", "frame_magic"), (IArcaneRecipe)new ShapedArcaneRecipe(new ResourceLocation(""), "MB_FrameMagic", 100, new AspectList(), new ItemStack((Item)ItemRegister.magicFrame), new Object[]{"SSS", "SFS", "SSS", Character.valueOf('S'), "stickWood", Character.valueOf('F'), new ItemStack(ItemsTC.fabric)}));
    }

    private static void mbCrucibleRecipes() {
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("magicbees", "essence_life"), (CrucibleRecipe)new CrucibleRecipe("MB_EssenceLife", ThaumcraftRecipes.getResource(EnumResourceType.ESSENCE_FALSE_LIFE), (Object)new ItemStack((Block)Blocks.field_150328_O), new AspectList().add(Aspect.PLANT, 15).add(Aspect.EXCHANGE, 15)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("magicbees", "essence_unstable"), (CrucibleRecipe)new CrucibleRecipe("MB_EssenceUnstable", ThaumcraftRecipes.getResource(EnumResourceType.ESSENCE_FICKLE_PERMANENCE), (Object)new ItemStack(Blocks.field_150424_aL), new AspectList().add(Aspect.ENTROPY, 30).add(Aspect.EXCHANGE, 30)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("magicbees", "essence_time"), (CrucibleRecipe)new CrucibleRecipe("MB_EssenceTime", ThaumcraftRecipes.getResource(EnumResourceType.ESSENCE_LOST_TIME), (Object)new ItemStack(Items.field_151113_aN), new AspectList().add(Aspect.ORDER, 40).add(Aspect.VOID, 40).add(Aspect.TRAP, 40)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("magicbees", "essence_death"), (CrucibleRecipe)new CrucibleRecipe("MB_EssenceDeath", ThaumcraftRecipes.getResource(EnumResourceType.ESSENCE_SHALLOW_GRAVE), (Object)new ItemStack(Items.field_151078_bh), new AspectList().add(Aspect.ENTROPY, 15).add(Aspect.DEATH, 15)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("magicbees", "essence_armor"), (CrucibleRecipe)new CrucibleRecipe("MB_EssenceArmor", ThaumcraftRecipes.getResource(EnumResourceType.ESSENCE_EVERLASTING_DURABILITY), (Object)new ItemStack(Items.field_151116_aA), new AspectList().add(Aspect.EXCHANGE, 10).add(Aspect.PROTECT, 10)));
    }

    private static void mbInfusionRecipes() {
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("magicbees", "dimensional_singularity"), (InfusionRecipe)new InfusionRecipe("MB_DimensionalSingularity", (Object)ThaumcraftRecipes.getResource(EnumResourceType.DIMENSIONAL_SINGULARITY), 2, new AspectList().add(Aspect.ELDRITCH, 20).add(Aspect.EXCHANGE, 40), (Object)"blockGold", new Object[]{new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151079_bi)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("magicbees", "dimensional_singularity"), (InfusionRecipe)new InfusionRecipe("MB_DimensionalSingularity", (Object)ThaumcraftRecipes.getResource(EnumResourceType.DIMENSIONAL_SINGULARITY), 2, new AspectList().add(Aspect.ELDRITCH, 20).add(Aspect.EXCHANGE, 40), (Object)"blockGold", new Object[]{new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151079_bi)}));
    }
}

