/*
 * Decompiled with CFR 0.152.
 */
package magicbees.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import magicbees.MagicBees;
import magicbees.util.Config;
import magicbees.util.MagicBeesResourceLocation;
import magicbees.util.Utils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMysteriousMagnet
extends Item {
    private static final float FUDGE_FACTOR = 0.2f;

    public ItemMysteriousMagnet() {
        this.setRegistryName(new MagicBeesResourceLocation("mysteriousMagnet"));
        Utils.setUnlocalizedName(this);
        this.setNoRepair();
        this.func_77627_a(true);
        this.func_77637_a(MagicBees.creativeTab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String s = String.format(I18n.func_74838_a((String)"misc.level"), this.getMagnetLevel(stack));
        if (this.isMagnetActive(stack)) {
            tooltip.add(String.format(I18n.func_74838_a((String)"misc.magnetActive"), s));
        } else {
            tooltip.add(String.format(I18n.func_74838_a((String)"misc.magnetInactive"), s));
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof EntityLivingBase && this.isMagnetActive(itemStack) && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            float radius = this.getRadius(itemStack) - 0.2f;
            AxisAlignedBB bounds = player.func_174813_aQ().func_72321_a((double)radius, (double)radius, (double)radius).func_72321_a((double)(-radius), (double)(-radius), (double)(-radius));
            if (!world.field_72995_K) {
                bounds.func_72321_a((double)0.2f, (double)0.2f, (double)0.2f);
                if (7 <= this.getMagnetLevel(itemStack)) {
                    List arrows = world.func_72872_a(EntityArrow.class, bounds);
                    for (EntityArrow arrow : arrows) {
                        if ((arrow.field_70251_a == EntityArrow.PickupStatus.ALLOWED || world.field_73012_v.nextFloat() < 0.3f) && arrow.field_70250_c != entity) {
                            EntityItem replacement = new EntityItem(world, arrow.field_70165_t, arrow.field_70163_u, arrow.field_70161_v, new ItemStack(Items.field_151032_g));
                            world.func_72838_d((Entity)replacement);
                        }
                        world.func_72900_e((Entity)arrow);
                    }
                }
            }
            List list = world.func_72872_a(EntityItem.class, bounds);
            for (EntityItem e : list) {
                if (e.field_70292_b < 10) continue;
                double x = player.field_70165_t - e.field_70165_t;
                double y = player.field_70163_u - e.field_70163_u;
                double z = player.field_70161_v - e.field_70161_v;
                double length = Math.sqrt(x * x + y * y + z * z) * 2.0;
                x = x / length + player.field_70159_w / 2.0;
                y = y / length + player.field_70181_x / 2.0;
                z = z / length + player.field_70179_y / 2.0;
                e.field_70159_w = x;
                e.field_70181_x = y;
                e.field_70179_y = z;
                e.field_70160_al = true;
                if (e.field_70123_F) {
                    e.field_70181_x += 1.0;
                }
                if (!(world.field_73012_v.nextFloat() < 0.2f)) continue;
                float pitch = 0.85f - world.field_73012_v.nextFloat() * 3.0f / 10.0f;
                if (!Config.magnetSound) continue;
                world.func_184134_a(e.field_70165_t, e.field_70163_u, e.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.MASTER, 0.6f, pitch, false);
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i <= this.getMaximumLevel(); ++i) {
            subItems.add((Object)new ItemStack((Item)this, 1, i * 2));
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.isMagnetActive(stack);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            this.toggleActive(stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private void toggleActive(ItemStack itemStack) {
        itemStack.func_77964_b(itemStack.func_77952_i() ^ 1);
    }

    public boolean isMagnetActive(ItemStack itemStack) {
        return itemStack.func_77973_b() == this && this.isMagnetActive(itemStack.func_77952_i());
    }

    private boolean isMagnetActive(int damage) {
        return (damage & 1) == 1;
    }

    private int getMaximumLevel() {
        return Config.magnetMaxLevel;
    }

    private int getMagnetLevel(ItemStack itemStack) {
        return itemStack.func_77952_i() >> 1;
    }

    private float getRadius(ItemStack itemStack) {
        return Config.magnetBaseRange + Config.magnetLevelMultiplier * (float)this.getMagnetLevel(itemStack);
    }
}

