/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.mffs.common.modules;

import com.nekokittygames.mffs.api.PointXYZ;
import com.nekokittygames.mffs.common.IModularProjector;
import com.nekokittygames.mffs.common.item.ModItems;
import com.nekokittygames.mffs.common.modules.Module3DBase;
import com.nekokittygames.mffs.common.options.ItemProjectorOptionBase;
import com.nekokittygames.mffs.common.options.ItemProjectorOptionBlockBreaker;
import com.nekokittygames.mffs.common.options.ItemProjectorOptionCamoflage;
import com.nekokittygames.mffs.common.options.ItemProjectorOptionDefenseStation;
import com.nekokittygames.mffs.common.options.ItemProjectorOptionFieldFusion;
import com.nekokittygames.mffs.common.options.ItemProjectorOptionFieldManipulator;
import com.nekokittygames.mffs.common.options.ItemProjectorOptionForceFieldJammer;
import com.nekokittygames.mffs.common.options.ItemProjectorOptionLight;
import com.nekokittygames.mffs.common.options.ItemProjectorOptionMobDefence;
import com.nekokittygames.mffs.common.options.ItemProjectorOptionSponge;
import com.nekokittygames.mffs.common.tileentity.TileEntityProjector;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;

public class ItemProjectorModuleSphere
extends Module3DBase {
    public ItemProjectorModuleSphere() {
        super("module_sphere");
        this.setForceFieldModuleType(3);
    }

    @Override
    public boolean supportsDistance() {
        return true;
    }

    @Override
    public boolean supportsStrength() {
        return true;
    }

    @Override
    public boolean supportsMatrix() {
        return false;
    }

    @Override
    public void calculateField(IModularProjector projector, Set<PointXYZ> ffLocs, Set<PointXYZ> ffInterior) {
        int radius = projector.countItemsInSlot(IModularProjector.Slots.Distance) + 4;
        boolean half = ((TileEntityProjector)projector).hasOption(ModItems.OPTION_FIELD_MANIPULATOR, true);
        for (int y1 = 0; y1 <= radius; ++y1) {
            for (int x1 = 0; x1 <= radius; ++x1) {
                for (int z1 = 0; z1 <= radius; ++z1) {
                    int dist = (int)Math.round(Math.sqrt(x1 * x1 + y1 * y1 + z1 * z1));
                    if (dist <= radius && dist > radius - (projector.countItemsInSlot(IModularProjector.Slots.Strength) + 1)) {
                        ItemProjectorModuleSphere.addHalfOctant(ffLocs, x1, y1, z1);
                    } else if (dist <= radius) {
                        ItemProjectorModuleSphere.addHalfOctant(ffInterior, x1, y1, z1);
                    }
                    if (half) continue;
                    if (dist <= radius && dist > radius - (projector.countItemsInSlot(IModularProjector.Slots.Strength) + 1)) {
                        ItemProjectorModuleSphere.addHalfOctant(ffLocs, x1, -y1, z1);
                        continue;
                    }
                    if (dist > radius) continue;
                    ItemProjectorModuleSphere.addHalfOctant(ffInterior, x1, -y1, z1);
                }
            }
        }
    }

    private static void addHalfOctant(Set<PointXYZ> pointXYZSet, int x, int y, int z) {
        pointXYZSet.add(new PointXYZ(new BlockPos(x, y, z), 0));
        pointXYZSet.add(new PointXYZ(new BlockPos(-x, y, z), 0));
        pointXYZSet.add(new PointXYZ(new BlockPos(x, y, -z), 0));
        pointXYZSet.add(new PointXYZ(new BlockPos(-x, y, -z), 0));
    }

    public static boolean supportsOption(ItemProjectorOptionBase item) {
        if (item instanceof ItemProjectorOptionCamoflage) {
            return true;
        }
        if (item instanceof ItemProjectorOptionDefenseStation) {
            return true;
        }
        if (item instanceof ItemProjectorOptionFieldFusion) {
            return true;
        }
        if (item instanceof ItemProjectorOptionFieldManipulator) {
            return true;
        }
        if (item instanceof ItemProjectorOptionForceFieldJammer) {
            return true;
        }
        if (item instanceof ItemProjectorOptionMobDefence) {
            return true;
        }
        if (item instanceof ItemProjectorOptionSponge) {
            return true;
        }
        if (item instanceof ItemProjectorOptionBlockBreaker) {
            return true;
        }
        return item instanceof ItemProjectorOptionLight;
    }

    @Override
    public boolean supportsOption(Item item) {
        if (item instanceof ItemProjectorOptionCamoflage) {
            return true;
        }
        if (item instanceof ItemProjectorOptionDefenseStation) {
            return true;
        }
        if (item instanceof ItemProjectorOptionFieldFusion) {
            return true;
        }
        if (item instanceof ItemProjectorOptionFieldManipulator) {
            return true;
        }
        if (item instanceof ItemProjectorOptionForceFieldJammer) {
            return true;
        }
        if (item instanceof ItemProjectorOptionMobDefence) {
            return true;
        }
        if (item instanceof ItemProjectorOptionSponge) {
            return true;
        }
        if (item instanceof ItemProjectorOptionBlockBreaker) {
            return true;
        }
        return item instanceof ItemProjectorOptionLight;
    }
}

