/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.block.decorative;

import com.github.sokyranthedragon.mia.block.base.BlockBaseStairs;
import com.github.sokyranthedragon.mia.block.decorative.BlockMiaWallFutureMC;
import com.github.sokyranthedragon.mia.block.decorative.BlockMiaWallQuark;
import com.github.sokyranthedragon.mia.block.decorative.BlockNewSandstone;
import com.github.sokyranthedragon.mia.block.decorative.BlockNewSandstoneSlab;
import com.github.sokyranthedragon.mia.block.decorative.BlockNewSandstoneSlabDouble;
import com.github.sokyranthedragon.mia.block.decorative.IBlockEntry;
import com.github.sokyranthedragon.mia.config.GenericAdditionsConfig;
import com.github.sokyranthedragon.mia.core.MiaBlocks;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.futuremc.FutureMc;
import com.github.sokyranthedragon.mia.utilities.QuarkUtils;
import com.github.sokyranthedragon.mia.utilities.RegisterUtils;
import com.github.sokyranthedragon.mia.utilities.annotations.FieldsAreNullableByDefault;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.registries.IForgeRegistry;
import vazkii.quark.base.block.BlockQuarkWall;
import vazkii.quark.building.feature.MoreSandstone;
import vazkii.quark.building.feature.VanillaWalls;

@MethodsReturnNonnullByDefault
@FieldsAreNullableByDefault
public class SandstoneEntry
implements IBlockEntry {
    public Block sandstone;
    public BlockSlab slab;
    public BlockSlab slabDouble;
    public BlockStairs brickStairs;
    public Block wallQuark;
    public Block wallFutureMc;

    protected SandstoneEntry() {
    }

    protected SandstoneEntry(Block sandstone, String sandName, CreativeTabs creativeTab, MapColor mapColor, boolean enableQuarkWalls) {
        String sandstoneName = sandName + "_sandstone_";
        if (ModIds.QUARK.isLoaded && QuarkUtils.isFeatureEnabled(MoreSandstone.class) && GenericAdditionsConfig.moreSandstone.moreSandstoneQuarkEnabled || GenericAdditionsConfig.moreSandstone.forceMoreSandstone) {
            this.sandstone = MiaBlocks.registerBlock(new BlockNewSandstone(sandstoneName + "new", creativeTab, mapColor));
            if (ModIds.QUARK.isLoaded && MoreSandstone.enableStairsAndSlabs || GenericAdditionsConfig.moreSandstone.forceMoreSandstoneStairsAndSlabs) {
                BlockNewSandstoneSlab slabs = MiaBlocks.registerBlock(new BlockNewSandstoneSlab(sandstoneName + "new_slab", creativeTab, mapColor));
                this.slab = slabs;
                this.slabDouble = MiaBlocks.registerBlock(new BlockNewSandstoneSlabDouble(sandstoneName + "new_slab_double", creativeTab, slabs, mapColor));
                this.brickStairs = MiaBlocks.registerBlock(new BlockBaseStairs(sandstone.func_176223_P(), sandstoneName + "stairs_brick", creativeTab));
            }
            if (ModIds.QUARK.isLoaded && enableQuarkWalls && (QuarkUtils.isFeatureEnabled(VanillaWalls.class) || GenericAdditionsConfig.moreSandstone.forceMoreSandstoneQuarkWalls)) {
                this.wallQuark = MiaBlocks.registerBlock(SandstoneEntry.getQuarkWall(sandstone, sandstoneName, creativeTab, mapColor));
                BlockQuarkWall.initWall((Block)sandstone, (int)0, (Block)this.wallQuark);
            }
        }
        if (ModIds.FUTURE_MC.isLoaded && GenericAdditionsConfig.moreSandstone.sandstoneWallsFutureMcEnabled) {
            this.wallFutureMc = MiaBlocks.registerBlock(SandstoneEntry.getFutureMcWall(sandstoneName, creativeTab, sandstone.func_176223_P(), mapColor));
        }
    }

    @Optional.Method(modid="quark")
    private static Block getQuarkWall(Block sandstone, String sandstoneName, CreativeTabs creativeTab, MapColor mapColor) {
        return new BlockMiaWallQuark(sandstoneName + "wall_quark", creativeTab, sandstone.func_176223_P(), mapColor);
    }

    @Optional.Method(modid="futuremc")
    private static Block getFutureMcWall(String sandstoneName, CreativeTabs creativeTab, IBlockState sandstoneState, MapColor mapColor) {
        return new BlockMiaWallFutureMC(sandstoneName + "futuremc_wall", creativeTab, sandstoneState, mapColor);
    }

    @Override
    public boolean isEmpty() {
        return this.sandstone == null && this.slab == null && this.slabDouble != null && this.brickStairs == null && this.wallQuark == null && this.wallFutureMc == null;
    }

    @Nullable
    public static SandstoneEntry init(Block sandstone, String sandName, CreativeTabs creativeTab, MapColor mapColor, boolean enableQuarkWalls) {
        SandstoneEntry entry = new SandstoneEntry(sandstone, sandName, creativeTab, mapColor, enableQuarkWalls);
        if (entry.isEmpty()) {
            return null;
        }
        return entry;
    }

    public static void registerItemblocks(@Nullable SandstoneEntry sandstone, IForgeRegistry<Item> registry) {
        if (sandstone != null) {
            RegisterUtils.registerItemblockSlab(sandstone.slab, sandstone.slabDouble, registry);
        }
    }

    public static void registerRecipes(@Nullable SandstoneEntry sandstone, Block source) {
        if (sandstone != null && ModIds.FUTURE_MC.isLoaded) {
            ArrayList<ItemStack> toRegister = new ArrayList<ItemStack>(7);
            SandstoneEntry.addIfNotNull(toRegister, sandstone.sandstone, 0);
            SandstoneEntry.addIfNotNull(toRegister, sandstone.sandstone, 1);
            SandstoneEntry.addIfNotNull(toRegister, (Block)sandstone.slab, 0);
            SandstoneEntry.addIfNotNull(toRegister, (Block)sandstone.slab, 1);
            SandstoneEntry.addIfNotNull(toRegister, (Block)sandstone.brickStairs);
            SandstoneEntry.addIfNotNull(toRegister, sandstone.wallQuark);
            SandstoneEntry.addIfNotNull(toRegister, sandstone.wallFutureMc);
            if (toRegister.size() > 0) {
                SandstoneEntry.registerStonecutter(source, toRegister);
            }
        }
    }

    public static void registerChiselRecipes(SandstoneEntry sandstone, String chiselName, BiConsumer<String, ItemStack[]> chiselSender) {
        if (ModIds.CHISEL.isLoaded && chiselName != null && chiselSender != null) {
            ArrayList<ItemStack> toRegister = new ArrayList<ItemStack>(7);
            SandstoneEntry.addIfNotNull(toRegister, sandstone.sandstone, 0);
            SandstoneEntry.addIfNotNull(toRegister, sandstone.sandstone, 1);
            if (toRegister.size() > 0) {
                chiselSender.accept(chiselName, toRegister.toArray(new ItemStack[2]));
            }
        }
    }

    @Optional.Method(modid="futuremc")
    protected static void registerStonecutter(Block source, Collection<ItemStack> toRegister) {
        FutureMc.addStonecutterRecipes(new ItemStack(source), toRegister.toArray(new ItemStack[0]));
    }

    private static void addIfNotNull(List<ItemStack> list, Block block) {
        SandstoneEntry.addIfNotNull(list, block, 0);
    }

    private static void addIfNotNull(List<ItemStack> list, Block block, int meta) {
        if (block != null) {
            if (block instanceof BlockNewSandstoneSlab) {
                list.add(new ItemStack(block, 2, meta));
            } else {
                list.add(new ItemStack(block, 1, meta));
            }
        }
    }
}

