/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="mia", name="mia/hatchery")
@Config.LangKey(value="mia.config.hatchery.title")
@Mod.EventBusSubscriber(modid="mia")
public class HatcheryConfiguration {
    @Config.Name(value="Enable Hatchery additions")
    @Config.Comment(value={"Set to false to completely disable new Hatchery additions"})
    @Config.LangKey(value="mia.config.hatchery.additions_enabled")
    @Config.RequiresMcRestart
    public static boolean hatcheryAdditionsEnabled = true;
    @Config.Name(value="Disable chicken display in nesting pen")
    @Config.Comment(value={"Set to true to disable chickens from being rendered in nesting pens", "This should hopefully improve performance issues that I've encountered myself with a big chicken farm"})
    public static boolean disableNestingPenChickenDisplay = false;
    @Config.Name(value="Enable external integrations")
    @Config.Comment(value={"Set to false to prevent other mods from integrating with Hatchery"})
    @Config.LangKey(value="mia.config.shared.enable_external_integrations")
    @Config.RequiresMcRestart
    public static boolean externalIntegrationsEnabled = true;
    @Config.Name(value="Enable external lucky egg loot")
    @Config.Comment(value={"Set to true to enable any lucky egg loot file unrelated to integrated mods to be loaded from inside the config folder", "Even if this is option is enabled the configuration for integrated mods won't be if they themselves are disabled", "Using this instead of editing the loot in Hatchery config allows you to keep it unchanged while still adding your own items"})
    @Config.LangKey(value="mia.config.hatchery.register_custom_eggs")
    @Config.RequiresMcRestart
    public static boolean registerCustomLuckyEggLoot = false;

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("mia")) {
            ConfigManager.sync((String)"mia", (Config.Type)Config.Type.INSTANCE);
        }
    }
}

